/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.media.Cea708CCWidget;
import android.media.Cea708CaptionTrack;
import android.media.MediaFormat;
import android.media.SubtitleController;
import android.media.SubtitleTrack;

public class Cea708CaptionRenderer
extends SubtitleController.Renderer {
    private final Context mContext;
    private Cea708CCWidget mCCWidget;

    public Cea708CaptionRenderer(Context context) {
        this.mContext = context;
    }

    @Override
    public boolean supports(MediaFormat format) {
        if (format.containsKey("mime")) {
            String mimeType = format.getString("mime");
            return "text/cea-708".equals(mimeType);
        }
        return false;
    }

    @Override
    public SubtitleTrack createTrack(MediaFormat format) {
        String mimeType = format.getString("mime");
        if ("text/cea-708".equals(mimeType)) {
            if (this.mCCWidget == null) {
                this.mCCWidget = new Cea708CCWidget(this.mContext);
            }
            return new Cea708CaptionTrack(this.mCCWidget, format);
        }
        throw new RuntimeException("No matching format: " + format.toString());
    }
}

