/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.wifi.WifiChannel;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Collection;

public class ScanSettings
implements Parcelable {
    public Collection<WifiChannel> channelSet;
    public static final Parcelable.Creator<ScanSettings> CREATOR = new Parcelable.Creator<ScanSettings>(){

        @Override
        public ScanSettings createFromParcel(Parcel in) {
            ScanSettings settings = new ScanSettings();
            int size = in.readInt();
            if (size > 0) {
                settings.channelSet = new ArrayList<WifiChannel>(size);
                while (size-- > 0) {
                    settings.channelSet.add(WifiChannel.CREATOR.createFromParcel(in));
                }
            }
            return settings;
        }

        public ScanSettings[] newArray(int size) {
            return new ScanSettings[size];
        }
    };

    public ScanSettings() {
    }

    public ScanSettings(ScanSettings source) {
        if (source.channelSet != null) {
            this.channelSet = new ArrayList<WifiChannel>(source.channelSet);
        }
    }

    public boolean isValid() {
        for (WifiChannel channel : this.channelSet) {
            if (channel.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.channelSet == null ? 0 : this.channelSet.size());
        if (this.channelSet != null) {
            for (WifiChannel channel : this.channelSet) {
                channel.writeToParcel(out, flags);
            }
        }
    }
}

