/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.branchConfig.InfoReliability;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.NewRootBunch;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.SelectLocationDialog;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;

public class BranchConfigurationDialog
extends DialogWrapper {
    private JPanel myTopPanel;
    private TextFieldWithBrowseButton myTrunkLocationTextField;
    private JBList<String> myBranchLocationsList;
    @NotNull
    private final MyListModel myBranchLocationsModel;
    private JPanel myListPanel;
    private JLabel myErrorPrompt;
    @NotNull
    private final NewRootBunch mySvnBranchConfigManager;
    @NotNull
    private final VirtualFile myRoot;

    public BranchConfigurationDialog(@NotNull Project project, @NotNull SvnBranchConfigurationNew configuration, @NotNull SVNURL rootUrl, @NotNull VirtualFile root, @NotNull String url) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/branchConfig/BranchConfigurationDialog", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/idea/svn/branchConfig/BranchConfigurationDialog", "<init>"));
        }
        if (rootUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootUrl", "org/jetbrains/idea/svn/branchConfig/BranchConfigurationDialog", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/idea/svn/branchConfig/BranchConfigurationDialog", "<init>"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/branchConfig/BranchConfigurationDialog", "<init>"));
        }
        super(project, true);
        this.myRoot = root;
        this.$$$setupUI$$$();
        this.init();
        this.setTitle(SvnBundle.message("configure.branches.title", new Object[0]));
        if (StringUtil.isEmptyOrSpaces((String)configuration.getTrunkUrl())) {
            configuration.setTrunkUrl(url);
        }
        this.mySvnBranchConfigManager = SvnBranchConfigurationManager.getInstance(project).getSvnBranchConfigManager();
        this.myTrunkLocationTextField.setText(configuration.getTrunkUrl());
        this.myTrunkLocationTextField.addActionListener(e -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/branchConfig/BranchConfigurationDialog", "lambda$new$0"));
            }
            if (rootUrl == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootUrl", "org/jetbrains/idea/svn/branchConfig/BranchConfigurationDialog", "lambda$new$0"));
            }
            Pair<SVNURL, SVNURL> selectionData = SelectLocationDialog.selectLocation(project, rootUrl);
            if (selectionData != null && selectionData.first != null) {
                this.myTrunkLocationTextField.setText(((SVNURL)selectionData.first).toString());
            }
        });
        TrunkUrlValidator trunkUrlValidator = new TrunkUrlValidator(rootUrl, configuration);
        this.myTrunkLocationTextField.getTextField().getDocument().addDocumentListener((DocumentListener)((Object)trunkUrlValidator));
        trunkUrlValidator.textChanged(null);
        this.myErrorPrompt.setUI((LabelUI)new MultiLineLabelUI());
        this.myErrorPrompt.setForeground(SimpleTextAttributes.ERROR_ATTRIBUTES.getFgColor());
        this.myBranchLocationsModel = new MyListModel(configuration);
        this.myBranchLocationsList = new JBList((ListModel)this.myBranchLocationsModel);
        this.myListPanel.add((Component)this.wrapLocationsWithToolbar(project, rootUrl), "Center");
    }

    @NotNull
    private JPanel wrapLocationsWithToolbar(final @NotNull Project project, final @NotNull SVNURL rootUrl) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/branchConfig/BranchConfigurationDialog", "wrapLocationsWithToolbar"));
        }
        if (rootUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootUrl", "org/jetbrains/idea/svn/branchConfig/BranchConfigurationDialog", "wrapLocationsWithToolbar"));
        }
        JPanel jPanel = ToolbarDecorator.createDecorator(this.myBranchLocationsList).setAddAction(new AnActionButtonRunnable(){
            @Nullable
            private SVNURL usedRootUrl;

            public void run(AnActionButton button) {
                Pair<SVNURL, SVNURL> result = SelectLocationDialog.selectLocation(project, (SVNURL)ObjectUtils.notNull((Object)this.usedRootUrl, (Object)rootUrl));
                if (result != null) {
                    SVNURL selectedUrl = (SVNURL)result.first;
                    this.usedRootUrl = (SVNURL)result.second;
                    if (selectedUrl != null) {
                        String selectedUrlValue = selectedUrl.toString();
                        if (!BranchConfigurationDialog.this.myBranchLocationsModel.getConfiguration().getBranchUrls().contains(selectedUrlValue)) {
                            BranchConfigurationDialog.this.myBranchLocationsModel.getConfiguration().addBranches(selectedUrlValue, new InfoStorage<List<SvnBranchItem>>(new ArrayList(), InfoReliability.empty));
                            BranchConfigurationDialog.this.mySvnBranchConfigManager.reloadBranchesAsync(BranchConfigurationDialog.this.myRoot, selectedUrlValue, InfoReliability.setByUser);
                            BranchConfigurationDialog.this.myBranchLocationsModel.fireItemAdded();
                            BranchConfigurationDialog.this.myBranchLocationsList.setSelectedIndex(BranchConfigurationDialog.this.myBranchLocationsModel.getSize() - 1);
                        }
                    }
                }
            }
        }).setRemoveAction(button -> {
            int selectedIndex = this.myBranchLocationsList.getSelectedIndex();
            for (String url : this.myBranchLocationsList.getSelectedValuesList()) {
                int index = this.myBranchLocationsModel.getConfiguration().getBranchUrls().indexOf(url);
                this.myBranchLocationsModel.getConfiguration().removeBranch(url);
                this.myBranchLocationsModel.fireItemRemoved(index);
            }
            if (this.myBranchLocationsModel.getSize() > 0) {
                selectedIndex = Math.min(selectedIndex, this.myBranchLocationsModel.getSize() - 1);
                this.myBranchLocationsList.setSelectedIndex(selectedIndex);
            }
        }).disableUpDownActions().setToolbarPosition(ActionToolbarPosition.BOTTOM).createPanel();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/branchConfig/BranchConfigurationDialog", "wrapLocationsWithToolbar"));
        }
        return jPanel;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myTopPanel;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "Subversion.BranchConfigurationDialog";
    }

    public static void configureBranches(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/branchConfig/BranchConfigurationDialog", "configureBranches"));
        }
        if (file == null) {
            return;
        }
        RootUrlInfo wcRoot = SvnVcs.getInstance(project).getSvnFileUrlMapping().getWcRootForFilePath(VfsUtilCore.virtualToIoFile((VirtualFile)file));
        if (wcRoot == null) {
            return;
        }
        SvnBranchConfigurationNew configuration = SvnBranchConfigurationManager.getInstance(project).get(file);
        SvnBranchConfigurationNew clonedConfiguration = configuration.copy();
        if (new BranchConfigurationDialog(project, clonedConfiguration, wcRoot.getRepositoryUrlUrl(), file, wcRoot.getUrl()).showAndGet()) {
            SvnBranchConfigurationManager.getInstance(project).setConfiguration(file, clonedConfiguration);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        JPanel jPanel2;
        this.myTopPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("configure.branches.branch.locations"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myListPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("configure.branches.trunk.location"));
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTrunkLocationTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myErrorPrompt = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel2.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static class MyListModel
    extends AbstractListModel<String> {
        @NotNull
        private final SvnBranchConfigurationNew myConfiguration;
        private List<String> myBranchUrls;

        public MyListModel(@NotNull SvnBranchConfigurationNew configuration) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/idea/svn/branchConfig/BranchConfigurationDialog$MyListModel", "<init>"));
            }
            this.myConfiguration = configuration;
            this.myBranchUrls = this.myConfiguration.getBranchUrls();
        }

        @NotNull
        public SvnBranchConfigurationNew getConfiguration() {
            SvnBranchConfigurationNew svnBranchConfigurationNew = this.myConfiguration;
            if (svnBranchConfigurationNew == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/branchConfig/BranchConfigurationDialog$MyListModel", "getConfiguration"));
            }
            return svnBranchConfigurationNew;
        }

        @Override
        public int getSize() {
            return this.myBranchUrls.size();
        }

        @Override
        public String getElementAt(int index) {
            return this.myBranchUrls.get(index);
        }

        public void fireItemAdded() {
            int index = this.myConfiguration.getBranchUrls().size() - 1;
            this.myBranchUrls = this.myConfiguration.getBranchUrls();
            super.fireIntervalAdded(this, index, index);
        }

        public void fireItemRemoved(int index) {
            this.myBranchUrls = this.myConfiguration.getBranchUrls();
            super.fireIntervalRemoved(this, index, index);
        }
    }

    private class TrunkUrlValidator
    extends DocumentAdapter {
        private final SVNURL myRootUrl;
        private final SvnBranchConfigurationNew myConfiguration;

        private TrunkUrlValidator(SVNURL rootUrl, SvnBranchConfigurationNew configuration) {
            this.myRootUrl = rootUrl;
            this.myConfiguration = configuration;
        }

        protected void textChanged(DocumentEvent e) {
            SVNURL url = this.parseUrl(BranchConfigurationDialog.this.myTrunkLocationTextField.getText());
            if (url != null) {
                boolean areNotSame;
                boolean isAncestor = SVNURLUtil.isAncestor((SVNURL)this.myRootUrl, (SVNURL)url);
                boolean bl = areNotSame = isAncestor && !url.equals((Object)this.myRootUrl);
                if (areNotSame) {
                    this.myConfiguration.setTrunkUrl(url.toDecodedString());
                }
                BranchConfigurationDialog.this.myErrorPrompt.setText(areNotSame ? "" : SvnBundle.message("configure.branches.error.wrong.url", this.myRootUrl));
            }
        }

        @Nullable
        private SVNURL parseUrl(@NotNull String url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/branchConfig/BranchConfigurationDialog$TrunkUrlValidator", "parseUrl"));
            }
            SVNURL result = null;
            try {
                result = SvnUtil.createUrl(url);
            }
            catch (SvnBindException e) {
                BranchConfigurationDialog.this.myErrorPrompt.setText(e.getMessage());
            }
            return result;
        }
    }
}

