/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.config;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.config.PatternsListener;
import org.jetbrains.idea.svn.config.RepositoryUrlsListener;
import org.jetbrains.idea.svn.config.SvnServerFileKeys;
import org.jetbrains.idea.svn.config.TestConnectionPerformer;

public class ConfigureProxiesOptionsPanel
implements RepositoryUrlsListener {
    private JPanel myMainPanel;
    private JTextField myServerField;
    private JTextField myUserField;
    private JTextField myPortField;
    private JPasswordField myPasswordField;
    private JTextArea myUrlPatterns;
    private JTextArea myExceptions;
    private JTextField myTimeoutField;
    private JCheckBox myTrustDefaultCAsCheckBox;
    private JPasswordField myClientCertificatePasswordField;
    private JButton myTestConnectionButton;
    private JTextField myPathToCertificatesField;
    private TextFieldWithBrowseButton myClientCertificatePathField;
    private JList myRepositoriesList;
    private boolean myIsDefault;
    private final Runnable myValidator;
    private PatternsListener myPatternsListener;
    private final Map<JComponent, String> myComponent2Key;
    private final Map<String, JComponent> myKey2Component;
    private final TestConnectionPerformer myTestConnectionPerformer;

    @Override
    public void onListChanged(List<String> urls) {
        String value = (String)this.myRepositoriesList.getSelectedValue();
        this.myRepositoriesList.removeAll();
        this.myRepositoriesList.setListData(urls.toArray());
        if (value != null) {
            ListModel model = this.myRepositoriesList.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                String element = (String)model.getElementAt(i);
                if (!value.equals(element)) continue;
                this.myRepositoriesList.setSelectedIndex(i);
            }
        }
        this.myValidator.run();
    }

    public List<String> getRepositories() {
        ListModel model = this.myRepositoriesList.getModel();
        ArrayList<String> result = new ArrayList<String>(model.getSize());
        for (int i = 0; i < model.getSize(); ++i) {
            result.add((String)model.getElementAt(i));
        }
        return result;
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void setPatternsListener(PatternsListener listener) {
        this.myPatternsListener = listener;
    }

    public ConfigureProxiesOptionsPanel(Runnable validator, TestConnectionPerformer testConnectionPerformer) {
        this.myValidator = validator;
        this.myTestConnectionPerformer = testConnectionPerformer;
        this.$$$setupUI$$$();
        this.myComponent2Key = new HashMap<JComponent, String>();
        this.myKey2Component = new HashMap<String, JComponent>();
        this.fillMappings();
        this.initNumericValidation();
        this.initBrowseActions();
        this.initRepositories();
        this.putPatternsListener();
        this.myTestConnectionButton.addActionListener(e -> {
            String value = (String)this.myRepositoriesList.getSelectedValue();
            if (value != null && this.myTestConnectionPerformer.enabled()) {
                this.myTestConnectionPerformer.execute(value);
            }
        });
    }

    private void putPatternsListener() {
        UrlsSetter urlsSetter = new UrlsSetter();
        this.myUrlPatterns.addFocusListener(urlsSetter);
        this.myExceptions.addFocusListener(urlsSetter);
    }

    private void initBrowseActions() {
        InsertPathAction.addTo((JTextComponent)this.myPathToCertificatesField, (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        this.myClientCertificatePathField.addBrowseFolderListener(SvnBundle.message("dialog.edit.http.proxies.settings.dialog.select.ssl.client.certificate.path.title", new Object[0]), null, null, new FileChooserDescriptor(true, false, false, false, false, false));
    }

    private void initNumericValidation() {
        NumericFieldsValidator numericFocusListener = new NumericFieldsValidator();
        this.myPortField.addFocusListener(numericFocusListener);
        this.myTimeoutField.addFocusListener(numericFocusListener);
    }

    private void initRepositories() {
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        selectionModel.setSelectionMode(0);
        this.myRepositoriesList.setSelectionModel(selectionModel);
        this.myRepositoriesList.addListSelectionListener(e -> this.myTestConnectionButton.setEnabled(this.myTestConnectionPerformer.enabled() && this.myRepositoriesList.getSelectedValue() != null));
    }

    private void fillMappings() {
        this.addToKeyMappings(this.myServerField, "http-proxy-host");
        this.addToKeyMappings(this.myUserField, "http-proxy-username");
        this.addToKeyMappings(this.myPortField, "http-proxy-port");
        this.addToKeyMappings(this.myPasswordField, "http-proxy-password");
        this.addToKeyMappings(this.myExceptions, "http-proxy-exceptions");
        this.addToKeyMappings(this.myTimeoutField, "http-timeout");
        this.addToKeyMappings(this.myTrustDefaultCAsCheckBox, "ssl-trust-default-ca");
        this.addToKeyMappings(this.myClientCertificatePasswordField, "ssl-client-cert-password");
        this.addToKeyMappings(this.myPathToCertificatesField, "ssl-authority-files");
        this.addToKeyMappings((JComponent)this.myClientCertificatePathField, "ssl-client-cert-file");
    }

    private void addToKeyMappings(JComponent component, String key) {
        this.myComponent2Key.put(component, key);
        this.myKey2Component.put(key, component);
    }

    private void repositoryUrlsRecalculation() {
        if (!this.myIsDefault) {
            this.myPatternsListener.onChange(this.myUrlPatterns.getText(), this.myExceptions.getText());
        }
    }

    public void setIsValid(boolean valid) {
        this.myTestConnectionButton.setEnabled(valid && this.myRepositoriesList.getSelectedValue() != null);
    }

    public void setStringProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            JComponent component = this.myKey2Component.get(entry.getKey());
            if (component == null) continue;
            JTextComponent textComponent = null;
            if (component instanceof JTextComponent) {
                textComponent = (JTextComponent)component;
            } else if (component instanceof TextFieldWithBrowseButton) {
                textComponent = ((TextFieldWithBrowseButton)component).getTextField();
            }
            if (textComponent != null) {
                textComponent.setText(entry.getValue());
                textComponent.selectAll();
            }
            component.setToolTipText(entry.getKey());
        }
        this.myTrustDefaultCAsCheckBox.setSelected(ConfigureProxiesOptionsPanel.booleanPropertySelected(properties.get(this.myComponent2Key.get(this.myTrustDefaultCAsCheckBox))));
        this.repositoryUrlsRecalculation();
    }

    public void copyStringProperties(Map<String, String> map) {
        for (Map.Entry<String, JComponent> entry : this.myKey2Component.entrySet()) {
            JComponent component = entry.getValue();
            String value = null;
            if (component instanceof JTextComponent) {
                value = ((JTextComponent)component).getText();
            } else if (component instanceof TextFieldWithBrowseButton) {
                value = ((TextFieldWithBrowseButton)component).getTextField().getText();
            } else if (component instanceof JCheckBox) {
                String string = value = ((JCheckBox)component).isSelected() ? "yes" : "no";
            }
            if (value == null || "".equals(value) && !map.containsKey(entry.getKey())) continue;
            map.put(entry.getKey(), value);
        }
    }

    private static boolean booleanPropertySelected(String value) {
        return value != null && SvnServerFileKeys.YES_OPTIONS.contains(value.toLowerCase());
    }

    public boolean isDefault() {
        return this.myIsDefault;
    }

    public void setIsDefaultGroup(boolean value) {
        this.myIsDefault = value;
        this.myUrlPatterns.setEditable(!this.myIsDefault);
    }

    public String getPatterns() {
        return this.myUrlPatterns.getText();
    }

    public void setPatterns(String value) {
        this.myUrlPatterns.setText(value);
        this.repositoryUrlsRecalculation();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox;
        JPasswordField jPasswordField;
        JTextArea jTextArea;
        JTextArea jTextArea2;
        JTextField jTextField2;
        JTextField jTextField3;
        JPasswordField jPasswordField2;
        JTextField jTextField4;
        JTextField jTextField5;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createLineBorder(Color.black), (String)ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("dialog.edit.http.proxies.settings.panel.proxy.title"), (int)0, (int)0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("dialog.edit.http.proxies.settings.patterns.text"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 5, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("dialog.edit.http.proxies.settings.exceptions.text"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 5, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("dialog.edit.http.proxies.settings.server.text"));
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myServerField = jTextField5 = new JTextField();
        jPanel2.add((Component)jTextField5, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("dialog.edit.http.proxies.settings.port.text"));
        jPanel2.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myPortField = jTextField4 = new JTextField();
        jPanel2.add((Component)jTextField4, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("dialog.edit.http.proxies.settings.password.text"));
        jLabel5.setRequestFocusEnabled(false);
        jPanel2.add((Component)jLabel5, new GridConstraints(3, 2, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myPasswordField = jPasswordField2 = new JPasswordField();
        jPanel2.add((Component)jPasswordField2, new GridConstraints(3, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("dialog.edit.http.proxies.settings.user.text"));
        jPanel2.add((Component)jLabel6, new GridConstraints(2, 2, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myUserField = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(2, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("dialog.edit.http.proxies.settings.connection.timeout.text"));
        jPanel2.add((Component)jLabel7, new GridConstraints(4, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myTimeoutField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 1, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myUrlPatterns = jTextArea2 = new JTextArea();
        jTextArea2.setRows(3);
        jBScrollPane.setViewportView(jTextArea2);
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane2, new GridConstraints(1, 1, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myExceptions = jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setRows(3);
        jBScrollPane2.setViewportView(jTextArea);
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("dialog.edit.http.proxies.settings.seconds.text"));
        jPanel2.add((Component)jLabel8, new GridConstraints(4, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createLineBorder(Color.black), (String)ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("dialog.edit.http.proxies.settings.panel.ssl.title"), (int)0, (int)0, null, null));
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("dialog.edit.http.proxies.settings.paths.to.authority.certificates.text"));
        jPanel3.add((Component)jLabel9, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("dialog.edit.http.proxies.settings.ssl.client.certificate.file.text"));
        jPanel3.add((Component)jLabel10, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel11 = new JLabel();
        this.$$$loadLabelText$$$(jLabel11, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("dialog.edit.http.proxies.settings.client.certificate.passphrase.text"));
        jPanel3.add((Component)jLabel11, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myClientCertificatePasswordField = jPasswordField = new JPasswordField();
        jPanel3.add((Component)jPasswordField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myTrustDefaultCAsCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("dialog.edit.http.proxies.settings.trust.default.cas.text"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(2, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myClientCertificatePathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myPathToCertificatesField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createLineBorder(Color.black), (String)ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("dialog.edit.http.proxies.settings.panel.repositories.title"), (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane3 = new JBScrollPane();
        jPanel4.add((Component)jBScrollPane3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBList jBList = new JBList();
        this.myRepositoriesList = jBList;
        jBScrollPane3.setViewportView((Component)jBList);
        this.myTestConnectionButton = jButton = new JButton();
        jButton.setLabel("Test connection");
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("dialog.edit.http.proxies.settings.test.connection.button.text"));
        jPanel4.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 4, 2, 3, 0, null, null, null));
        jLabel.setLabelFor(jTextArea2);
        jLabel2.setLabelFor(jTextArea);
        jLabel3.setLabelFor(jTextField5);
        jLabel4.setLabelFor(jTextField4);
        jLabel5.setLabelFor(jPasswordField2);
        jLabel6.setLabelFor(jTextField3);
        jLabel7.setLabelFor(jTextField2);
        jLabel9.setLabelFor(jTextField);
        jLabel11.setLabelFor(jPasswordField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class NumericFieldsValidator
    implements FocusListener {
        private NumericFieldsValidator() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            ConfigureProxiesOptionsPanel.this.myValidator.run();
        }
    }

    private class UrlsSetter
    implements FocusListener {
        private UrlsSetter() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            ConfigureProxiesOptionsPanel.this.repositoryUrlsRecalculation();
        }
    }
}

