/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.PsiUtil;

public abstract class DevKitUastInspectionBase
extends AbstractBaseUastLocalInspectionTool {
    @NotNull
    public final PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/idea/devkit/inspections/DevKitUastInspectionBase", "buildVisitor"));
        }
        PsiElementVisitor psiElementVisitor = this.isAllowed(holder) ? this.buildInternalVisitor(holder, isOnTheFly) : PsiElementVisitor.EMPTY_VISITOR;
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/DevKitUastInspectionBase", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    protected boolean isAllowed(ProblemsHolder holder) {
        if (PsiUtil.isIdeaProject(holder.getProject())) {
            return true;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)holder.getFile());
        if (module == null) {
            return false;
        }
        if (PluginModuleType.isPluginModuleOrDependency(module)) {
            return true;
        }
        if (PsiUtil.isPluginModule(module)) {
            return true;
        }
        return ApplicationManager.getApplication().isUnitTestMode();
    }

    protected PsiElementVisitor buildInternalVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/idea/devkit/inspections/DevKitUastInspectionBase", "buildInternalVisitor"));
        }
        return super.buildVisitor(holder, isOnTheFly);
    }
}

