/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.projectRoots;

public enum IntelliJPlatformProduct {
    IDEA("IU", "IntelliJ IDEA", null),
    IDEA_IC("IC", "IntelliJ IDEA Community Edition", "Idea"),
    RUBYMINE("RM", "RubyMine", "Ruby"),
    PYCHARM("PY", "PyCharm", "Python"),
    PYCHARM_PC("PC", "PyCharm Community Edition", "PyCharmCore"),
    PYCHARM_EDU("PE", "PyCharm Educational Edition", "PyCharmEdu"),
    PHPSTORM("PS", "PhpStorm", "PhpStorm"),
    WEBSTORM("WS", "WebStorm", "WebStorm"),
    APPCODE("OC", "AppCode", "AppCode"),
    CLION("CL", "CLion", "CLion"),
    DBE("DB", "DataGrip", "DataGrip"),
    RIDER("RD", "Rider", "Rider"),
    GOIDE("GO", "Gogland", "Gogland"),
    ANDROID_STUDIO("AI", "Android Studio", "AndroidStudio");

    private final String myProductCode;
    private final String myName;
    private final String myPlatformPrefix;

    public String getName() {
        return this.myName;
    }

    public String getPlatformPrefix() {
        return this.myPlatformPrefix;
    }

    private IntelliJPlatformProduct(String productCode, String name, String platformPrefix) {
        this.myProductCode = productCode;
        this.myName = name;
        this.myPlatformPrefix = platformPrefix;
    }

    public static IntelliJPlatformProduct fromBuildNumber(String buildNumber) {
        for (IntelliJPlatformProduct product : IntelliJPlatformProduct.values()) {
            if (!buildNumber.startsWith(product.myProductCode)) continue;
            return product;
        }
        return IDEA;
    }
}

