/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.i18n;

import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.inspections.EditorQuickFixProvider;
import com.intellij.uiDesigner.inspections.FormErrorCollector;
import com.intellij.uiDesigner.inspections.StringDescriptorInspection;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.lw.StringDescriptor;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class InvalidPropertyKeyFormInspection
extends StringDescriptorInspection {
    public InvalidPropertyKeyFormInspection() {
        super("InvalidPropertyKeyForm");
    }

    @Override
    protected void checkStringDescriptor(Module module, IComponent component, IProperty prop, StringDescriptor descriptor, FormErrorCollector collector) {
        String error = InvalidPropertyKeyFormInspection.checkDescriptor(descriptor, module);
        if (error != null) {
            collector.addError(this.getID(), component, prop, error, new EditorQuickFixProvider[0]);
        }
    }

    @Nullable
    public String getAlternativeID() {
        return "UnresolvedPropertyKey";
    }

    @Nullable
    private static String checkDescriptor(StringDescriptor descriptor, Module module) {
        String bundleName = descriptor.getDottedBundleName();
        String key = descriptor.getKey();
        if (bundleName == null && key == null) {
            return null;
        }
        if (bundleName == null) {
            return UIDesignerBundle.message("inspection.invalid.property.in.form.quickfix.error.bundle.not.specified", new Object[0]);
        }
        if (key == null) {
            return UIDesignerBundle.message("inspection.invalid.property.in.form.quickfix.error.property.key.not.specified", new Object[0]);
        }
        PropertiesReferenceManager manager = PropertiesReferenceManager.getInstance((Project)module.getProject());
        List propFiles = manager.findPropertiesFiles(module, bundleName);
        if (propFiles.isEmpty()) {
            return UIDesignerBundle.message("inspection.invalid.property.in.form.quickfix.error.bundle.not.found", bundleName);
        }
        for (PropertiesFile propFile : propFiles) {
            com.intellij.lang.properties.IProperty property = propFile.findPropertyByKey(key);
            if (property != null) continue;
            return UIDesignerBundle.message("inspection.invalid.property.in.form.quickfix.error.key.not.found", key, bundleName, propFile.getLocale().getDisplayName());
        }
        return null;
    }
}

