/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.linechart;

import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineChartCustomRenderer;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.DurationData;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.intellij.util.containers.ImmutableList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DurationDataRenderer<E extends DurationData>
implements Animatable,
LineChartCustomRenderer {
    private static final float DISPLAY_OFFSET_PERCENTAGE = 0.005f;
    private static final int CLICK_REGION_DRAW_PADDING_Y = 2;
    private static final int CLICK_REGION_DRAW_PADDING_X = 4;
    public static final int LABEL_ARCH_LENGTH = 7;
    @NotNull
    private final RangedSeries<E> mySeries;
    @NotNull
    private final Color myColor;
    private boolean myIsBlocking;
    @Nullable
    private Icon myIcon;
    @Nullable
    private Stroke myStroke;
    @Nullable
    private RangedContinuousSeries myAttachedLineSeries;
    @Nullable
    private Function<E, String> myTooltipProvider;
    @Nullable
    private Function<E, String> myLabelProvider;
    @Nullable
    private Consumer<E> myClickHandler;
    @Nullable
    private Color myLabelBgColor;
    @Nullable
    private Color myLabelHoveredBgColor;
    @Nullable
    private Color myLabelClickedBgColor;
    @Nullable
    private Color myLabelTextColor;
    @NotNull
    private final List<Rectangle2D.Float> myPathCache;
    @NotNull
    private final List<E> myDataCache;
    @NotNull
    private final List<JLabel> myLabelCache;
    @NotNull
    private final List<Rectangle2D.Float> myClickRegionCache;
    private Point myMousePosition;
    private boolean myClick;

    public DurationDataRenderer(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/adtui/chart/linechart/DurationDataRenderer", "<init>"));
        }
        this.myIsBlocking = false;
        this.myIcon = null;
        this.myStroke = null;
        this.myAttachedLineSeries = null;
        this.myTooltipProvider = null;
        this.myLabelProvider = null;
        this.myClickHandler = null;
        this.myLabelBgColor = null;
        this.myLabelHoveredBgColor = null;
        this.myLabelClickedBgColor = null;
        this.myLabelTextColor = null;
        this.myPathCache = new ArrayList<Rectangle2D.Float>();
        this.myDataCache = new ArrayList();
        this.myLabelCache = new ArrayList<JLabel>();
        this.myClickRegionCache = new ArrayList<Rectangle2D.Float>();
        this.mySeries = builder.mySeries;
        this.myColor = builder.myColor;
        this.myIsBlocking = builder.myIsBlocking;
        this.myIcon = builder.myIcon;
        this.myStroke = builder.myStroke;
        this.myAttachedLineSeries = builder.myAttachedLineSeries;
        this.myTooltipProvider = builder.myTooltipProvider;
        this.myLabelProvider = builder.myLabelProvider;
        this.myClickHandler = builder.myClickHandler;
        this.myLabelBgColor = builder.myLabelBgColor;
        this.myLabelHoveredBgColor = builder.myLabelHoveredBgColor;
        this.myLabelClickedBgColor = builder.myLabelClickedBgColor;
        this.myLabelTextColor = builder.myLabelTextColor;
    }

    @Override
    public void animate(float frameLength) {
    }

    @Override
    public void postAnimate() {
        this.myDataCache.clear();
        this.myClickRegionCache.clear();
        this.myPathCache.clear();
        this.myLabelCache.clear();
        double xMin = this.mySeries.getXRange().getMin();
        double xMax = this.mySeries.getXRange().getMax();
        double xLength = this.mySeries.getXRange().getLength();
        ImmutableList<SeriesData<E>> seriesList = this.mySeries.getSeries();
        ImmutableList attachedSeriesList = this.myAttachedLineSeries != null ? this.myAttachedLineSeries.getSeries() : null;
        int j = 0;
        float attachY = 1.0f;
        for (int i = 0; i < seriesList.size(); ++i) {
            Rectangle2D.Float rect = new Rectangle2D.Float();
            SeriesData data = (SeriesData)seriesList.get(i);
            double xStart = ((double)data.x - xMin) / (xMax - xMin);
            double xDuration = ((DurationData)data.value).getDuration() == -1L ? (xMax - (double)data.x) / xLength : (double)((DurationData)data.value).getDuration() / xLength;
            rect.setRect(xStart, 0.0, xDuration, 1.0);
            this.myPathCache.add(rect);
            this.myDataCache.add(data.value);
            Rectangle2D.Float clickRegion = new Rectangle2D.Float();
            this.myClickRegionCache.add(clickRegion);
            if (attachedSeriesList != null) {
                double yMin = this.myAttachedLineSeries.getYRange().getMin();
                double yMax = this.myAttachedLineSeries.getYRange().getMax();
                while (j < attachedSeriesList.size()) {
                    SeriesData seriesData = (SeriesData)attachedSeriesList.get(j);
                    double attachXStart = ((double)seriesData.x - xMin) / (xMax - xMin);
                    if (attachXStart > xStart) break;
                    attachY = (float)(1.0 - ((double)((Long)seriesData.value).longValue() - yMin) / (yMax - yMin));
                    ++j;
                }
            }
            double regionWidth = 0.0;
            double regionHeight = 0.0;
            if (this.myIcon != null) {
                regionWidth += (double)this.myIcon.getIconWidth();
                regionHeight += (double)this.myIcon.getIconHeight();
            }
            if (this.myLabelProvider != null) {
                JLabel label = new JLabel(this.myLabelProvider.apply(data.value));
                label.setFont((Font)AdtUiUtils.DEFAULT_FONT);
                label.setForeground(this.myLabelTextColor);
                Dimension size = label.getPreferredSize();
                label.setBounds(0, 0, size.width, size.height);
                this.myLabelCache.add(label);
                regionWidth += size.getWidth();
                regionHeight = Math.max(regionHeight, size.getHeight());
            }
            if (!(regionWidth > 0.0)) continue;
            clickRegion.setRect(xStart + (double)0.005f, (double)(attachY - 0.005f), regionWidth, regionHeight);
        }
    }

    @Override
    public void renderLines(@NotNull Component host, @NotNull Graphics2D g2d, @NotNull List<Path2D> transformedPaths, @NotNull List<LineConfig> configs) {
        double scaledXDuration;
        double scaledXStart;
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/android/tools/adtui/chart/linechart/DurationDataRenderer", "renderLines"));
        }
        if (g2d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2d", "com/android/tools/adtui/chart/linechart/DurationDataRenderer", "renderLines"));
        }
        if (transformedPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformedPaths", "com/android/tools/adtui/chart/linechart/DurationDataRenderer", "renderLines"));
        }
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/android/tools/adtui/chart/linechart/DurationDataRenderer", "renderLines"));
        }
        Shape originalClip = g2d.getClip();
        Dimension dim = host.getSize();
        if (this.myIsBlocking) {
            Rectangle2D.Float clipRect = new Rectangle2D.Float();
            for (Rectangle2D.Float rect : this.myPathCache) {
                scaledXStart = (double)rect.x * dim.getWidth();
                scaledXDuration = (double)rect.width * dim.getWidth();
                ((Rectangle2D)clipRect).setRect(scaledXStart, 0.0, scaledXDuration, dim.getHeight());
                g2d.setColor(host.getBackground());
                g2d.fill(clipRect);
                g2d.setClip(clipRect);
                LineChart.drawLines(g2d, transformedPaths, configs, true);
                g2d.setClip(originalClip);
            }
        }
        if (this.myStroke != null) {
            g2d.setColor(this.myColor);
            g2d.setStroke(this.myStroke);
            Line2D.Float eventLine = new Line2D.Float();
            for (int i = 0; i < this.myPathCache.size(); ++i) {
                Rectangle2D.Float rect;
                rect = this.myPathCache.get(i);
                scaledXStart = rect.x * (float)host.getWidth();
                scaledXDuration = rect.width * (float)host.getWidth();
                g2d.translate(scaledXStart, 0.0);
                ((Line2D)eventLine).setLine(0.0, 0.0, 0.0, host.getHeight());
                g2d.draw(eventLine);
                ((Line2D)eventLine).setLine(scaledXDuration, 0.0, scaledXDuration, host.getHeight());
                g2d.draw(eventLine);
                g2d.translate(-scaledXStart, 0.0);
            }
        }
    }

    public void renderOverlay(@NotNull Component host, @NotNull Graphics2D g2d) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/android/tools/adtui/chart/linechart/DurationDataRenderer", "renderOverlay"));
        }
        if (g2d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2d", "com/android/tools/adtui/chart/linechart/DurationDataRenderer", "renderOverlay"));
        }
        assert (this.myClickRegionCache.size() == this.myDataCache.size());
        for (int i = 0; i < this.myClickRegionCache.size(); ++i) {
            Rectangle2D.Float rect = this.myClickRegionCache.get(i);
            float scaledStartX = rect.x * (float)host.getWidth();
            float scaledStartY = rect.y * (float)host.getHeight() - rect.height;
            if (this.myLabelBgColor != null) {
                g2d.setColor(this.myLabelBgColor);
                RoundRectangle2D.Float scaledRect = new RoundRectangle2D.Float(scaledStartX - 4.0f, scaledStartY - 2.0f, rect.width + 8.0f, rect.height + 4.0f, 7.0f, 7.0f);
                if (this.myMousePosition != null && scaledRect.contains(this.myMousePosition)) {
                    g2d.setColor(this.myClick && this.myClickHandler != null ? this.myLabelClickedBgColor : this.myLabelHoveredBgColor);
                }
                g2d.fill(scaledRect);
            }
            g2d.translate(scaledStartX, scaledStartY);
            if (this.myIcon != null) {
                this.myIcon.paintIcon(host, g2d, 0, 0);
                float shift = this.myIcon.getIconWidth();
                g2d.translate(shift, 0.0);
                scaledStartX += shift;
            }
            if (this.myLabelProvider != null) {
                this.myLabelCache.get(i).paint(g2d);
            }
            g2d.translate(-scaledStartX, -scaledStartY);
        }
        this.myClick = false;
    }

    public boolean handleMouseEvent(@NotNull MouseEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/chart/linechart/DurationDataRenderer", "handleMouseEvent"));
        }
        this.myMousePosition = event.getPoint();
        boolean bl = this.myClick = event.getClickCount() > 0;
        if (this.myClickHandler == null || !this.myClick) {
            return false;
        }
        assert (this.myDataCache.size() == this.myClickRegionCache.size());
        DurationData hitData = null;
        Dimension dim = event.getComponent().getSize();
        for (int i = 0; i < this.myClickRegionCache.size(); ++i) {
            Rectangle2D.Float rect = this.myClickRegionCache.get(i);
            Rectangle2D.Float scaledRect = new Rectangle2D.Float(rect.x * (float)dim.width, rect.y * (float)dim.height - rect.height, rect.width, rect.height);
            if (!scaledRect.contains(this.myMousePosition)) continue;
            hitData = (DurationData)this.myDataCache.get(i);
            break;
        }
        if (hitData != null) {
            this.myClickHandler.accept(hitData);
            return true;
        }
        return false;
    }

    public static class Builder<E extends DurationData> {
        @NotNull
        private final RangedSeries<E> mySeries;
        @NotNull
        private final Color myColor;
        private boolean myIsBlocking;
        @Nullable
        private Icon myIcon;
        @Nullable
        private Stroke myStroke;
        @Nullable
        private RangedContinuousSeries myAttachedLineSeries;
        @Nullable
        private Function<E, String> myTooltipProvider;
        @Nullable
        private Function<E, String> myLabelProvider;
        @Nullable
        private Consumer<E> myClickHandler;
        @Nullable
        private Color myLabelBgColor;
        @Nullable
        private Color myLabelHoveredBgColor;
        @Nullable
        private Color myLabelClickedBgColor;
        @Nullable
        private Color myLabelTextColor;

        public Builder(@NotNull RangedSeries<E> series, @NotNull Color color) {
            if (series == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "series", "com/android/tools/adtui/chart/linechart/DurationDataRenderer$Builder", "<init>"));
            }
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/adtui/chart/linechart/DurationDataRenderer$Builder", "<init>"));
            }
            this.myIsBlocking = false;
            this.myIcon = null;
            this.myStroke = null;
            this.myAttachedLineSeries = null;
            this.myTooltipProvider = null;
            this.myLabelProvider = null;
            this.myClickHandler = null;
            this.myLabelBgColor = null;
            this.myLabelHoveredBgColor = null;
            this.myLabelClickedBgColor = null;
            this.myLabelTextColor = null;
            this.mySeries = series;
            this.myColor = color;
        }

        public Builder<E> setIsBlocking(boolean value) {
            this.myIsBlocking = value;
            return this;
        }

        public Builder<E> setIcon(@NotNull Icon icon) {
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/android/tools/adtui/chart/linechart/DurationDataRenderer$Builder", "setIcon"));
            }
            this.myIcon = icon;
            return this;
        }

        public Builder<E> setStroke(@NotNull Stroke stroke) {
            if (stroke == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stroke", "com/android/tools/adtui/chart/linechart/DurationDataRenderer$Builder", "setStroke"));
            }
            this.myStroke = stroke;
            return this;
        }

        public Builder<E> setAttachLineSeries(@NotNull RangedContinuousSeries series) {
            if (series == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "series", "com/android/tools/adtui/chart/linechart/DurationDataRenderer$Builder", "setAttachLineSeries"));
            }
            this.myAttachedLineSeries = series;
            return this;
        }

        public Builder<E> setTooltipProvider(@NotNull Function<E, String> provider) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/android/tools/adtui/chart/linechart/DurationDataRenderer$Builder", "setTooltipProvider"));
            }
            this.myTooltipProvider = provider;
            return this;
        }

        public Builder<E> setLabelProvider(@NotNull Function<E, String> provider) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/android/tools/adtui/chart/linechart/DurationDataRenderer$Builder", "setLabelProvider"));
            }
            this.myLabelProvider = provider;
            return this;
        }

        public Builder<E> setClickHander(@NotNull Consumer<E> handler) {
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/android/tools/adtui/chart/linechart/DurationDataRenderer$Builder", "setClickHander"));
            }
            this.myClickHandler = handler;
            return this;
        }

        public Builder<E> setLabelColors(@NotNull Color bgColor, @NotNull Color hoveredColor, @NotNull Color clickedColor, @NotNull Color color) {
            if (bgColor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bgColor", "com/android/tools/adtui/chart/linechart/DurationDataRenderer$Builder", "setLabelColors"));
            }
            if (hoveredColor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hoveredColor", "com/android/tools/adtui/chart/linechart/DurationDataRenderer$Builder", "setLabelColors"));
            }
            if (clickedColor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clickedColor", "com/android/tools/adtui/chart/linechart/DurationDataRenderer$Builder", "setLabelColors"));
            }
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/adtui/chart/linechart/DurationDataRenderer$Builder", "setLabelColors"));
            }
            this.myLabelBgColor = bgColor;
            this.myLabelHoveredBgColor = hoveredColor;
            this.myLabelClickedBgColor = clickedColor;
            this.myLabelTextColor = color;
            return this;
        }

        @NotNull
        public DurationDataRenderer<E> build() {
            DurationDataRenderer durationDataRenderer = new DurationDataRenderer(this);
            if (durationDataRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/chart/linechart/DurationDataRenderer$Builder", "build"));
            }
            return durationDataRenderer;
        }
    }
}

