/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.intellij.util.containers.ImmutableList;
import org.jetbrains.annotations.NotNull;

public class RangedSeries<E> {
    @NotNull
    protected final Range mXRange;
    @NotNull
    protected DataSeries<E> mSeries;

    public RangedSeries(Range xRange, DataSeries<E> series) {
        this.mXRange = xRange;
        this.mSeries = series;
    }

    @NotNull
    public ImmutableList<SeriesData<E>> getSeries() {
        ImmutableList<SeriesData<E>> immutableList = this.mSeries.getDataForXRange(this.mXRange);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/model/RangedSeries", "getSeries"));
        }
        return immutableList;
    }

    @NotNull
    public Range getXRange() {
        Range range = this.mXRange;
        if (range == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/model/RangedSeries", "getXRange"));
        }
        return range;
    }

    @NotNull
    public DataSeries<E> getDataSeries() {
        DataSeries<E> dataSeries = this.mSeries;
        if (dataSeries == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/model/RangedSeries", "getDataSeries"));
        }
        return dataSeries;
    }
}

