/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.treegrid;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.speedSearch.FilteringListModel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeGrid<T>
extends Box {
    private final Map<Object, JComponent> mySectionToComponent;
    private final List<JList<T>> myLists;
    private final List<HideableDecorator> myHideables;
    private final KeyListener myKeyListener;
    private boolean myFiltered;

    public TreeGrid(@NotNull AbstractTreeStructure model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/adtui/treegrid/TreeGrid", "<init>"));
        }
        this();
        this.setModelWithSectionHeaders(model);
    }

    public TreeGrid() {
        super(1);
        this.mySectionToComponent = new IdentityHashMap<Object, JComponent>();
        this.myLists = new ArrayList<JList<T>>();
        this.myHideables = new ArrayList<HideableDecorator>();
        this.myKeyListener = new MyKeyListener();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.setBackground(UIUtil.getListBackground());
        this.setOpaque(true);
    }

    public void setModel(@NotNull AbstractTreeStructure model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/adtui/treegrid/TreeGrid", "setModel"));
        }
        this.setModel(model, false);
    }

    public void setModelWithSectionHeaders(@NotNull AbstractTreeStructure model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/adtui/treegrid/TreeGrid", "setModelWithSectionHeaders"));
        }
        this.setModel(model, true);
    }

    private void setModel(final @NotNull AbstractTreeStructure model, boolean showSectionHeaders) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/adtui/treegrid/TreeGrid", "setModel"));
        }
        Object root = model.getRootElement();
        Object[] sections = model.getChildElements(root);
        this.mySectionToComponent.clear();
        this.myLists.clear();
        this.myHideables.clear();
        this.removeAll();
        this.setAutoscrolls(false);
        ListSelectionListener listSelectionListener = e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel sourceSelectionModel = (ListSelectionModel)e.getSource();
            if (!sourceSelectionModel.isSelectionEmpty()) {
                for (JList<T> aList : this.myLists) {
                    if (sourceSelectionModel == aList.getSelectionModel()) continue;
                    aList.clearSelection();
                }
            }
        };
        for (final Object section : sections) {
            String name = section.toString();
            FilteringListModel listModel = new FilteringListModel((ListModel)new AbstractListModel(){

                @Override
                public int getSize() {
                    return model.getChildElements(section).length;
                }

                @Override
                public Object getElementAt(int index) {
                    return model.getChildElements(section)[index];
                }
            });
            listModel.refilter();
            JList list = new JList(listModel);
            list.setAutoscrolls(false);
            list.setSelectionMode(0);
            list.setVisibleRowCount(-1);
            list.getSelectionModel().addListSelectionListener(listSelectionListener);
            list.setName(name);
            list.addKeyListener(this.myKeyListener);
            new ListSpeedSearch(list);
            this.myLists.add(list);
            if (showSectionHeaders) {
                JPanel panel = new JPanel(new BorderLayout()){

                    @Override
                    public Dimension getMaximumSize() {
                        return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
                    }
                };
                HideableDecorator hidyPanel = new HideableDecorator(panel, name, false);
                this.myHideables.add(hidyPanel);
                hidyPanel.setContentComponent(list);
                this.add(panel);
                this.mySectionToComponent.put(section, panel);
                continue;
            }
            if (this.getComponentCount() > 0) {
                this.add(new JSeparator());
            }
            list.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.add(list);
            this.mySectionToComponent.put(section, list);
        }
    }

    public void setVisibleSection(@Nullable Object section) {
        JComponent visible = section != null ? this.mySectionToComponent.get(section) : null;
        for (Component component : this.getComponents()) {
            component.setVisible(visible == null);
        }
        if (visible != null) {
            visible.setVisible(true);
        }
    }

    @Override
    public void setTransferHandler(@Nullable TransferHandler handler) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        for (JList<T> list : this.myLists) {
            list.setTransferHandler(handler);
            list.setDragEnabled(handler != null);
        }
    }

    public void addListSelectionListener(@NotNull ListSelectionListener lsl) {
        if (lsl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lsl", "com/android/tools/adtui/treegrid/TreeGrid", "addListSelectionListener"));
        }
        for (JList<T> list : this.myLists) {
            list.getSelectionModel().addListSelectionListener(lsl);
        }
    }

    public void setCellRenderer(@NotNull ListCellRenderer<T> cellRenderer) {
        if (cellRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cellRenderer", "com/android/tools/adtui/treegrid/TreeGrid", "setCellRenderer"));
        }
        for (JList<T> list : this.myLists) {
            list.setCellRenderer(cellRenderer);
        }
    }

    public void setFixedCellWidth(int width) {
        for (JList<T> list : this.myLists) {
            list.setFixedCellWidth(width);
        }
    }

    public void setFixedCellHeight(int height) {
        for (JList<T> list : this.myLists) {
            list.setFixedCellHeight(height);
        }
    }

    public void expandAll() {
        for (HideableDecorator hidyPanel : this.myHideables) {
            hidyPanel.setOn(true);
        }
    }

    @Nullable
    private JList<T> getSelectedList() {
        for (JList<T> list : this.myLists) {
            if (list.getSelectedIndex() <= -1) continue;
            return list;
        }
        return null;
    }

    @Override
    public void requestFocus() {
        JComponent component = this.getFocusRecipient();
        if (component != null) {
            component.requestFocus();
        }
    }

    @Nullable
    public JComponent getFocusRecipient() {
        JList<T> firstVisible = null;
        for (JList<T> list : this.myLists) {
            if (!list.isVisible()) continue;
            if (list.getSelectedIndex() != -1) {
                return list;
            }
            if (firstVisible != null || list.getModel().getSize() <= 0) continue;
            firstVisible = list;
        }
        if (firstVisible != null) {
            this.setSelectedElement(firstVisible.getModel().getElementAt(0));
        }
        return firstVisible;
    }

    @Nullable
    public T getSelectedElement() {
        JList<T> list = this.getSelectedList();
        return list != null ? (T)list.getSelectedValue() : null;
    }

    public void setSelectedElement(@Nullable T selectedElement) {
        for (JList<T> list : this.myLists) {
            if (selectedElement == null) {
                list.clearSelection();
                continue;
            }
            for (int i = 0; i < list.getModel().getSize(); ++i) {
                if (list.getModel().getElementAt(i) != selectedElement) continue;
                list.setSelectedIndex(i);
                this.ensureIndexVisible(list, i);
                return;
            }
        }
    }

    private void ensureIndexVisible(@NotNull JList<T> list, int index) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/adtui/treegrid/TreeGrid", "ensureIndexVisible"));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/adtui/treegrid/TreeGrid", "lambda$ensureIndexVisible$1"));
            }
            Rectangle cellBounds = list.getCellBounds(index, index);
            if (cellBounds != null) {
                list.getBounds();
                Rectangle rectangle = SwingUtilities.convertRectangle(list, cellBounds, this);
                this.scrollRectToVisible(rectangle);
            }
        }, ModalityState.any());
    }

    @Override
    public void addMouseListener(@NotNull MouseListener l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/android/tools/adtui/treegrid/TreeGrid", "addMouseListener"));
        }
        for (JList<T> list : this.myLists) {
            list.addMouseListener(l);
        }
    }

    @Override
    public void removeMouseListener(@NotNull MouseListener l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/android/tools/adtui/treegrid/TreeGrid", "removeMouseListener"));
        }
        for (JList<T> list : this.myLists) {
            list.removeMouseListener(l);
        }
    }

    public void setLayoutOrientation(int mode) {
        for (JList<T> list : this.myLists) {
            list.setLayoutOrientation(mode);
        }
    }

    public void setFilter(@Nullable Condition<T> condition) {
        this.myFiltered = condition != null;
        for (JList<T> list : this.myLists) {
            ((FilteringListModel)list.getModel()).setFilter(condition);
        }
    }

    public boolean isFiltered() {
        return this.myFiltered;
    }

    public void selectIfUnique() {
        T single = this.findSingleItem();
        if (single != null) {
            this.setSelectedElement(single);
        }
    }

    @Nullable
    private T findSingleItem() {
        T singleMatch = null;
        boolean found = false;
        for (JList<T> list : this.myLists) {
            ListModel<T> model = list.getModel();
            int size = model.getSize();
            if (size == 1) {
                if (found) {
                    return null;
                }
                found = true;
                singleMatch = model.getElementAt(0);
                continue;
            }
            if (size <= 1) continue;
            return null;
        }
        return singleMatch;
    }

    public void selectFirst() {
        for (JList<T> list : this.myLists) {
            ListModel<T> model = list.getModel();
            int size = model.getSize();
            if (size <= 0) continue;
            T item = model.getElementAt(0);
            this.setSelectedElement(item);
            list.requestFocus();
            this.ensureIndexVisible(list, 0);
            return;
        }
    }

    @Nullable
    JList<T> getSelectedComponent() {
        return this.getSelectedList();
    }

    @NotNull
    public List<JList<T>> getLists() {
        List<JList<T>> list = this.myLists;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/treegrid/TreeGrid", "getLists"));
        }
        return list;
    }

    private class MyKeyListener
    extends KeyAdapter {
        private int myLastMidX = -1;

        private MyKeyListener() {
        }

        @Override
        public void keyPressed(@NotNull KeyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/treegrid/TreeGrid$MyKeyListener", "keyPressed"));
            }
            Object source = event.getSource();
            if (!(source instanceof JList)) {
                return;
            }
            JList list = (JList)source;
            boolean consumed = false;
            switch (event.getKeyCode()) {
                case 40: {
                    consumed = this.handleKeyDown(list);
                    break;
                }
                case 38: {
                    consumed = this.handleKeyUp(list);
                    break;
                }
                case 37: {
                    this.myLastMidX = -1;
                    consumed = this.handleKeyLeft(list);
                    break;
                }
                case 39: {
                    this.myLastMidX = -1;
                    consumed = this.handleKeyRight(list);
                }
            }
            if (consumed) {
                event.consume();
            }
        }

        private boolean handleKeyDown(@NotNull JList<T> list) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/adtui/treegrid/TreeGrid$MyKeyListener", "handleKeyDown"));
            }
            int selectedIndex = list.getSelectedIndex();
            if (selectedIndex < 0) {
                return false;
            }
            if (this.myLastMidX < 0) {
                this.myLastMidX = this.midX(list, selectedIndex);
            }
            if (!this.isLastRow(list, selectedIndex)) {
                int nextLineStart = this.findNextListStart(list, selectedIndex);
                int newSelectedItem = this.findBestMatchFromLeft(list, this.myLastMidX, nextLineStart);
                this.selectNewItem(list, newSelectedItem, list);
                return true;
            }
            for (int listIndex = ContainerUtil.indexOf((List)TreeGrid.this.myLists, list) + 1; listIndex != 0 && listIndex < TreeGrid.this.myLists.size(); ++listIndex) {
                JList nextList = (JList)TreeGrid.this.myLists.get(listIndex);
                int itemCount = nextList.getModel().getSize();
                if (itemCount <= 0 || !nextList.isVisible()) continue;
                int newSelectedItem = this.findBestMatchFromLeft(nextList, this.myLastMidX, 0);
                this.selectNewItem(nextList, newSelectedItem, list);
                return true;
            }
            return false;
        }

        private boolean handleKeyUp(@NotNull JList<T> list) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/adtui/treegrid/TreeGrid$MyKeyListener", "handleKeyUp"));
            }
            int selectedIndex = list.getSelectedIndex();
            if (selectedIndex < 0) {
                return false;
            }
            if (this.myLastMidX < 0) {
                this.myLastMidX = this.midX(list, selectedIndex);
            }
            if (!this.isFirstRow(list, selectedIndex)) {
                int prevLineEnd = this.findPrevListEnd(list, selectedIndex);
                int newSelectedItem = this.findBestMatchFromRight(list, this.myLastMidX, prevLineEnd);
                this.selectNewItem(list, newSelectedItem, list);
                return true;
            }
            for (int listIndex = ContainerUtil.indexOf((List)TreeGrid.this.myLists, list) - 1; listIndex >= 0; --listIndex) {
                JList prevList = (JList)TreeGrid.this.myLists.get(listIndex);
                int itemCount = prevList.getModel().getSize();
                if (itemCount <= 0 || !prevList.isVisible()) continue;
                int newSelectedItem = this.findBestMatchFromRight(prevList, this.myLastMidX, itemCount - 1);
                this.selectNewItem(prevList, newSelectedItem, list);
                return true;
            }
            return false;
        }

        private boolean handleKeyRight(@NotNull JList<T> list) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/adtui/treegrid/TreeGrid$MyKeyListener", "handleKeyRight"));
            }
            int selectedIndex = list.getSelectedIndex();
            if (selectedIndex < 0) {
                return false;
            }
            if (selectedIndex < list.getModel().getSize() - 1) {
                this.selectNewItem(list, selectedIndex + 1, list);
                return true;
            }
            for (int listIndex = ContainerUtil.indexOf((List)TreeGrid.this.myLists, list) + 1; listIndex != 0 && listIndex < TreeGrid.this.myLists.size(); ++listIndex) {
                JList nextList = (JList)TreeGrid.this.myLists.get(listIndex);
                int itemCount = nextList.getModel().getSize();
                if (itemCount <= 0 || !nextList.isVisible()) continue;
                this.selectNewItem(nextList, 0, list);
                return true;
            }
            return false;
        }

        private boolean handleKeyLeft(@NotNull JList<T> list) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/adtui/treegrid/TreeGrid$MyKeyListener", "handleKeyLeft"));
            }
            int selectedIndex = list.getSelectedIndex();
            if (selectedIndex < 0) {
                return false;
            }
            if (selectedIndex > 0) {
                this.selectNewItem(list, selectedIndex - 1, list);
                return true;
            }
            for (int listIndex = ContainerUtil.indexOf((List)TreeGrid.this.myLists, list) - 1; listIndex >= 0; --listIndex) {
                JList prevList = (JList)TreeGrid.this.myLists.get(listIndex);
                int itemCount = prevList.getModel().getSize();
                if (itemCount <= 0 || !prevList.isVisible()) continue;
                this.selectNewItem(prevList, itemCount - 1, list);
                return true;
            }
            return false;
        }

        private int midX(@NotNull JList<T> list, int index) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/adtui/treegrid/TreeGrid$MyKeyListener", "midX"));
            }
            Rectangle bounds = list.getCellBounds(index, index);
            return bounds.x + bounds.width / 2;
        }

        private boolean isFirstRow(@NotNull JList<T> list, int index) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/adtui/treegrid/TreeGrid$MyKeyListener", "isFirstRow"));
            }
            Rectangle bounds = list.getCellBounds(index, index);
            Rectangle firstBounds = list.getCellBounds(0, 0);
            return this.verticalOverlap(bounds, firstBounds);
        }

        private boolean isLastRow(@NotNull JList<T> list, int index) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/adtui/treegrid/TreeGrid$MyKeyListener", "isLastRow"));
            }
            int last = list.getModel().getSize() - 1;
            Rectangle bounds = list.getCellBounds(index, index);
            Rectangle lastBounds = list.getCellBounds(last, last);
            return this.verticalOverlap(bounds, lastBounds);
        }

        private boolean verticalOverlap(@NotNull Rectangle bounds1, @NotNull Rectangle bounds2) {
            if (bounds1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds1", "com/android/tools/adtui/treegrid/TreeGrid$MyKeyListener", "verticalOverlap"));
            }
            if (bounds2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds2", "com/android/tools/adtui/treegrid/TreeGrid$MyKeyListener", "verticalOverlap"));
            }
            return bounds1.y < bounds2.y + bounds2.height && bounds1.y + bounds1.height > bounds2.y;
        }

        private int findPrevListEnd(@NotNull JList<T> list, int index) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/adtui/treegrid/TreeGrid$MyKeyListener", "findPrevListEnd"));
            }
            Rectangle bounds = list.getCellBounds(index, index);
            int prevIndex = index;
            Rectangle prevBounds = bounds;
            while (index > 0 && this.verticalOverlap(bounds, prevBounds)) {
                prevBounds = list.getCellBounds(--prevIndex, prevIndex);
            }
            return prevIndex;
        }

        private int findNextListStart(@NotNull JList<T> list, int index) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/adtui/treegrid/TreeGrid$MyKeyListener", "findNextListStart"));
            }
            int count = list.getModel().getSize();
            Rectangle bounds = list.getCellBounds(index, index);
            int nextIndex = index;
            Rectangle nextBounds = bounds;
            while (index < count && this.verticalOverlap(bounds, nextBounds)) {
                nextBounds = list.getCellBounds(++nextIndex, nextIndex);
            }
            return nextIndex;
        }

        private int findBestMatchFromLeft(@NotNull JList<T> list, int x, int startIndex) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/adtui/treegrid/TreeGrid$MyKeyListener", "findBestMatchFromLeft"));
            }
            int bestIndex = startIndex;
            int count = list.getModel().getSize();
            Rectangle bounds = list.getCellBounds(startIndex, startIndex);
            int y = bounds.y + bounds.height / 2;
            while (bestIndex < count && bounds.y < y && bounds.x + bounds.width < x) {
                bounds = list.getCellBounds(++bestIndex, bestIndex);
            }
            return bestIndex < count ? bestIndex : count - 1;
        }

        private int findBestMatchFromRight(@NotNull JList<T> list, int x, int startIndex) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/adtui/treegrid/TreeGrid$MyKeyListener", "findBestMatchFromRight"));
            }
            int bestIndex = startIndex;
            Rectangle bounds = list.getCellBounds(bestIndex, bestIndex);
            int y = bounds.y + bounds.height / 2;
            while (bestIndex > 0 && bounds.y + bounds.height > y && bounds.x > x) {
                bounds = list.getCellBounds(--bestIndex, bestIndex);
            }
            return bestIndex;
        }

        private void selectNewItem(@NotNull JList<T> list, int index, @NotNull JList<T> prevList) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/adtui/treegrid/TreeGrid$MyKeyListener", "selectNewItem"));
            }
            if (prevList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prevList", "com/android/tools/adtui/treegrid/TreeGrid$MyKeyListener", "selectNewItem"));
            }
            prevList.clearSelection();
            list.setSelectedIndex(index);
            TreeGrid.this.ensureIndexVisible(list, index);
            list.requestFocus();
        }
    }
}

