/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.workbench.AttachedToolWindow;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.SideModel;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBCardLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class SidePanel<T>
extends JPanel
implements SideModel.Listener<T> {
    private static final String SPLITTER = "SPLITTER";
    private static final String EMPTY = "EMPTY";
    private final Side mySide;
    private final JPanel myCards;
    private final CardLayout myLayout;
    private final JPanel myEmpty;
    private final Splitter mySplitter;

    public SidePanel(@NotNull Side side, @NotNull SideModel<T> model) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/android/tools/adtui/workbench/SidePanel", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/adtui/workbench/SidePanel", "<init>"));
        }
        super(new BorderLayout());
        this.mySide = side;
        this.mySplitter = new MySplitter();
        this.myEmpty = new JPanel();
        this.myLayout = new JBCardLayout();
        this.myCards = new JPanel(this.myLayout);
        this.setBorder(IdeBorderFactory.createBorder((int)(side.isLeft() ? 4 : 1)));
        this.add((Component)this.myCards, "Center");
        model.addListener(this);
    }

    @Override
    public void modelChanged(@NotNull SideModel<T> model, @NotNull SideModel.EventType unused) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/adtui/workbench/SidePanel", "modelChanged"));
        }
        if (unused == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unused", "com/android/tools/adtui/workbench/SidePanel", "modelChanged"));
        }
        this.myCards.removeAll();
        this.myCards.add((Component)this.mySplitter, SPLITTER);
        this.myCards.add((Component)this.myEmpty, EMPTY);
        this.addVisibleTools(model.getVisibleTools(this.mySide));
        this.addHiddenTools(model.getHiddenTools(this.mySide));
        this.revalidate();
        this.repaint();
    }

    private void addVisibleTools(@NotNull List<AttachedToolWindow> tools) {
        if (tools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tools", "com/android/tools/adtui/workbench/SidePanel", "addVisibleTools"));
        }
        this.mySplitter.setFirstComponent(null);
        this.mySplitter.setSecondComponent(null);
        this.setVisible(!tools.isEmpty());
        if (tools.isEmpty()) {
            this.myLayout.show(this.myCards, EMPTY);
        } else if (tools.size() == 1) {
            AttachedToolWindow tool = tools.get(0);
            this.myCards.add((Component)tool.getComponent(), tool.getToolName());
            this.myLayout.show(this.myCards, tool.getToolName());
        } else {
            AttachedToolWindow tool1 = tools.get(0);
            AttachedToolWindow tool2 = tools.get(1);
            tool1.getComponent().setVisible(true);
            tool2.getComponent().setVisible(true);
            this.mySplitter.setFirstComponent(tool1.getComponent());
            this.mySplitter.setSecondComponent(tool2.getComponent());
            this.myLayout.show(this.myCards, SPLITTER);
        }
    }

    private void addHiddenTools(@NotNull List<AttachedToolWindow> tools) {
        if (tools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tools", "com/android/tools/adtui/workbench/SidePanel", "addHiddenTools"));
        }
        tools.forEach(tool -> this.myCards.add((Component)tool.getComponent(), tool.getToolName()));
    }

    private static class MySplitter
    extends Splitter {
        public MySplitter() {
            super(true);
            this.setDividerWidth(9);
        }

        protected Divider createDivider() {
            Splitter.DividerImpl divider = new Splitter.DividerImpl((Splitter)this);
            divider.setBorder(IdeBorderFactory.createBorder((int)10));
            return divider;
        }
    }
}

