/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GitInit
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        FileChooserDescriptor fcd = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fcd.setShowFileSystemRoots(true);
        fcd.setTitle(GitBundle.getString("init.destination.directory.title"));
        fcd.setDescription(GitBundle.getString("init.destination.directory.description"));
        fcd.setHideIgnored(false);
        VirtualFile baseDir = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (baseDir == null) {
            baseDir = project.getBaseDir();
        }
        GitInit.doInit(project, fcd, baseDir);
    }

    private static void doInit(final Project project, FileChooserDescriptor fcd, VirtualFile baseDir) {
        FileChooser.chooseFile((FileChooserDescriptor)fcd, (Project)project, (VirtualFile)baseDir, root -> {
            if (GitUtil.isUnderGit(root) && Messages.showYesNoDialog((Project)project, (String)GitBundle.message("init.warning.already.under.git", StringUtil.escapeXml((String)root.getPresentableUrl())), (String)GitBundle.getString("init.warning.title"), (Icon)Messages.getWarningIcon()) != 0) {
                return;
            }
            GitCommandResult result = Git.getInstance().init(project, (VirtualFile)root, new GitLineHandlerListener[0]);
            if (!result.success()) {
                GitVcs vcs = GitVcs.getInstance(project);
                if (vcs != null && vcs.getExecutableValidator().checkExecutableAndNotifyIfNeeded()) {
                    VcsNotifier.getInstance((Project)project).notifyError("Git init failed", result.getErrorOutputAsHtmlString());
                }
                return;
            }
            if (project.isDefault()) {
                return;
            }
            GitVcs.runInBackground(new Task.Backgroundable(project, GitBundle.getString("common.refreshing"), (VirtualFile)root){
                final /* synthetic */ VirtualFile val$root;
                {
                    this.val$root = virtualFile;
                    super(arg0, arg1);
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/actions/GitInit$1", "run"));
                    }
                    GitInit.refreshAndConfigureVcsMappings(project, this.val$root, this.val$root.getPath());
                }
            });
        });
    }

    public static void refreshAndConfigureVcsMappings(Project project, VirtualFile root, String path) {
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{root});
        ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance((Project)project);
        manager.setDirectoryMappings(VcsUtil.addMapping((List)manager.getDirectoryMappings(), (String)path, (String)"Git"));
        manager.updateActiveVcss();
        VcsDirtyScopeManager.getInstance((Project)project).dirDirtyRecursively(root);
    }
}

