/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.actions.GitMergeAction;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitPullDialog;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitPull
extends GitMergeAction {
    @Override
    @NotNull
    protected String getActionName() {
        String string = GitBundle.getString("pull.action.name");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/actions/GitPull", "getActionName"));
        }
        return string;
    }

    @Override
    protected GitMergeAction.DialogState displayDialog(@NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/actions/GitPull", "displayDialog"));
        }
        if (gitRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitRoots", "git4idea/actions/GitPull", "displayDialog"));
        }
        if (defaultRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultRoot", "git4idea/actions/GitPull", "displayDialog"));
        }
        GitPullDialog dialog = new GitPullDialog(project, gitRoots, defaultRoot);
        if (!dialog.showAndGet()) {
            return null;
        }
        GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(project);
        GitRepository repository = (GitRepository)repositoryManager.getRepositoryForRoot(dialog.gitRoot());
        assert (repository != null) : "Repository can't be null for root " + dialog.gitRoot();
        String remoteOrUrl = dialog.getRemote();
        if (remoteOrUrl == null) {
            return null;
        }
        GitRemote remote = GitUtil.findRemoteByName(repository, remoteOrUrl);
        List<String> urls = remote == null ? Collections.singletonList(remoteOrUrl) : remote.getUrls();
        Computable handlerProvider = () -> dialog.makeHandler(urls);
        return new GitMergeAction.DialogState(dialog.gitRoot(), GitBundle.message("pulling.title", dialog.getRemote()), (Computable<GitLineHandler>)handlerProvider);
    }
}

