/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import git4idea.GitUtil;
import git4idea.commands.GitCommandResult;
import git4idea.repo.GitRepository;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class GitCompoundResult {
    private final Map<GitRepository, GitCommandResult> resultsByRepos = new HashMap<GitRepository, GitCommandResult>(1);
    private final Project myProject;

    public GitCompoundResult(Project project) {
        this.myProject = project;
    }

    public void append(GitRepository repository, GitCommandResult result) {
        this.resultsByRepos.put(repository, result);
    }

    public boolean totalSuccess() {
        boolean success = true;
        for (GitCommandResult result : this.resultsByRepos.values()) {
            success &= result.success();
        }
        return success;
    }

    public boolean partialSuccess() {
        boolean successFound = false;
        boolean failureFound = false;
        for (GitCommandResult result : this.resultsByRepos.values()) {
            if (result.success()) {
                successFound = true;
                continue;
            }
            failureFound = true;
        }
        return successFound && failureFound;
    }

    @NotNull
    public String getErrorOutputWithReposIndication() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<GitRepository, GitCommandResult> entry : this.resultsByRepos.entrySet()) {
            GitRepository repository = entry.getKey();
            GitCommandResult result = entry.getValue();
            if (result.success()) continue;
            sb.append("<p>");
            if (!GitUtil.justOneGitRepository(this.myProject)) {
                sb.append("<code>" + repository.getPresentableUrl() + "</code>:<br/>");
            }
            sb.append(result.getErrorOutputAsHtmlString());
            sb.append("</p>");
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitCompoundResult", "getErrorOutputWithReposIndication"));
        }
        return string;
    }

    public String toString() {
        return "GitCompoundResult: " + StringUtil.join(this.resultsByRepos.keySet(), repository -> repository.getRoot().getName() + ": " + this.resultsByRepos.get(repository).toString(), (String)"\n");
    }
}

