/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.dvcs.branch.DvcsBranchInfo;
import com.intellij.dvcs.branch.DvcsBranchSettings;
import com.intellij.dvcs.branch.DvcsBranchUtil;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.Repository;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.UpdateMethod;
import git4idea.push.GitPushTagMode;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="Git.Settings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class GitVcsSettings
implements PersistentStateComponent<State>,
DvcsSyncSettings {
    private static final int PREVIOUS_COMMIT_AUTHORS_LIMIT = 16;
    private final GitVcsApplicationSettings myAppSettings;
    private State myState = new State();

    public GitVcsSettings(GitVcsApplicationSettings appSettings) {
        this.myAppSettings = appSettings;
    }

    public GitVcsApplicationSettings getAppSettings() {
        return this.myAppSettings;
    }

    public static GitVcsSettings getInstance(Project project) {
        return (GitVcsSettings)PeriodicalTasksCloser.getInstance().safeGetService(project, GitVcsSettings.class);
    }

    @NotNull
    public UpdateMethod getUpdateType() {
        UpdateMethod updateMethod = (UpdateMethod)((Object)ObjectUtils.notNull((Object)((Object)this.myState.UPDATE_TYPE), (Object)((Object)UpdateMethod.BRANCH_DEFAULT)));
        if (updateMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/config/GitVcsSettings", "getUpdateType"));
        }
        return updateMethod;
    }

    public void setUpdateType(UpdateMethod updateType) {
        this.myState.UPDATE_TYPE = updateType;
    }

    @NotNull
    public UpdateChangesPolicy updateChangesPolicy() {
        UpdateChangesPolicy updateChangesPolicy = this.myState.UPDATE_CHANGES_POLICY;
        if (updateChangesPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/config/GitVcsSettings", "updateChangesPolicy"));
        }
        return updateChangesPolicy;
    }

    public void setUpdateChangesPolicy(UpdateChangesPolicy value) {
        this.myState.UPDATE_CHANGES_POLICY = value;
    }

    public void saveCommitAuthor(String author) {
        this.myState.PREVIOUS_COMMIT_AUTHORS.remove(author);
        while (this.myState.PREVIOUS_COMMIT_AUTHORS.size() >= 16) {
            this.myState.PREVIOUS_COMMIT_AUTHORS.remove(this.myState.PREVIOUS_COMMIT_AUTHORS.size() - 1);
        }
        this.myState.PREVIOUS_COMMIT_AUTHORS.add(0, author);
    }

    public String[] getCommitAuthors() {
        return ArrayUtil.toStringArray(this.myState.PREVIOUS_COMMIT_AUTHORS);
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    public boolean autoUpdateIfPushRejected() {
        return this.myState.PUSH_AUTO_UPDATE;
    }

    public void setAutoUpdateIfPushRejected(boolean autoUpdate) {
        this.myState.PUSH_AUTO_UPDATE = autoUpdate;
    }

    public boolean shouldUpdateAllRootsIfPushRejected() {
        return this.myState.PUSH_UPDATE_ALL_ROOTS;
    }

    public void setUpdateAllRootsIfPushRejected(boolean updateAllRoots) {
        this.myState.PUSH_UPDATE_ALL_ROOTS = updateAllRoots;
    }

    @NotNull
    public DvcsSyncSettings.Value getSyncSetting() {
        DvcsSyncSettings.Value value = this.myState.ROOT_SYNC;
        if (value == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/config/GitVcsSettings", "getSyncSetting"));
        }
        return value;
    }

    public void setSyncSetting(@NotNull DvcsSyncSettings.Value syncSetting) {
        if (syncSetting == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncSetting", "git4idea/config/GitVcsSettings", "setSyncSetting"));
        }
        this.myState.ROOT_SYNC = syncSetting;
    }

    @Nullable
    public String getRecentRootPath() {
        return this.myState.RECENT_GIT_ROOT_PATH;
    }

    public void setRecentRoot(@NotNull String recentGitRootPath) {
        if (recentGitRootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recentGitRootPath", "git4idea/config/GitVcsSettings", "setRecentRoot"));
        }
        this.myState.RECENT_GIT_ROOT_PATH = recentGitRootPath;
    }

    @NotNull
    public Map<String, String> getRecentBranchesByRepository() {
        Map<String, String> map = this.myState.RECENT_BRANCH_BY_REPOSITORY;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/config/GitVcsSettings", "getRecentBranchesByRepository"));
        }
        return map;
    }

    public void setRecentBranchOfRepository(@NotNull String repositoryPath, @NotNull String branch) {
        if (repositoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryPath", "git4idea/config/GitVcsSettings", "setRecentBranchOfRepository"));
        }
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "git4idea/config/GitVcsSettings", "setRecentBranchOfRepository"));
        }
        this.myState.RECENT_BRANCH_BY_REPOSITORY.put(repositoryPath, branch);
    }

    @Nullable
    public String getRecentCommonBranch() {
        return this.myState.RECENT_COMMON_BRANCH;
    }

    public void setRecentCommonBranch(@NotNull String branch) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "git4idea/config/GitVcsSettings", "setRecentCommonBranch"));
        }
        this.myState.RECENT_COMMON_BRANCH = branch;
    }

    public void setAutoCommitOnCherryPick(boolean autoCommit) {
        this.myState.AUTO_COMMIT_ON_CHERRY_PICK = autoCommit;
    }

    public boolean isAutoCommitOnCherryPick() {
        return this.myState.AUTO_COMMIT_ON_CHERRY_PICK;
    }

    public void setAutoCommitOnRevert(boolean autoCommit) {
        this.myState.AUTO_COMMIT_ON_REVERT = autoCommit;
    }

    public boolean isAutoCommitOnRevert() {
        return this.myState.AUTO_COMMIT_ON_REVERT;
    }

    public boolean warnAboutCrlf() {
        return this.myState.WARN_ABOUT_CRLF;
    }

    public void setWarnAboutCrlf(boolean warn) {
        this.myState.WARN_ABOUT_CRLF = warn;
    }

    public boolean warnAboutDetachedHead() {
        return this.myState.WARN_ABOUT_DETACHED_HEAD;
    }

    public void setWarnAboutDetachedHead(boolean warn) {
        this.myState.WARN_ABOUT_DETACHED_HEAD = warn;
    }

    @Nullable
    public GitResetMode getResetMode() {
        return this.myState.RESET_MODE;
    }

    public void setResetMode(@NotNull GitResetMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "git4idea/config/GitVcsSettings", "setResetMode"));
        }
        this.myState.RESET_MODE = mode;
    }

    public boolean isForcePushAllowed() {
        return this.myState.FORCE_PUSH_ALLOWED;
    }

    public void setForcePushAllowed(boolean allowed) {
        this.myState.FORCE_PUSH_ALLOWED = allowed;
    }

    @Nullable
    public GitPushTagMode getPushTagMode() {
        return this.myState.PUSH_TAGS;
    }

    public void setPushTagMode(@Nullable GitPushTagMode mode) {
        this.myState.PUSH_TAGS = mode;
    }

    public boolean shouldSignOffCommit() {
        return this.myState.SIGN_OFF_COMMIT;
    }

    public void setSignOffCommit(boolean state) {
        this.myState.SIGN_OFF_COMMIT = state;
    }

    @Deprecated
    public boolean isIdeaSsh() {
        if (this.getAppSettings().getIdeaSsh() == null) {
            this.getAppSettings().setIdeaSsh(this.myState.SSH_EXECUTABLE);
        }
        return this.getAppSettings().getIdeaSsh() == GitVcsApplicationSettings.SshExecutable.IDEA_SSH;
    }

    @Nullable
    public GitRemoteBranch getPushTarget(@NotNull GitRepository repository, @NotNull String sourceBranch) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/config/GitVcsSettings", "getPushTarget"));
        }
        if (sourceBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceBranch", "git4idea/config/GitVcsSettings", "getPushTarget"));
        }
        PushTargetInfo targetInfo = (PushTargetInfo)DvcsBranchUtil.find(this.myState.PUSH_TARGETS, (Repository)repository, (String)sourceBranch);
        if (targetInfo == null) {
            return null;
        }
        GitRemote remote = GitUtil.findRemoteByName(repository, targetInfo.targetRemoteName);
        if (remote == null) {
            return null;
        }
        return GitUtil.findOrCreateRemoteBranch(repository, remote, targetInfo.targetBranchName);
    }

    public void setPushTarget(@NotNull GitRepository repository, @NotNull String sourceBranch, @NotNull String targetRemote, @NotNull String targetBranch) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/config/GitVcsSettings", "setPushTarget"));
        }
        if (sourceBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceBranch", "git4idea/config/GitVcsSettings", "setPushTarget"));
        }
        if (targetRemote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetRemote", "git4idea/config/GitVcsSettings", "setPushTarget"));
        }
        if (targetBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetBranch", "git4idea/config/GitVcsSettings", "setPushTarget"));
        }
        String repositoryPath = repository.getRoot().getPath();
        PushTargetInfo existingInfo = (PushTargetInfo)DvcsBranchUtil.find(this.myState.PUSH_TARGETS, (Repository)repository, (String)sourceBranch);
        if (existingInfo != null) {
            this.myState.PUSH_TARGETS.remove((Object)existingInfo);
        }
        this.myState.PUSH_TARGETS.add(new PushTargetInfo(repositoryPath, sourceBranch, targetRemote, targetBranch));
    }

    @NotNull
    public DvcsBranchSettings getFavoriteBranchSettings() {
        DvcsBranchSettings dvcsBranchSettings = this.myState.FAVORITE_BRANCH_SETTINGS;
        if (dvcsBranchSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/config/GitVcsSettings", "getFavoriteBranchSettings"));
        }
        return dvcsBranchSettings;
    }

    public boolean shouldSetUserNameGlobally() {
        return this.myState.SET_USER_NAME_GLOBALLY;
    }

    public void setUserNameGlobally(boolean value) {
        this.myState.SET_USER_NAME_GLOBALLY = value;
    }

    public boolean shouldSwapSidesInCompareBranches() {
        return this.myState.SWAP_SIDES_IN_COMPARE_BRANCHES;
    }

    public void setSwapSidesInCompareBranches(boolean value) {
        this.myState.SWAP_SIDES_IN_COMPARE_BRANCHES = value;
    }

    @Tag(value="push-target-info")
    private static class PushTargetInfo
    extends DvcsBranchInfo {
        @Attribute(value="target-remote")
        public String targetRemoteName;
        @Attribute(value="target-branch")
        public String targetBranchName;

        public PushTargetInfo() {
            this("", "", "", "");
        }

        PushTargetInfo(@NotNull String repositoryPath, @NotNull String source, @NotNull String targetRemote, @NotNull String targetBranch) {
            if (repositoryPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryPath", "git4idea/config/GitVcsSettings$PushTargetInfo", "<init>"));
            }
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "git4idea/config/GitVcsSettings$PushTargetInfo", "<init>"));
            }
            if (targetRemote == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetRemote", "git4idea/config/GitVcsSettings$PushTargetInfo", "<init>"));
            }
            if (targetBranch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetBranch", "git4idea/config/GitVcsSettings$PushTargetInfo", "<init>"));
            }
            super(repositoryPath, source);
            this.targetRemoteName = targetRemote;
            this.targetBranchName = targetBranch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PushTargetInfo info = (PushTargetInfo)((Object)o);
            if (this.targetRemoteName != null ? !this.targetRemoteName.equals(info.targetRemoteName) : info.targetRemoteName != null) {
                return false;
            }
            return !(this.targetBranchName != null ? !this.targetBranchName.equals(info.targetBranchName) : info.targetBranchName != null);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.targetRemoteName, this.targetBranchName);
        }
    }

    public static class State {
        public List<String> PREVIOUS_COMMIT_AUTHORS = new ArrayList<String>();
        public GitVcsApplicationSettings.SshExecutable SSH_EXECUTABLE = GitVcsApplicationSettings.SshExecutable.IDEA_SSH;
        public UpdateChangesPolicy UPDATE_CHANGES_POLICY = UpdateChangesPolicy.STASH;
        public UpdateMethod UPDATE_TYPE = UpdateMethod.BRANCH_DEFAULT;
        public boolean PUSH_AUTO_UPDATE = false;
        public boolean PUSH_UPDATE_ALL_ROOTS = true;
        public DvcsSyncSettings.Value ROOT_SYNC = DvcsSyncSettings.Value.NOT_DECIDED;
        public String RECENT_GIT_ROOT_PATH = null;
        public Map<String, String> RECENT_BRANCH_BY_REPOSITORY = new HashMap<String, String>();
        public String RECENT_COMMON_BRANCH = null;
        public boolean AUTO_COMMIT_ON_CHERRY_PICK = false;
        public boolean AUTO_COMMIT_ON_REVERT = false;
        public boolean WARN_ABOUT_CRLF = true;
        public boolean WARN_ABOUT_DETACHED_HEAD = true;
        public GitResetMode RESET_MODE = null;
        public boolean FORCE_PUSH_ALLOWED = true;
        public GitPushTagMode PUSH_TAGS = null;
        public boolean SIGN_OFF_COMMIT = false;
        public boolean SET_USER_NAME_GLOBALLY = true;
        public boolean SWAP_SIDES_IN_COMPARE_BRANCHES = false;
        @AbstractCollection(surroundWithTag=false)
        @Tag(value="push-targets")
        public List<PushTargetInfo> PUSH_TARGETS = ContainerUtil.newArrayList();
        @Property(surroundWithTag=false, flat=true)
        public DvcsBranchSettings FAVORITE_BRANCH_SETTINGS = new DvcsBranchSettings();
    }

    public static enum UpdateChangesPolicy {
        STASH,
        SHELVE;

    }
}

