/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.ShowAllAffectedGenericAction;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.HistoryAsTreeProvider;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsBaseRevisionAdviser;
import com.intellij.openapi.vcs.history.VcsCacheableHistorySessionFactory;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.vcs.history.VcsHistoryProviderEx;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.changes.GitChangeUtils;
import git4idea.config.GitExecutableValidator;
import git4idea.history.GitDiffFromHistoryHandler;
import git4idea.history.GitHistoryUtils;
import git4idea.history.browser.SHAHash;
import git4idea.log.GitShowCommitInLogAction;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHistoryProvider
implements VcsHistoryProviderEx,
VcsCacheableHistorySessionFactory<Boolean, VcsAbstractHistorySession>,
VcsBaseRevisionAdviser {
    private static final Logger LOG = Logger.getInstance((String)GitHistoryProvider.class.getName());
    @NotNull
    private final Project myProject;

    public GitHistoryProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryProvider", "<init>"));
        }
        this.myProject = project;
    }

    public VcsDependentHistoryComponents getUICustomization(VcsHistorySession session, JComponent forShortcutRegistration) {
        return VcsDependentHistoryComponents.createOnlyColumns((ColumnInfo[])ColumnInfo.EMPTY_ARRAY);
    }

    public AnAction[] getAdditionalActions(Runnable refresher) {
        return new AnAction[]{ShowAllAffectedGenericAction.getInstance(), ActionManager.getInstance().getAction("Vcs.CopyRevisionNumberAction"), new GitShowCommitInLogAction()};
    }

    public boolean isDateOmittable() {
        return false;
    }

    @Nullable
    public String getHelpId() {
        return null;
    }

    public FilePath getUsedFilePath(VcsAbstractHistorySession session) {
        return null;
    }

    public Boolean getAddinionallyCachedData(VcsAbstractHistorySession session) {
        return null;
    }

    public VcsAbstractHistorySession createFromCachedData(Boolean aBoolean, @NotNull List<VcsFileRevision> revisions, @NotNull FilePath filePath, VcsRevisionNumber currentRevision) {
        if (revisions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisions", "git4idea/history/GitHistoryProvider", "createFromCachedData"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "git4idea/history/GitHistoryProvider", "createFromCachedData"));
        }
        return this.createSession(filePath, revisions, currentRevision);
    }

    @Nullable
    public VcsAbstractHistorySession createSessionFor(FilePath filePath) throws VcsException {
        List<VcsFileRevision> revisions = null;
        try {
            revisions = GitHistoryUtils.history(this.myProject, filePath, new String[0]);
        }
        catch (VcsException e) {
            GitVcs.getInstance(this.myProject).getExecutableValidator().showNotificationOrThrow(e);
        }
        return this.createSession(filePath, revisions, null);
    }

    private VcsAbstractHistorySession createSession(final FilePath filePath, List<VcsFileRevision> revisions, @Nullable VcsRevisionNumber number) {
        return new VcsAbstractHistorySession(revisions, number){

            @Nullable
            protected VcsRevisionNumber calcCurrentRevisionNumber() {
                try {
                    return GitHistoryUtils.getCurrentRevision(GitHistoryProvider.this.myProject, filePath, "HEAD");
                }
                catch (VcsException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Unable to retrieve the current revision number", (Throwable)e);
                    }
                    return null;
                }
            }

            public HistoryAsTreeProvider getHistoryAsTreeProvider() {
                return null;
            }

            public VcsHistorySession copy() {
                return GitHistoryProvider.this.createSession(filePath, this.getRevisionList(), this.getCurrentRevisionNumber());
            }
        };
    }

    @Nullable
    public VcsFileRevision getLastRevision(FilePath filePath) throws VcsException {
        List<VcsFileRevision> history = GitHistoryUtils.history(this.myProject, filePath, "--max-count=1");
        if (history.isEmpty()) {
            return null;
        }
        return history.get(0);
    }

    public boolean getBaseVersionContent(FilePath filePath, Processor<String> processor, String beforeVersionId) throws VcsException {
        if (StringUtil.isEmptyOrSpaces((String)beforeVersionId) || filePath.getVirtualFile() == null) {
            return false;
        }
        VirtualFile root = GitUtil.getGitRoot(filePath);
        if (root == null) {
            return false;
        }
        SHAHash shaHash = GitChangeUtils.commitExists(this.myProject, root, beforeVersionId, null, "HEAD");
        if (shaHash == null) {
            throw new VcsException("Can not apply patch to " + filePath.getPath() + ".\nCan not find revision '" + beforeVersionId + "'.");
        }
        ContentRevision content = GitVcs.getInstance(this.myProject).getDiffProvider().createFileContent((VcsRevisionNumber)new GitRevisionNumber(shaHash.getValue()), filePath.getVirtualFile());
        if (content == null) {
            throw new VcsException("Can not load content of '" + filePath.getPath() + "' for revision '" + shaHash.getValue() + "'");
        }
        return !processor.process((Object)content.getContent());
    }

    public void reportAppendableHistory(FilePath path, VcsAppendableHistorySessionPartner partner) throws VcsException {
        this.reportAppendableHistory(path, null, partner);
    }

    public void reportAppendableHistory(@NotNull FilePath path, @Nullable VcsRevisionNumber startingRevision, @NotNull VcsAppendableHistorySessionPartner partner) throws VcsException {
        String[] stringArray;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitHistoryProvider", "reportAppendableHistory"));
        }
        if (partner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partner", "git4idea/history/GitHistoryProvider", "reportAppendableHistory"));
        }
        VcsAbstractHistorySession emptySession = this.createSession(path, Collections.emptyList(), null);
        partner.reportCreatedEmptySession(emptySession);
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        if (vcsConfiguration.LIMIT_HISTORY) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--max-count=" + vcsConfiguration.MAXIMUM_HISTORY_ROWS;
        } else {
            stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] additionalArgs = stringArray;
        GitExecutableValidator validator = GitVcs.getInstance(this.myProject).getExecutableValidator();
        GitHistoryUtils.history(this.myProject, GitHistoryProvider.refreshPath(path), null, (VcsRevisionNumber)(startingRevision == null ? GitRevisionNumber.HEAD : startingRevision), (Consumer<GitFileRevision>)((Consumer)fileRevision -> {
            if (partner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partner", "git4idea/history/GitHistoryProvider", "lambda$reportAppendableHistory$0"));
            }
            partner.acceptRevision((VcsFileRevision)fileRevision);
        }), (Consumer<VcsException>)((Consumer)exception -> {
            if (partner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partner", "git4idea/history/GitHistoryProvider", "lambda$reportAppendableHistory$1"));
            }
            if (validator.checkExecutableAndNotifyIfNeeded()) {
                partner.reportException(exception);
            }
        }), additionalArgs);
    }

    @NotNull
    private static FilePath refreshPath(@NotNull FilePath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitHistoryProvider", "refreshPath"));
        }
        VirtualFile virtualFile = path.getVirtualFile();
        if (virtualFile == null) {
            FilePath filePath = path;
            if (filePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryProvider", "refreshPath"));
            }
            return filePath;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)virtualFile);
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryProvider", "refreshPath"));
        }
        return filePath;
    }

    public boolean supportsHistoryForDirectories() {
        return true;
    }

    public DiffFromHistoryHandler getHistoryDiffHandler() {
        return new GitDiffFromHistoryHandler(this.myProject);
    }

    public boolean canShowHistoryFor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/history/GitHistoryProvider", "canShowHistoryFor"));
        }
        GitRepositoryManager manager = GitUtil.getRepositoryManager(this.myProject);
        GitRepository repository = (GitRepository)manager.getRepositoryForFileQuick(file);
        return repository != null && !repository.isFresh();
    }
}

