/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionDescription;
import com.intellij.openapi.vcs.history.VcsRevisionDescriptionImpl;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import git4idea.GitCommit;
import git4idea.GitFileRevision;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerAdapter;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitChangeType;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import git4idea.history.GitLogStatusInfo;
import git4idea.history.GitLogUtil;
import git4idea.history.browser.SHAHash;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHistoryUtils {
    private static final Logger LOG = Logger.getInstance((String)"#git4idea.history.GitHistoryUtils");

    private GitHistoryUtils() {
    }

    @Nullable
    public static VcsRevisionNumber getCurrentRevision(@NotNull Project project, @NotNull FilePath filePath, @Nullable String branch) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "getCurrentRevision"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "git4idea/history/GitHistoryUtils", "getCurrentRevision"));
        }
        filePath = GitHistoryUtils.getLastCommitName(project, filePath);
        GitSimpleHandler h = new GitSimpleHandler(project, GitUtil.getGitRoot(filePath), GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME);
        h.setSilent(true);
        h.addParameters("-n1", parser.getPretty());
        h.addParameters(!StringUtil.isEmpty((String)branch) ? branch : "--all");
        h.endOptions();
        h.addRelativePaths(filePath);
        String result = h.run();
        if (result.length() == 0) {
            return null;
        }
        GitLogRecord record = parser.parseOneRecord(result);
        if (record == null) {
            return null;
        }
        record.setUsedHandler(h);
        return new GitRevisionNumber(record.getHash(), record.getDate());
    }

    @Nullable
    public static VcsRevisionDescription getCurrentRevisionDescription(@NotNull Project project, @NotNull FilePath filePath) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "getCurrentRevisionDescription"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "git4idea/history/GitHistoryUtils", "getCurrentRevisionDescription"));
        }
        filePath = GitHistoryUtils.getLastCommitName(project, filePath);
        GitSimpleHandler h = new GitSimpleHandler(project, GitUtil.getGitRoot(filePath), GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY);
        h.setSilent(true);
        h.addParameters("-n1", parser.getPretty());
        h.addParameters("--all");
        h.endOptions();
        h.addRelativePaths(filePath);
        String result = h.run();
        if (result.length() == 0) {
            return null;
        }
        GitLogRecord record = parser.parseOneRecord(result);
        if (record == null) {
            return null;
        }
        record.setUsedHandler(h);
        String author = Comparing.equal((String)record.getAuthorName(), (String)record.getCommitterName()) ? record.getAuthorName() : record.getAuthorName() + " (" + record.getCommitterName() + ")";
        return new VcsRevisionDescriptionImpl((VcsRevisionNumber)new GitRevisionNumber(record.getHash(), record.getDate()), record.getDate(), author, record.getFullMessage());
    }

    @Nullable
    public static ItemLatestState getLastRevision(@NotNull Project project, @NotNull FilePath filePath) throws VcsException {
        GitRemoteBranch t;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "getLastRevision"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "git4idea/history/GitHistoryUtils", "getLastRevision"));
        }
        VirtualFile root = GitUtil.getGitRoot(filePath);
        GitLocalBranch c = GitBranchUtil.getCurrentBranch(project, root);
        GitRemoteBranch gitRemoteBranch = t = c == null ? null : GitBranchUtil.tracked(project, root, c.getName());
        if (t == null) {
            return new ItemLatestState(GitHistoryUtils.getCurrentRevision(project, filePath, null), true, false);
        }
        filePath = GitHistoryUtils.getLastCommitName(project, filePath);
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.PARENTS);
        h.setSilent(true);
        h.addParameters("-n1", parser.getPretty(), "--name-status", t.getFullName());
        h.endOptions();
        h.addRelativePaths(filePath);
        String result = h.run();
        if (result.length() == 0) {
            return null;
        }
        GitLogRecord record = parser.parseOneRecord(result);
        if (record == null) {
            return null;
        }
        List<Change> changes = record.parseChanges(project, root);
        boolean exists = changes.isEmpty() || !FileStatus.DELETED.equals(changes.get(0).getFileStatus());
        record.setUsedHandler(h);
        return new ItemLatestState((VcsRevisionNumber)new GitRevisionNumber(record.getHash(), record.getDate()), exists, false);
    }

    public static void history(@NotNull Project project, @NotNull FilePath path, @Nullable VirtualFile root, @NotNull Consumer<GitFileRevision> consumer, @NotNull Consumer<VcsException> exceptionConsumer, String ... parameters) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "history"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitHistoryUtils", "history"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "git4idea/history/GitHistoryUtils", "history"));
        }
        if (exceptionConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionConsumer", "git4idea/history/GitHistoryUtils", "history"));
        }
        GitHistoryUtils.history(project, path, root, (VcsRevisionNumber)GitRevisionNumber.HEAD, consumer, exceptionConsumer, parameters);
    }

    public static void history(@NotNull Project project, @NotNull FilePath path, @Nullable VirtualFile root, @NotNull VcsRevisionNumber startingRevision, @NotNull Consumer<GitFileRevision> consumer, final @NotNull Consumer<VcsException> exceptionConsumer, String ... parameters) {
        VirtualFile finalRoot;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "history"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitHistoryUtils", "history"));
        }
        if (startingRevision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startingRevision", "git4idea/history/GitHistoryUtils", "history"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "git4idea/history/GitHistoryUtils", "history"));
        }
        if (exceptionConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionConsumer", "git4idea/history/GitHistoryUtils", "history"));
        }
        FilePath filePath = GitHistoryUtils.getLastCommitName(project, path);
        try {
            finalRoot = root == null ? GitUtil.getGitRoot(filePath) : root;
        }
        catch (VcsException e) {
            exceptionConsumer.consume((Object)e);
            return;
        }
        GitLogParser logParser = new GitLogParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY, GitLogParser.GitLogOption.AUTHOR_TIME);
        AtomicReference<String> firstCommit = new AtomicReference<String>(startingRevision.asString());
        AtomicReference<String> firstCommitParent = new AtomicReference<String>(firstCommit.get());
        AtomicReference<FilePath> currentPath = new AtomicReference<FilePath>(filePath);
        AtomicReference<GitLineHandler> logHandler = new AtomicReference<GitLineHandler>();
        AtomicBoolean skipFurtherOutput = new AtomicBoolean();
        final Consumer resultAdapter = record -> {
            if (exceptionConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionConsumer", "git4idea/history/GitHistoryUtils", "lambda$history$0"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "git4idea/history/GitHistoryUtils", "lambda$history$0"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "lambda$history$0"));
            }
            if (skipFurtherOutput.get()) {
                return;
            }
            if (record == null) {
                exceptionConsumer.consume((Object)new VcsException("revision details are null."));
                return;
            }
            record.setUsedHandler((GitHandler)logHandler.get());
            GitRevisionNumber revision = new GitRevisionNumber(record.getHash(), record.getDate());
            firstCommit.set(record.getHash());
            String[] parentHashes = record.getParentsHashes();
            if (parentHashes.length < 1) {
                firstCommitParent.set(null);
            } else {
                firstCommitParent.set(parentHashes[0]);
            }
            String message = record.getFullMessage();
            try {
                List<FilePath> paths = record.getFilePaths(finalRoot);
                FilePath revisionPath = paths.size() > 0 ? paths.get(0) : (FilePath)currentPath.get();
                Couple authorPair = Couple.of((Object)record.getAuthorName(), (Object)record.getAuthorEmail());
                Couple committerPair = Couple.of((Object)record.getCommitterName(), (Object)record.getCommitterEmail());
                List<String> parents = Arrays.asList(parentHashes);
                consumer.consume((Object)new GitFileRevision(project, finalRoot, revisionPath, revision, (Couple<Couple<String>>)Couple.of((Object)authorPair, (Object)committerPair), message, null, new Date(record.getAuthorTimeStamp()), parents));
                List<GitLogStatusInfo> statusInfos = record.getStatusInfos();
                if (statusInfos.isEmpty()) {
                    return;
                }
                if (statusInfos.get(0).getType() == GitChangeType.ADDED && !filePath.isDirectory()) {
                    skipFurtherOutput.set(true);
                }
            }
            catch (VcsException e) {
                exceptionConsumer.consume((Object)e);
            }
        };
        GitVcs vcs = GitVcs.getInstance(project);
        GitVersion version = vcs != null ? vcs.getVersion() : GitVersion.NULL;
        final AtomicBoolean criticalFailure = new AtomicBoolean();
        while (currentPath.get() != null && firstCommitParent.get() != null) {
            logHandler.set(GitHistoryUtils.getLogHandler(project, version, finalRoot, logParser, currentPath.get(), firstCommitParent.get(), parameters));
            final MyTokenAccumulator accumulator = new MyTokenAccumulator(logParser);
            final Semaphore semaphore = new Semaphore();
            ((GitLineHandler)logHandler.get()).addLineListener(new GitLineHandlerAdapter(){

                @Override
                public void onLineAvailable(String line, Key outputType) {
                    GitLogRecord record = accumulator.acceptLine(line);
                    if (record != null) {
                        resultAdapter.consume((Object)record);
                    }
                }

                @Override
                public void startFailed(Throwable exception) {
                    try {
                        exceptionConsumer.consume((Object)new VcsException(exception));
                    }
                    finally {
                        criticalFailure.set(true);
                        semaphore.up();
                    }
                }

                @Override
                public void processTerminated(int exitCode) {
                    try {
                        super.processTerminated(exitCode);
                        GitLogRecord record = accumulator.processLast();
                        if (record != null) {
                            resultAdapter.consume((Object)record);
                        }
                    }
                    catch (ProcessCanceledException record) {
                    }
                    catch (Throwable t) {
                        LOG.error(t);
                        exceptionConsumer.consume((Object)new VcsException("Internal error " + t.getMessage(), t));
                        criticalFailure.set(true);
                    }
                    finally {
                        semaphore.up();
                    }
                }
            });
            semaphore.down();
            ((GitLineHandler)logHandler.get()).start();
            semaphore.waitFor();
            if (criticalFailure.get()) {
                return;
            }
            try {
                Pair<String, FilePath> firstCommitParentAndPath = GitHistoryUtils.getFirstCommitParentAndPathIfRename(project, finalRoot, firstCommit.get(), currentPath.get(), version);
                currentPath.set(firstCommitParentAndPath == null ? null : (FilePath)firstCommitParentAndPath.second);
                firstCommitParent.set(firstCommitParentAndPath == null ? null : (String)firstCommitParentAndPath.first);
                skipFurtherOutput.set(false);
            }
            catch (VcsException e) {
                LOG.warn("Tried to get first commit rename path", (Throwable)e);
                exceptionConsumer.consume((Object)e);
                return;
            }
        }
    }

    @NotNull
    private static GitLineHandler getLogHandler(@NotNull Project project, @NotNull GitVersion version, @NotNull VirtualFile root, @NotNull GitLogParser parser, @NotNull FilePath path, @NotNull String lastCommit, String ... parameters) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "getLogHandler"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "git4idea/history/GitHistoryUtils", "getLogHandler"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "getLogHandler"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "git4idea/history/GitHistoryUtils", "getLogHandler"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitHistoryUtils", "getLogHandler"));
        }
        if (lastCommit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastCommit", "git4idea/history/GitHistoryUtils", "getLogHandler"));
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LOG);
        h.setStdoutSuppressed(true);
        h.addParameters("--name-status", parser.getPretty(), "--encoding=UTF-8", lastCommit);
        if (GitVersionSpecialty.FULL_HISTORY_SIMPLIFY_MERGES_WORKS_CORRECTLY.existsIn(version) && Registry.is((String)"git.file.history.full")) {
            h.addParameters("--full-history", "--simplify-merges");
        }
        if (parameters != null && parameters.length > 0) {
            h.addParameters(parameters);
        }
        h.endOptions();
        h.addRelativePaths(path);
        GitLineHandler gitLineHandler = h;
        if (gitLineHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "getLogHandler"));
        }
        return gitLineHandler;
    }

    @Nullable
    private static Pair<String, FilePath> getFirstCommitParentAndPathIfRename(@NotNull Project project, @NotNull VirtualFile root, @NotNull String commit, @NotNull FilePath filePath, @NotNull GitVersion version) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "getFirstCommitParentAndPathIfRename"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "getFirstCommitParentAndPathIfRename"));
        }
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "git4idea/history/GitHistoryUtils", "getFirstCommitParentAndPathIfRename"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "git4idea/history/GitHistoryUtils", "getFirstCommitParentAndPathIfRename"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "git4idea/history/GitHistoryUtils", "getFirstCommitParentAndPathIfRename"));
        }
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.SHOW);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.PARENTS);
        h.setStdoutSuppressed(true);
        h.addParameters("-M", "--name-status", parser.getPretty(), "--encoding=UTF-8", commit);
        if (!GitVersionSpecialty.FOLLOW_IS_BUGGY_IN_THE_LOG.existsIn(version)) {
            h.addParameters("--follow");
            h.endOptions();
            h.addRelativePaths(filePath);
        } else {
            h.endOptions();
        }
        String output = h.run();
        List<GitLogRecord> records = parser.parse(output);
        if (records.isEmpty()) {
            return null;
        }
        GitLogRecord record = records.get(0);
        List<Change> changes = record.parseChanges(project, root);
        for (Change change : changes) {
            if (!change.isMoved() && !change.isRenamed() || !filePath.equals(((ContentRevision)ObjectUtils.notNull((Object)change.getAfterRevision())).getFile())) continue;
            String[] parents = record.getParentsHashes();
            String parent = parents.length > 0 ? parents[0] : null;
            return Pair.create((Object)parent, (Object)((ContentRevision)ObjectUtils.notNull((Object)change.getBeforeRevision())).getFile());
        }
        return null;
    }

    @Nullable
    public static List<VcsCommitMetadata> readLastCommits(@NotNull Project project, @NotNull VirtualFile root, String ... refs) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "readLastCommits"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "readLastCommits"));
        }
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "git4idea/history/GitHistoryUtils", "readLastCommits"));
        }
        VcsLogObjectsFactory factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return null;
        }
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.NONE, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.RAW_BODY, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.AUTHOR_TIME);
        h.setSilent(true);
        h.addParameters("--no-walk");
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        h.addParameters(refs);
        h.endOptions();
        String output = h.run();
        List<GitLogRecord> records = parser.parse(output);
        if (records.size() != refs.length) {
            return null;
        }
        return ContainerUtil.map(records, record -> {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "lambda$readLastCommits$1"));
            }
            return factory.createCommitMetadata(factory.createHash(record.getHash()), GitLogUtil.getParentHashes(factory, record), record.getCommitTime(), root, record.getSubject(), record.getAuthorName(), record.getAuthorEmail(), record.getFullMessage(), record.getCommitterName(), record.getCommitterEmail(), record.getAuthorTimeStamp());
        });
    }

    @NotNull
    public static List<VcsFileRevision> history(@NotNull Project project, @NotNull FilePath path, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "history"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitHistoryUtils", "history"));
        }
        VirtualFile root = ProjectLevelVcsManager.getInstance((Project)project).getVcsRootFor(path);
        if (root == null) {
            throw new VcsException("The file " + path + " is not under vcs.");
        }
        List<VcsFileRevision> list = GitHistoryUtils.history(project, path, root, parameters);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "history"));
        }
        return list;
    }

    @NotNull
    public static List<VcsFileRevision> history(@NotNull Project project, @NotNull FilePath path, @Nullable VirtualFile root, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "history"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitHistoryUtils", "history"));
        }
        List<VcsFileRevision> list = GitHistoryUtils.history(project, path, root, (VcsRevisionNumber)GitRevisionNumber.HEAD, parameters);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "history"));
        }
        return list;
    }

    @NotNull
    public static List<VcsFileRevision> history(@NotNull Project project, @NotNull FilePath path, @Nullable VirtualFile root, @NotNull VcsRevisionNumber startingFrom, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "history"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitHistoryUtils", "history"));
        }
        if (startingFrom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startingFrom", "git4idea/history/GitHistoryUtils", "history"));
        }
        ArrayList<VcsFileRevision> rc = new ArrayList<VcsFileRevision>();
        ArrayList exceptions = new ArrayList();
        GitHistoryUtils.history(project, path, root, startingFrom, (Consumer<GitFileRevision>)((Consumer)rc::add), (Consumer<VcsException>)((Consumer)exceptions::add), parameters);
        if (!exceptions.isEmpty()) {
            throw (VcsException)((Object)exceptions.get(0));
        }
        ArrayList<VcsFileRevision> arrayList = rc;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "history"));
        }
        return arrayList;
    }

    @Deprecated
    @NotNull
    public static List<Pair<SHAHash, Date>> onlyHashesHistory(@NotNull Project project, @NotNull FilePath path, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "onlyHashesHistory"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitHistoryUtils", "onlyHashesHistory"));
        }
        VirtualFile root = GitUtil.getGitRoot(path);
        List<Pair<SHAHash, Date>> list = GitHistoryUtils.onlyHashesHistory(project, path, root, parameters);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "onlyHashesHistory"));
        }
        return list;
    }

    @Deprecated
    @NotNull
    public static List<Pair<SHAHash, Date>> onlyHashesHistory(@NotNull Project project, @NotNull FilePath path, @NotNull VirtualFile root, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "onlyHashesHistory"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitHistoryUtils", "onlyHashesHistory"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "onlyHashesHistory"));
        }
        path = GitHistoryUtils.getLastCommitName(project, path);
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME);
        h.setStdoutSuppressed(true);
        h.addParameters(parameters);
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        h.endOptions();
        h.addRelativePaths(path);
        String output = h.run();
        ArrayList<Pair<SHAHash, Date>> rc = new ArrayList<Pair<SHAHash, Date>>();
        for (GitLogRecord record : parser.parse(output)) {
            record.setUsedHandler(h);
            rc.add((Pair<SHAHash, Date>)Pair.create((Object)new SHAHash(record.getHash()), (Object)record.getDate()));
        }
        ArrayList<Pair<SHAHash, Date>> arrayList = rc;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "onlyHashesHistory"));
        }
        return arrayList;
    }

    @NotNull
    public static List<GitCommit> history(@NotNull Project project, @NotNull VirtualFile root, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "history"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "history"));
        }
        VcsLogObjectsFactory factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            List<GitCommit> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "history"));
            }
            return list;
        }
        List<GitCommit> list = GitLogUtil.collectFullDetails(project, root, parameters);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "history"));
        }
        return list;
    }

    @NotNull
    public static String[] formHashParameters(@NotNull GitVcs vcs, @NotNull Collection<String> hashes2) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "git4idea/history/GitHistoryUtils", "formHashParameters"));
        }
        if (hashes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashes", "git4idea/history/GitHistoryUtils", "formHashParameters"));
        }
        ArrayList parameters = ContainerUtil.newArrayList();
        parameters.add(GitLogUtil.getNoWalkParameter(vcs));
        parameters.addAll(hashes2);
        String[] stringArray = ArrayUtil.toStringArray((Collection)parameters);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "formHashParameters"));
        }
        return stringArray;
    }

    public static void loadDetails(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<? super GitCommit> commitConsumer, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "loadDetails"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "loadDetails"));
        }
        if (commitConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitConsumer", "git4idea/history/GitHistoryUtils", "loadDetails"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "git4idea/history/GitHistoryUtils", "loadDetails"));
        }
        GitLogUtil.readFullDetails(project, root, commitConsumer, parameters);
    }

    public static long getAuthorTime(@NotNull Project project, @NotNull FilePath path, @NotNull String commitsId) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "getAuthorTime"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitHistoryUtils", "getAuthorTime"));
        }
        if (commitsId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitsId", "git4idea/history/GitHistoryUtils", "getAuthorTime"));
        }
        path = GitHistoryUtils.getLastCommitName(project, path);
        VirtualFile root = GitUtil.getGitRoot(path);
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.SHOW);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.AUTHOR_TIME);
        h.setSilent(true);
        h.addParameters("--name-status", parser.getPretty(), "--encoding=UTF-8");
        h.addParameters(commitsId);
        String output = h.run();
        GitLogRecord logRecord = parser.parseOneRecord(output);
        if (logRecord == null) {
            throw new VcsException("Can not parse log output \"" + output + "\"");
        }
        return logRecord.getAuthorTimeStamp();
    }

    public static FilePath getLastCommitName(@NotNull Project project, FilePath path) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "getLastCommitName"));
        }
        if (project.isDefault()) {
            return path;
        }
        ChangeListManager changeManager = ChangeListManager.getInstance((Project)project);
        Change change = changeManager.getChange(path);
        if (change != null && change.getType() == Change.Type.MOVED) {
            assert (change.getBeforeRevision() != null) : "Move change always have beforeRevision";
            path = change.getBeforeRevision().getFile();
        }
        return path;
    }

    @Nullable
    public static GitRevisionNumber getMergeBase(@NotNull Project project, @NotNull VirtualFile root, @NotNull String first, @NotNull String second) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "getMergeBase"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "getMergeBase"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "git4idea/history/GitHistoryUtils", "getMergeBase"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "git4idea/history/GitHistoryUtils", "getMergeBase"));
        }
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.MERGE_BASE);
        h.setSilent(true);
        h.addParameters(first, second);
        String output = h.run().trim();
        if (output.length() == 0) {
            return null;
        }
        return GitRevisionNumber.resolve(project, root, output);
    }

    private static class MyTokenAccumulator {
        @NotNull
        private final StringBuilder myBuffer;
        @NotNull
        private final GitLogParser myParser;
        private boolean myNotStarted;

        public MyTokenAccumulator(@NotNull GitLogParser parser) {
            if (parser == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "git4idea/history/GitHistoryUtils$MyTokenAccumulator", "<init>"));
            }
            this.myBuffer = new StringBuilder();
            this.myNotStarted = true;
            this.myParser = parser;
        }

        @Nullable
        public GitLogRecord acceptLine(String s) {
            boolean recordStart = s.startsWith("\u0001\u0001");
            if (recordStart) {
                s = s.substring("\u0001\u0001".length());
            }
            if (this.myNotStarted) {
                this.myBuffer.append(s);
                this.myBuffer.append("\n");
                this.myNotStarted = false;
                return null;
            }
            if (recordStart) {
                String line = this.myBuffer.toString();
                this.myBuffer.setLength(0);
                this.myBuffer.append(s);
                this.myBuffer.append("\n");
                return this.processResult(line);
            }
            this.myBuffer.append(s);
            this.myBuffer.append("\n");
            return null;
        }

        @Nullable
        public GitLogRecord processLast() {
            return this.processResult(this.myBuffer.toString());
        }

        @Nullable
        private GitLogRecord processResult(@NotNull String line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "git4idea/history/GitHistoryUtils$MyTokenAccumulator", "processResult"));
            }
            return this.myParser.parseOneRecord(line);
        }
    }
}

