/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.merge.GitMergeProvider;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.StringScanner;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class GitConflictResolver {
    private static final Logger LOG = Logger.getInstance(GitConflictResolver.class);
    @NotNull
    private final Collection<VirtualFile> myRoots;
    @NotNull
    private final Params myParams;
    @NotNull
    protected final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final AbstractVcsHelper myVcsHelper;
    @NotNull
    private final GitVcs myVcs;

    @Deprecated
    public GitConflictResolver(@NotNull Project project, @NotNull Git git, @NotNull GitPlatformFacade facade, @NotNull Collection<VirtualFile> roots, @NotNull Params params) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/merge/GitConflictResolver", "<init>"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/merge/GitConflictResolver", "<init>"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "git4idea/merge/GitConflictResolver", "<init>"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "git4idea/merge/GitConflictResolver", "<init>"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "git4idea/merge/GitConflictResolver", "<init>"));
        }
        this(project, git, roots, params);
    }

    public GitConflictResolver(@NotNull Project project, @NotNull Git git, @NotNull Collection<VirtualFile> roots, @NotNull Params params) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/merge/GitConflictResolver", "<init>"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/merge/GitConflictResolver", "<init>"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "git4idea/merge/GitConflictResolver", "<init>"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "git4idea/merge/GitConflictResolver", "<init>"));
        }
        this.myProject = project;
        this.myGit = git;
        this.myRoots = roots;
        this.myParams = params;
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.myVcsHelper = AbstractVcsHelper.getInstance((Project)project);
        this.myVcs = (GitVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)GitVcs.getInstance(this.myProject))));
    }

    public final boolean merge() {
        return this.merge(false);
    }

    protected boolean proceedIfNothingToMerge() throws VcsException {
        return true;
    }

    protected boolean proceedAfterAllMerged() throws VcsException {
        return true;
    }

    public final boolean mergeNoProceed() {
        return this.merge(true);
    }

    protected void notifyUnresolvedRemain() {
        this.notifyWarning(this.myParams.myErrorNotificationTitle, "You have to <a href='resolve'>resolve</a> all conflicts first." + this.myParams.myErrorNotificationAdditionalDescription);
    }

    private void notifyUnresolvedRemainAfterNotification() {
        this.notifyWarning("Not all conflicts resolved", "You should <a href='resolve'>resolve</a> all conflicts before update. <br>" + this.myParams.myErrorNotificationAdditionalDescription);
    }

    private void notifyWarning(String title, String content) {
        VcsNotifier.getInstance((Project)this.myProject).notifyImportantWarning(title, content, (NotificationListener)new ResolveNotificationListener());
    }

    private boolean merge(boolean mergeDialogInvokedFromNotification) {
        block6: {
            try {
                Collection<VirtualFile> initiallyUnmergedFiles = this.getUnmergedFiles(this.myRoots);
                if (initiallyUnmergedFiles.isEmpty()) {
                    LOG.info("merge: no unmerged files");
                    return mergeDialogInvokedFromNotification ? true : this.proceedIfNothingToMerge();
                }
                this.showMergeDialog(initiallyUnmergedFiles);
                Collection<VirtualFile> unmergedFilesAfterResolve = this.getUnmergedFiles(this.myRoots);
                if (unmergedFilesAfterResolve.isEmpty()) {
                    LOG.info("merge no more unmerged files");
                    return mergeDialogInvokedFromNotification ? true : this.proceedAfterAllMerged();
                }
                LOG.info("mergeFiles unmerged files remain: " + unmergedFilesAfterResolve);
                if (mergeDialogInvokedFromNotification) {
                    this.notifyUnresolvedRemainAfterNotification();
                } else {
                    this.notifyUnresolvedRemain();
                }
            }
            catch (VcsException e) {
                if (!this.myVcs.getExecutableValidator().checkExecutableAndNotifyIfNeeded()) break block6;
                this.notifyException(e);
            }
        }
        return false;
    }

    private void showMergeDialog(@NotNull Collection<VirtualFile> initiallyUnmergedFiles) {
        if (initiallyUnmergedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initiallyUnmergedFiles", "git4idea/merge/GitConflictResolver", "showMergeDialog"));
        }
        TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (initiallyUnmergedFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initiallyUnmergedFiles", "git4idea/merge/GitConflictResolver", "lambda$showMergeDialog$0"));
            }
            GitMergeProvider mergeProvider = new GitMergeProvider(this.myProject, this.myParams.reverse);
            this.myVcsHelper.showMergeDialog(new ArrayList(initiallyUnmergedFiles), (MergeProvider)mergeProvider, this.myParams.myMergeDialogCustomizer);
        });
    }

    private void notifyException(VcsException e) {
        LOG.info("mergeFiles ", (Throwable)e);
        String description = "Couldn't check the working tree for unmerged files because of an error.";
        VcsNotifier.getInstance((Project)this.myProject).notifyError(this.myParams.myErrorNotificationTitle, "Couldn't check the working tree for unmerged files because of an error." + this.myParams.myErrorNotificationAdditionalDescription + "<br/>" + e.getLocalizedMessage(), (NotificationListener)new ResolveNotificationListener());
    }

    @NotNull
    protected NotificationListener getResolveLinkListener() {
        ResolveNotificationListener resolveNotificationListener = new ResolveNotificationListener();
        if (resolveNotificationListener == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/merge/GitConflictResolver", "getResolveLinkListener"));
        }
        return resolveNotificationListener;
    }

    private Collection<VirtualFile> getUnmergedFiles(@NotNull Collection<VirtualFile> roots) throws VcsException {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "git4idea/merge/GitConflictResolver", "getUnmergedFiles"));
        }
        HashSet<VirtualFile> unmergedFiles = new HashSet<VirtualFile>();
        for (VirtualFile root : roots) {
            unmergedFiles.addAll(this.getUnmergedFiles(root));
        }
        return unmergedFiles;
    }

    private Collection<VirtualFile> getUnmergedFiles(@NotNull VirtualFile root) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/merge/GitConflictResolver", "getUnmergedFiles"));
        }
        return this.unmergedFiles(root);
    }

    private List<VirtualFile> unmergedFiles(VirtualFile root) throws VcsException {
        GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
        if (repository == null) {
            LOG.error("Repository not found for root " + root);
            return Collections.emptyList();
        }
        GitCommandResult result = this.myGit.getUnmergedFiles(repository);
        if (!result.success()) {
            throw new VcsException(result.getErrorOutputAsJoinedString());
        }
        String output = StringUtil.join(result.getOutput(), (String)"\n");
        HashSet unmergedPaths = ContainerUtil.newHashSet();
        StringScanner s = new StringScanner(output);
        while (s.hasMoreData()) {
            if (s.isEol()) {
                s.nextLine();
                continue;
            }
            s.boundedToken('\t');
            String relative = s.line();
            unmergedPaths.add(GitUtil.unescapePath(relative));
        }
        if (unmergedPaths.size() == 0) {
            return Collections.emptyList();
        }
        List files = ContainerUtil.map((Collection)unmergedPaths, path -> new File(root.getPath(), (String)path));
        return DvcsUtil.sortVirtualFilesByPresentation((Collection)DvcsUtil.findVirtualFilesWithRefresh((List)files));
    }

    private class ResolveNotificationListener
    implements NotificationListener {
        private ResolveNotificationListener() {
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "git4idea/merge/GitConflictResolver$ResolveNotificationListener", "hyperlinkUpdate"));
            }
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/merge/GitConflictResolver$ResolveNotificationListener", "hyperlinkUpdate"));
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equals("resolve")) {
                notification.expire();
                ApplicationManager.getApplication().executeOnPooledThread(() -> GitConflictResolver.this.mergeNoProceed());
            }
        }
    }

    public static class Params {
        private boolean reverse;
        private String myErrorNotificationTitle = "";
        private String myErrorNotificationAdditionalDescription = "";
        private String myMergeDescription = "";
        private MergeDialogCustomizer myMergeDialogCustomizer = new MergeDialogCustomizer(){

            public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
                if (files == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "git4idea/merge/GitConflictResolver$Params$1", "getMultipleFileMergeDescription"));
                }
                return myMergeDescription;
            }
        };

        public Params setReverse(boolean reverseMerge) {
            this.reverse = reverseMerge;
            return this;
        }

        public Params setErrorNotificationTitle(String errorNotificationTitle) {
            this.myErrorNotificationTitle = errorNotificationTitle;
            return this;
        }

        public Params setErrorNotificationAdditionalDescription(String errorNotificationAdditionalDescription) {
            this.myErrorNotificationAdditionalDescription = errorNotificationAdditionalDescription;
            return this;
        }

        public Params setMergeDescription(String mergeDescription) {
            this.myMergeDescription = mergeDescription;
            return this;
        }

        public Params setMergeDialogCustomizer(MergeDialogCustomizer mergeDialogCustomizer) {
            this.myMergeDialogCustomizer = mergeDialogCustomizer;
            return this;
        }
    }
}

