/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.VcsPushOptionValue;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.JBUI;
import git4idea.push.GitPushTagMode;
import git4idea.push.GitVcsPushOptionValue;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushOptionsPanel
extends VcsPushOptionsPanel {
    @NotNull
    private final JBCheckBox myPushTags;
    @NotNull
    private final ComboBox<GitPushTagMode> myPushTagsMode;
    @NotNull
    private final JBCheckBox myRunHooks;

    public GitPushOptionsPanel(@Nullable GitPushTagMode defaultMode, boolean followTagsSupported, boolean showSkipHookOption) {
        String checkboxText = "Push Tags";
        if (followTagsSupported) {
            checkboxText = checkboxText + ": ";
        }
        this.myPushTags = new JBCheckBox(checkboxText);
        this.myPushTags.setMnemonic('T');
        this.myPushTags.setSelected(defaultMode != null);
        this.myPushTagsMode = new ComboBox((Object[])GitPushTagMode.getValues());
        this.myPushTagsMode.setRenderer((ListCellRenderer)new ListCellRendererWrapper<GitPushTagMode>(){

            public void customize(JList list, GitPushTagMode value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getTitle());
            }
        });
        this.myPushTagsMode.setEnabled(this.myPushTags.isSelected());
        if (defaultMode != null) {
            this.myPushTagsMode.setSelectedItem((Object)defaultMode);
        }
        this.myPushTags.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/push/GitPushOptionsPanel$2", "actionPerformed"));
                }
                GitPushOptionsPanel.this.myPushTagsMode.setEnabled(GitPushOptionsPanel.this.myPushTags.isSelected());
            }
        });
        this.myPushTagsMode.setVisible(followTagsSupported);
        this.myRunHooks = new JBCheckBox("Run Git hooks");
        this.myRunHooks.setMnemonic(72);
        this.myRunHooks.setSelected(true);
        this.myRunHooks.setVisible(showSkipHookOption);
        this.myRunHooks.setBorder((Border)JBUI.Borders.empty());
        this.myPushTagsMode.setBorder((Border)JBUI.Borders.empty());
        this.myPushTags.setBorder((Border)JBUI.Borders.empty());
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add((Component)this.myPushTags);
        this.add(Box.createHorizontalStrut(JBUI.scale((int)3)));
        this.add((Component)this.myPushTagsMode);
        this.add(Box.createHorizontalStrut(JBUI.scale((int)37)));
        this.add((Component)this.myRunHooks);
    }

    @Nullable
    public VcsPushOptionValue getValue() {
        GitPushTagMode selectedTagMode = !this.myPushTagsMode.isVisible() ? GitPushTagMode.ALL : (GitPushTagMode)this.myPushTagsMode.getSelectedItem();
        GitPushTagMode tagMode = this.myPushTags.isSelected() ? selectedTagMode : null;
        return new GitVcsPushOptionValue(tagMode, this.myRunHooks.isVisible() && !this.myRunHooks.isSelected());
    }
}

