/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.push.GitPushNativeResult;
import git4idea.update.GitUpdateResult;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitPushRepoResult {
    static Comparator<Type> TYPE_COMPARATOR = (o1, o2) -> o1.ordinal() - o2.ordinal();
    @NotNull
    private final Type myType;
    private final int myCommits;
    @NotNull
    private final String mySourceBranch;
    @NotNull
    private final String myTargetBranch;
    @NotNull
    private final String myTargetRemote;
    @NotNull
    private final List<String> myPushedTags;
    @Nullable
    private final String myError;
    @Nullable
    private final GitUpdateResult myUpdateResult;

    @NotNull
    static GitPushRepoResult convertFromNative(@NotNull GitPushNativeResult result, @NotNull List<GitPushNativeResult> tagResults, int commits2, @NotNull GitLocalBranch source, @NotNull GitRemoteBranch target) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "git4idea/push/GitPushRepoResult", "convertFromNative"));
        }
        if (tagResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagResults", "git4idea/push/GitPushRepoResult", "convertFromNative"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "git4idea/push/GitPushRepoResult", "convertFromNative"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "git4idea/push/GitPushRepoResult", "convertFromNative"));
        }
        List tags = ContainerUtil.map(tagResults, result1 -> result1.getSourceRef());
        GitPushRepoResult gitPushRepoResult = new GitPushRepoResult(GitPushRepoResult.convertType(result), commits2, source.getFullName(), target.getFullName(), target.getRemote().getName(), tags, null, null);
        if (gitPushRepoResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "convertFromNative"));
        }
        return gitPushRepoResult;
    }

    @NotNull
    static GitPushRepoResult error(@NotNull GitLocalBranch source, @NotNull GitRemoteBranch target, @NotNull String error) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "git4idea/push/GitPushRepoResult", "error"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "git4idea/push/GitPushRepoResult", "error"));
        }
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "git4idea/push/GitPushRepoResult", "error"));
        }
        GitPushRepoResult gitPushRepoResult = new GitPushRepoResult(Type.ERROR, -1, source.getFullName(), target.getFullName(), target.getRemote().getName(), Collections.emptyList(), error, null);
        if (gitPushRepoResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "error"));
        }
        return gitPushRepoResult;
    }

    @NotNull
    static GitPushRepoResult notPushed(GitLocalBranch source, GitRemoteBranch target) {
        GitPushRepoResult gitPushRepoResult = new GitPushRepoResult(Type.NOT_PUSHED, -1, source.getFullName(), target.getFullName(), target.getRemote().getName(), Collections.emptyList(), null, null);
        if (gitPushRepoResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "notPushed"));
        }
        return gitPushRepoResult;
    }

    @NotNull
    static GitPushRepoResult addUpdateResult(GitPushRepoResult original, GitUpdateResult updateResult) {
        GitPushRepoResult gitPushRepoResult = new GitPushRepoResult(original.getType(), original.getNumberOfPushedCommits(), original.getSourceBranch(), original.getTargetBranch(), original.getTargetRemote(), original.getPushedTags(), original.getError(), updateResult);
        if (gitPushRepoResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "addUpdateResult"));
        }
        return gitPushRepoResult;
    }

    private GitPushRepoResult(@NotNull Type type, int pushedCommits, @NotNull String sourceBranch, @NotNull String targetBranch, @NotNull String targetRemote, @NotNull List<String> pushedTags, @Nullable String error, @Nullable GitUpdateResult result) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "git4idea/push/GitPushRepoResult", "<init>"));
        }
        if (sourceBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceBranch", "git4idea/push/GitPushRepoResult", "<init>"));
        }
        if (targetBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetBranch", "git4idea/push/GitPushRepoResult", "<init>"));
        }
        if (targetRemote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetRemote", "git4idea/push/GitPushRepoResult", "<init>"));
        }
        if (pushedTags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pushedTags", "git4idea/push/GitPushRepoResult", "<init>"));
        }
        this.myType = type;
        this.myCommits = pushedCommits;
        this.mySourceBranch = sourceBranch;
        this.myTargetBranch = targetBranch;
        this.myTargetRemote = targetRemote;
        this.myPushedTags = pushedTags;
        this.myError = error;
        this.myUpdateResult = result;
    }

    @NotNull
    Type getType() {
        Type type = this.myType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "getType"));
        }
        return type;
    }

    @Nullable
    GitUpdateResult getUpdateResult() {
        return this.myUpdateResult;
    }

    int getNumberOfPushedCommits() {
        return this.myCommits;
    }

    @NotNull
    String getSourceBranch() {
        String string = this.mySourceBranch;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "getSourceBranch"));
        }
        return string;
    }

    @NotNull
    String getTargetBranch() {
        String string = this.myTargetBranch;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "getTargetBranch"));
        }
        return string;
    }

    @Nullable
    String getError() {
        return this.myError;
    }

    @NotNull
    List<String> getPushedTags() {
        List<String> list = this.myPushedTags;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "getPushedTags"));
        }
        return list;
    }

    @NotNull
    public String getTargetRemote() {
        String string = this.myTargetRemote;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "getTargetRemote"));
        }
        return string;
    }

    @NotNull
    private static Type convertType(@NotNull GitPushNativeResult nativeResult) {
        if (nativeResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeResult", "git4idea/push/GitPushRepoResult", "convertType"));
        }
        switch (nativeResult.getType()) {
            case SUCCESS: {
                Type type = Type.SUCCESS;
                if (type == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "convertType"));
                }
                return type;
            }
            case FORCED_UPDATE: {
                Type type = Type.FORCED;
                if (type == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "convertType"));
                }
                return type;
            }
            case NEW_REF: {
                Type type = Type.NEW_BRANCH;
                if (type == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "convertType"));
                }
                return type;
            }
            case REJECTED: {
                Type type = nativeResult.isNonFFUpdate() ? Type.REJECTED_NO_FF : Type.REJECTED_OTHER;
                if (type == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "convertType"));
                }
                return type;
            }
            case UP_TO_DATE: {
                Type type = Type.UP_TO_DATE;
                if (type == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "convertType"));
                }
                return type;
            }
            case ERROR: {
                Type type = Type.ERROR;
                if (type == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "convertType"));
                }
                return type;
            }
        }
        throw new IllegalArgumentException("Conversion is not supported: " + (Object)((Object)nativeResult.getType()));
    }

    public String toString() {
        return String.format("%s (%d, '%s'), update: %s}", new Object[]{this.myType, this.myCommits, this.mySourceBranch, this.myUpdateResult});
    }

    static enum Type {
        SUCCESS,
        NEW_BRANCH,
        UP_TO_DATE,
        FORCED,
        REJECTED_NO_FF,
        REJECTED_OTHER,
        ERROR,
        NOT_PUSHED;

    }
}

