/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.DialogManager;
import git4idea.config.GitConfigUtil;
import git4idea.rebase.GitInteractiveRebaseFile;
import git4idea.rebase.GitRebaseEditor;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseEditorService;
import git4idea.rebase.GitRebaseEntry;
import git4idea.rebase.GitRebaseUnstructuredEditor;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitInteractiveRebaseEditorHandler
implements Closeable,
GitRebaseEditorHandler {
    private static final Logger LOG = Logger.getInstance(GitInteractiveRebaseEditorHandler.class);
    private final GitRebaseEditorService myService;
    private final Project myProject;
    private final VirtualFile myRoot;
    @NotNull
    private final UUID myHandlerNo;
    private boolean myIsClosed;
    protected boolean myRebaseEditorShown;
    private boolean myEditorCancelled;

    public GitInteractiveRebaseEditorHandler(@NotNull GitRebaseEditorService service, @NotNull Project project, @NotNull VirtualFile root) {
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "git4idea/rebase/GitInteractiveRebaseEditorHandler", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitInteractiveRebaseEditorHandler", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/rebase/GitInteractiveRebaseEditorHandler", "<init>"));
        }
        this.myRebaseEditorShown = false;
        this.myService = service;
        this.myProject = project;
        this.myRoot = root;
        this.myHandlerNo = service.registerHandler(this, (Disposable)project);
    }

    @Override
    public int editCommits(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/rebase/GitInteractiveRebaseEditorHandler", "editCommits"));
        }
        this.ensureOpen();
        try {
            if (this.myRebaseEditorShown) {
                this.myEditorCancelled = !this.handleUnstructuredEditor(path);
                return 0;
            }
            this.setRebaseEditorShown();
            boolean success = this.handleInteractiveEditor(path);
            if (success) {
                return 0;
            }
            this.myEditorCancelled = true;
            return 2;
        }
        catch (Exception e) {
            LOG.error("Failed to edit git rebase file: " + path, (Throwable)e);
            return 2;
        }
    }

    private boolean handleUnstructuredEditor(@NotNull String path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/rebase/GitInteractiveRebaseEditorHandler", "handleUnstructuredEditor"));
        }
        File file = new File(path);
        String encoding = GitConfigUtil.getCommitEncoding(this.myProject, this.myRoot);
        String initialText = FileUtil.loadFile((File)file, (String)encoding);
        String newText = this.showUnstructuredEditor(initialText);
        if (newText == null) {
            return false;
        }
        FileUtil.writeToFile((File)file, (byte[])newText.getBytes(encoding));
        return true;
    }

    @Nullable
    private String showUnstructuredEditor(@NotNull String initialText) {
        if (initialText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialText", "git4idea/rebase/GitInteractiveRebaseEditorHandler", "showUnstructuredEditor"));
        }
        Ref newText = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (initialText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialText", "git4idea/rebase/GitInteractiveRebaseEditorHandler", "lambda$showUnstructuredEditor$0"));
            }
            GitRebaseUnstructuredEditor editor = new GitRebaseUnstructuredEditor(this.myProject, this.myRoot, initialText);
            DialogManager.show(editor);
            if (editor.isOK()) {
                newText.set((Object)editor.getText());
            }
        });
        return (String)newText.get();
    }

    private boolean handleInteractiveEditor(@NotNull String path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/rebase/GitInteractiveRebaseEditorHandler", "handleInteractiveEditor"));
        }
        GitInteractiveRebaseFile rebaseFile = new GitInteractiveRebaseFile(this.myProject, this.myRoot, path);
        try {
            List<GitRebaseEntry> entries = rebaseFile.load();
            List<GitRebaseEntry> newEntries = this.showInteractiveRebaseEditor(entries);
            if (newEntries != null) {
                rebaseFile.save(newEntries);
                return true;
            }
            rebaseFile.cancel();
            return false;
        }
        catch (GitInteractiveRebaseFile.NoopException e) {
            return this.confirmNoopRebase();
        }
    }

    @Nullable
    private List<GitRebaseEntry> showInteractiveRebaseEditor(@NotNull List<GitRebaseEntry> entries) {
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "git4idea/rebase/GitInteractiveRebaseEditorHandler", "showInteractiveRebaseEditor"));
        }
        Ref newText = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (entries == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "git4idea/rebase/GitInteractiveRebaseEditorHandler", "lambda$showInteractiveRebaseEditor$1"));
            }
            GitRebaseEditor editor = new GitRebaseEditor(this.myProject, this.myRoot, entries);
            DialogManager.show(editor);
            if (editor.isOK()) {
                newText.set(editor.getEntries());
            }
        });
        return (List)newText.get();
    }

    private boolean confirmNoopRebase() {
        LOG.info("Noop situation while rebasing " + this.myRoot);
        String message = "There are no commits to rebase because the current branch is directly below the base branch, or they point to the same commit (the 'noop' situation).\nDo you want to continue (this will reset the current branch to the base branch)?";
        Ref result = Ref.create((Object)false);
        ApplicationManager.getApplication().invokeAndWait(() -> result.set((Object)(0 == DialogManager.showOkCancelDialog(this.myProject, message, "Git Rebase", CommonBundle.getOkButtonText(), CommonBundle.getCancelButtonText(), Messages.getQuestionIcon()) ? 1 : 0)));
        return (Boolean)result.get();
    }

    public void setRebaseEditorShown() {
        this.myRebaseEditorShown = true;
    }

    private void ensureOpen() {
        if (this.myIsClosed) {
            throw new IllegalStateException("The handler was already closed");
        }
    }

    @Override
    public void close() {
        this.ensureOpen();
        this.myIsClosed = true;
        this.myService.unregisterHandler(this.myHandlerNo);
    }

    @Override
    @NotNull
    public UUID getHandlerNo() {
        UUID uUID = this.myHandlerNo;
        if (uUID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitInteractiveRebaseEditorHandler", "getHandlerNo"));
        }
        return uUID;
    }

    @Override
    public boolean wasEditorCancelled() {
        return this.myEditorCancelled;
    }
}

