/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ui.FilePathChangesTreeList;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class GitSimplePathsBrowser
extends JPanel {
    public GitSimplePathsBrowser(@NotNull Project project, @NotNull Collection<String> absolutePaths) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/util/GitSimplePathsBrowser", "<init>"));
        }
        if (absolutePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "absolutePaths", "git4idea/util/GitSimplePathsBrowser", "<init>"));
        }
        super(new BorderLayout());
        FilePathChangesTreeList browser = GitSimplePathsBrowser.createBrowser(project, absolutePaths);
        ActionToolbar toolbar = GitSimplePathsBrowser.createToolbar(browser);
        this.add((Component)toolbar.getComponent(), "North");
        this.add(ScrollPaneFactory.createScrollPane((Component)browser));
    }

    @NotNull
    private static FilePathChangesTreeList createBrowser(@NotNull Project project, @NotNull Collection<String> absolutePaths) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/util/GitSimplePathsBrowser", "createBrowser"));
        }
        if (absolutePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "absolutePaths", "git4idea/util/GitSimplePathsBrowser", "createBrowser"));
        }
        List<FilePath> filePaths = GitSimplePathsBrowser.toFilePaths(absolutePaths);
        FilePathChangesTreeList browser = new FilePathChangesTreeList(project, filePaths, false, false, null, null);
        browser.setChangesToDisplay(filePaths);
        FilePathChangesTreeList filePathChangesTreeList = browser;
        if (filePathChangesTreeList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/util/GitSimplePathsBrowser", "createBrowser"));
        }
        return filePathChangesTreeList;
    }

    @NotNull
    private static ActionToolbar createToolbar(@NotNull FilePathChangesTreeList browser) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "git4idea/util/GitSimplePathsBrowser", "createToolbar"));
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup(browser.getTreeActions());
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("GitPathBrowser", (ActionGroup)actionGroup, true);
        if (actionToolbar == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/util/GitSimplePathsBrowser", "createToolbar"));
        }
        return actionToolbar;
    }

    @NotNull
    private static List<FilePath> toFilePaths(@NotNull Collection<String> absolutePaths) {
        if (absolutePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "absolutePaths", "git4idea/util/GitSimplePathsBrowser", "toFilePaths"));
        }
        List list = ContainerUtil.map(absolutePaths, path -> VcsUtil.getFilePath((String)path, (boolean)false));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/util/GitSimplePathsBrowser", "toFilePaths"));
        }
        return list;
    }
}

