/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.codegen.AccessorForCallableDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForConstructorDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForPropertyBackingFieldFromLocal;
import org.jetbrains.kotlin.codegen.AccessorForPropertyDescriptor;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.ClosureCodegen;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.ExceptionLogger;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.InnerClassConsumer;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.PropertyCodegen;
import org.jetbrains.kotlin.codegen.PropertyReferenceCodegen;
import org.jetbrains.kotlin.codegen.SourceInfo;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.WriteAnnotationUtilKt;
import org.jetbrains.kotlin.codegen.annotation.AnnotatedSimple;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.CodegenContextUtil;
import org.jetbrains.kotlin.codegen.context.DelegatingToPartContext;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.InlineLambdaContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.MultifileClassFacadeContext;
import org.jetbrains.kotlin.codegen.inline.DefaultSourceMapper;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.inline.NameGenerator;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeParametersUsages;
import org.jetbrains.kotlin.codegen.inline.SourceMapper;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializerExtension;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.fileClasses.FileClasses;
import org.jetbrains.kotlin.fileClasses.JvmFileClassesProvider;
import org.jetbrains.kotlin.load.java.JavaVisibilities;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.synthetics.SyntheticClassOrObjectDescriptor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public abstract class MemberCodegen<T extends KtPureElement>
implements InnerClassConsumer {
    public final GenerationState state;
    protected final T element;
    protected final FieldOwnerContext context;
    public final ClassBuilder v;
    public final FunctionCodegen functionCodegen;
    public final PropertyCodegen propertyCodegen;
    public final KotlinTypeMapper typeMapper;
    public final BindingContext bindingContext;
    private final JvmFileClassesProvider fileClassesProvider;
    private final MemberCodegen<?> parentCodegen;
    private final ReifiedTypeParametersUsages reifiedTypeParametersUsages;
    private final Collection<ClassDescriptor> innerClasses;
    private ExpressionCodegen clInit;
    private NameGenerator inlineNameGenerator;
    private DefaultSourceMapper sourceMapper;

    public MemberCodegen(@NotNull GenerationState state, @Nullable MemberCodegen<?> parentCodegen, @NotNull FieldOwnerContext context, T element2, @NotNull ClassBuilder builder) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/MemberCodegen", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/MemberCodegen", "<init>"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/codegen/MemberCodegen", "<init>"));
        }
        this.reifiedTypeParametersUsages = new ReifiedTypeParametersUsages();
        this.innerClasses = new LinkedHashSet<ClassDescriptor>();
        this.state = state;
        this.typeMapper = state.getTypeMapper();
        this.bindingContext = state.getBindingContext();
        this.fileClassesProvider = state.getFileClassesProvider();
        this.element = element2;
        this.context = context;
        this.v = builder;
        this.functionCodegen = new FunctionCodegen(context, this.v, state, this);
        this.propertyCodegen = new PropertyCodegen(context, this.v, this.functionCodegen, this);
        this.parentCodegen = parentCodegen;
    }

    protected MemberCodegen(@NotNull MemberCodegen<T> wrapped, T declaration2, FieldOwnerContext codegenContext) {
        if (wrapped == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapped", "org/jetbrains/kotlin/codegen/MemberCodegen", "<init>"));
        }
        this(wrapped.state, wrapped.getParentCodegen(), codegenContext, declaration2, wrapped.v);
    }

    public void generate() {
        this.generateDeclaration();
        this.generateBody();
        if (!(this.element instanceof KtClassOrObject) || this.state.getGenerateDeclaredClassFilter().shouldGenerateClassMembers((KtClassOrObject)this.element)) {
            this.generateSyntheticParts();
        }
        if (this.state.getClassBuilderMode().generateMetadata) {
            this.generateKotlinMetadataAnnotation();
        }
        this.done();
    }

    protected abstract void generateDeclaration();

    protected abstract void generateBody();

    protected void generateSyntheticParts() {
    }

    protected abstract void generateKotlinMetadataAnnotation();

    @Nullable
    protected ClassDescriptor classForInnerClassRecord() {
        return null;
    }

    public static void markLineNumberForDescriptor(@Nullable ClassDescriptor declarationDescriptor, @NotNull InstructionAdapter v) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/MemberCodegen", "markLineNumberForDescriptor"));
        }
        if (declarationDescriptor == null) {
            return;
        }
        PsiElement classElement = DescriptorToSourceUtils.getSourceFromDescriptor(declarationDescriptor);
        if (classElement != null) {
            MemberCodegen.markLineNumberForElement(classElement, v);
        }
    }

    public static void markLineNumberForElement(@NotNull PsiElement element2, @NotNull InstructionAdapter v) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/codegen/MemberCodegen", "markLineNumberForElement"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/MemberCodegen", "markLineNumberForElement"));
        }
        Integer lineNumber = CodegenUtil.getLineNumberForElement(element2, false);
        if (lineNumber != null) {
            Label label2 = new Label();
            v.visitLabel(label2);
            v.visitLineNumber(lineNumber.intValue(), label2);
        }
    }

    protected void done() {
        if (this.clInit != null) {
            this.clInit.v.visitInsn(177);
            FunctionCodegen.endVisit((MethodVisitor)this.clInit.v, "static initializer", this.element);
        }
        this.writeInnerClasses();
        if (this.sourceMapper != null) {
            SourceMapper.Companion.flushToClassBuilder(this.sourceMapper, this.v);
        }
        this.v.done();
    }

    public void genSimpleMember(@NotNull KtDeclaration declaration2) {
        if (declaration2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/codegen/MemberCodegen", "genSimpleMember"));
        }
        if (declaration2 instanceof KtNamedFunction) {
            try {
                this.functionCodegen.gen((KtNamedFunction)declaration2);
            }
            catch (ProcessCanceledException | CompilationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompilationException("Failed to generate function " + declaration2.getName(), e, declaration2);
            }
        } else if (declaration2 instanceof KtProperty) {
            try {
                this.propertyCodegen.gen((KtProperty)declaration2);
            }
            catch (ProcessCanceledException | CompilationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompilationException("Failed to generate property " + declaration2.getName(), e, declaration2);
            }
        } else if (declaration2 instanceof KtTypeAlias) {
            this.genTypeAlias((KtTypeAlias)declaration2);
        } else {
            throw new IllegalArgumentException("Unknown parameter: " + declaration2);
        }
    }

    private void genTypeAlias(@NotNull KtTypeAlias typeAlias2) {
        if (typeAlias2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeAlias", "org/jetbrains/kotlin/codegen/MemberCodegen", "genTypeAlias"));
        }
        if (!this.state.getClassBuilderMode().generateMetadata) {
            return;
        }
        TypeAliasDescriptor typeAliasDescriptor = this.bindingContext.get(BindingContext.TYPE_ALIAS, typeAlias2);
        if (typeAliasDescriptor == null) {
            throw ExceptionLogger.logDescriptorNotFound("Type alias " + typeAlias2.getName() + " should have a descriptor", typeAlias2);
        }
        this.genTypeAliasAnnotationsMethodIfRequired(typeAliasDescriptor);
    }

    private void genTypeAliasAnnotationsMethodIfRequired(TypeAliasDescriptor typeAliasDescriptor) {
        boolean isAnnotationsMethodOwner = CodegenContextUtil.isImplClassOwner(this.context);
        Annotations annotations2 = typeAliasDescriptor.getAnnotations();
        if (!isAnnotationsMethodOwner || annotations2.getAllAnnotations().isEmpty()) {
            return;
        }
        String name2 = JvmAbi.getSyntheticMethodNameForAnnotatedTypeAlias(typeAliasDescriptor.getName());
        this.generateSyntheticAnnotationsMethod(typeAliasDescriptor, new Method(name2, "()V"), annotations2, null);
    }

    protected void generateSyntheticAnnotationsMethod(@NotNull MemberDescriptor descriptor2, @NotNull Method syntheticMethod, @NotNull Annotations annotations2, @Nullable AnnotationUseSiteTarget allowedTarget) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateSyntheticAnnotationsMethod"));
        }
        if (syntheticMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syntheticMethod", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateSyntheticAnnotationsMethod"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateSyntheticAnnotationsMethod"));
        }
        int flags = 0x21008 | AsmUtil.getVisibilityAccessFlag(descriptor2);
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin(descriptor2), flags, syntheticMethod.getName(), syntheticMethod.getDescriptor(), null, null);
        AnnotationCodegen.forMethod(mv, this, this.typeMapper).genAnnotations(new AnnotatedSimple(annotations2), Type.VOID_TYPE, allowedTarget);
        mv.visitCode();
        mv.visitInsn(177);
        mv.visitEnd();
    }

    public static void genClassOrObject(@NotNull CodegenContext parentContext, @NotNull KtClassOrObject aClass2, @NotNull GenerationState state, @Nullable MemberCodegen<?> parentCodegen) {
        if (parentContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentContext", "org/jetbrains/kotlin/codegen/MemberCodegen", "genClassOrObject"));
        }
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/codegen/MemberCodegen", "genClassOrObject"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/MemberCodegen", "genClassOrObject"));
        }
        ClassDescriptor descriptor2 = state.getBindingContext().get(BindingContext.CLASS, aClass2);
        if (descriptor2 == null || ErrorUtils.isError(descriptor2)) {
            MemberCodegen.badDescriptor(descriptor2, state.getClassBuilderMode());
            return;
        }
        if (descriptor2.getName().equals(SpecialNames.NO_NAME_PROVIDED)) {
            MemberCodegen.badDescriptor(descriptor2, state.getClassBuilderMode());
        }
        MemberCodegen.genClassOrObject(parentContext, aClass2, state, parentCodegen, descriptor2);
    }

    private static void genClassOrObject(@NotNull CodegenContext parentContext, @NotNull KtPureClassOrObject aClass2, @NotNull GenerationState state, @Nullable MemberCodegen<?> parentCodegen, @NotNull ClassDescriptor descriptor2) {
        if (parentContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentContext", "org/jetbrains/kotlin/codegen/MemberCodegen", "genClassOrObject"));
        }
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/codegen/MemberCodegen", "genClassOrObject"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/MemberCodegen", "genClassOrObject"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/MemberCodegen", "genClassOrObject"));
        }
        Type classType = state.getTypeMapper().mapClass(descriptor2);
        ClassBuilder classBuilder2 = state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(aClass2, (DeclarationDescriptor)descriptor2), classType, (PsiFile)aClass2.getContainingKtFile());
        ClassContext classContext = parentContext.intoClass(descriptor2, OwnerKind.IMPLEMENTATION, state);
        new ImplementationBodyCodegen(aClass2, classContext, classBuilder2, state, parentCodegen, false).generate();
    }

    public static void badDescriptor(ClassDescriptor descriptor2, ClassBuilderMode mode) {
        if (mode.generateBodies) {
            throw new IllegalStateException("Generating bad descriptor in ClassBuilderMode = " + mode + ": " + descriptor2);
        }
    }

    public void genClassOrObject(KtClassOrObject aClass2) {
        MemberCodegen.genClassOrObject(this.context, aClass2, this.state, this);
    }

    public void genSyntheticClassOrObject(SyntheticClassOrObjectDescriptor descriptor2) {
        MemberCodegen.genClassOrObject(this.context, descriptor2.getSyntheticDeclaration(), this.state, this, descriptor2);
    }

    private void writeInnerClasses() {
        ClassDescriptor classDescriptor = this.classForInnerClassRecord();
        if (classDescriptor != null) {
            if (this.parentCodegen != null) {
                this.parentCodegen.innerClasses.add(classDescriptor);
            }
            for (MemberCodegen<?> codegen = this; codegen != null; codegen = codegen.getParentCodegen()) {
                ClassDescriptor outerClass = codegen.classForInnerClassRecord();
                if (outerClass == null) continue;
                this.innerClasses.add(outerClass);
            }
        }
        for (ClassDescriptor innerClass : this.innerClasses) {
            this.writeInnerClass(innerClass);
        }
    }

    @Override
    public void addInnerClassInfoFromAnnotation(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/MemberCodegen", "addInnerClassInfoFromAnnotation"));
        }
        for (DeclarationDescriptor current = classDescriptor; current != null && !DescriptorUtils.isTopLevelDeclaration(current); current = current.getContainingDeclaration()) {
            if (!(current instanceof ClassDescriptor)) continue;
            this.innerClasses.add((ClassDescriptor)current);
        }
    }

    private void writeInnerClass(@NotNull ClassDescriptor innerClass) {
        if (innerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClass", "org/jetbrains/kotlin/codegen/MemberCodegen", "writeInnerClass"));
        }
        if (!ErrorUtils.isError(innerClass)) {
            MemberCodegen.writeInnerClass(innerClass, this.typeMapper, this.v);
        }
    }

    public static void writeInnerClass(@NotNull ClassDescriptor innerClass, @NotNull KotlinTypeMapper typeMapper, @NotNull ClassBuilder v) {
        if (innerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClass", "org/jetbrains/kotlin/codegen/MemberCodegen", "writeInnerClass"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/MemberCodegen", "writeInnerClass"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/MemberCodegen", "writeInnerClass"));
        }
        DeclarationDescriptor containing = innerClass.getContainingDeclaration();
        String outerClassInternalName = null;
        if (containing instanceof ClassDescriptor) {
            outerClassInternalName = typeMapper.classInternalName((ClassDescriptor)containing);
        }
        String innerName = innerClass.getName().isSpecial() ? null : innerClass.getName().asString();
        String innerClassInternalName = typeMapper.classInternalName(innerClass);
        v.visitInnerClass(innerClassInternalName, outerClassInternalName, innerName, AsmUtil.calculateInnerClassAccessFlags(innerClass));
    }

    protected void writeOuterClassAndEnclosingMethod() {
        CodegenContext context = this.context.getParentContext();
        while (context instanceof InlineLambdaContext) {
            context = context.getParentContext().getParentContext();
        }
        assert (context != null) : "Outermost context can't be null: " + this.context;
        Type enclosingAsmType = this.computeOuterClass(context);
        if (enclosingAsmType != null) {
            Method method = this.computeEnclosingMethod(context);
            this.v.visitOuterClass(enclosingAsmType.getInternalName(), method == null ? null : method.getName(), method == null ? null : method.getDescriptor());
        }
    }

    @Nullable
    private Type computeOuterClass(@NotNull CodegenContext<?> context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/MemberCodegen", "computeOuterClass"));
        }
        CodegenContext<ClassOrPackageFragmentDescriptor> outermost = context.getClassOrPackageParentContext();
        if (outermost instanceof ClassContext) {
            FunctionDescriptor functionDescriptor2;
            ClassDescriptor classDescriptor = (ClassDescriptor)((ClassContext)outermost).getContextDescriptor();
            if (context instanceof MethodContext && DescriptorUtils.isInterface((functionDescriptor2 = ((MethodContext)context).getFunctionDescriptor()).getContainingDeclaration()) && !JvmCodegenUtil.isJvm8InterfaceWithDefaultsMember(functionDescriptor2, this.state)) {
                return this.typeMapper.mapDefaultImpls(classDescriptor);
            }
            return this.typeMapper.mapType(classDescriptor);
        }
        if (outermost instanceof MultifileClassFacadeContext || outermost instanceof DelegatingToPartContext) {
            Type implementationOwnerType = CodegenContextUtil.getImplementationOwnerClassType(outermost);
            if (implementationOwnerType != null) {
                return implementationOwnerType;
            }
            return FileClasses.getFileClassType(this.fileClassesProvider, this.element.getContainingKtFile());
        }
        return null;
    }

    @Nullable
    private Method computeEnclosingMethod(@NotNull CodegenContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/MemberCodegen", "computeEnclosingMethod"));
        }
        if (context instanceof MethodContext) {
            FunctionDescriptor functionDescriptor2 = ((MethodContext)context).getFunctionDescriptor();
            if ("<clinit>".equals(functionDescriptor2.getName().asString())) {
                return null;
            }
            if (((MethodContext)context).isDefaultFunctionContext()) {
                return this.typeMapper.mapDefaultMethod(functionDescriptor2, context.getContextKind());
            }
            return this.typeMapper.mapAsmMethod(functionDescriptor2, context.getContextKind());
        }
        return null;
    }

    @NotNull
    public NameGenerator getInlineNameGenerator() {
        if (this.inlineNameGenerator == null) {
            String prefix = InlineCodegenUtil.getInlineName(this.context, this.typeMapper, this.fileClassesProvider);
            this.inlineNameGenerator = new NameGenerator(prefix);
        }
        NameGenerator nameGenerator2 = this.inlineNameGenerator;
        if (nameGenerator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/MemberCodegen", "getInlineNameGenerator"));
        }
        return nameGenerator2;
    }

    @NotNull
    public final ExpressionCodegen createOrGetClInitCodegen() {
        if (this.clInit == null) {
            Object contextDescriptor = this.context.getContextDescriptor();
            SimpleFunctionDescriptorImpl clInitDescriptor = this.createClInitFunctionDescriptor((DeclarationDescriptor)contextDescriptor);
            MethodVisitor mv = this.createClInitMethodVisitor((DeclarationDescriptor)contextDescriptor);
            this.clInit = new ExpressionCodegen(mv, new FrameMap(), Type.VOID_TYPE, this.context.intoFunction(clInitDescriptor), this.state, this);
        }
        ExpressionCodegen expressionCodegen = this.clInit;
        if (expressionCodegen == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/MemberCodegen", "createOrGetClInitCodegen"));
        }
        return expressionCodegen;
    }

    @NotNull
    public MethodVisitor createClInitMethodVisitor(@NotNull DeclarationDescriptor contextDescriptor) {
        if (contextDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextDescriptor", "org/jetbrains/kotlin/codegen/MemberCodegen", "createClInitMethodVisitor"));
        }
        MethodVisitor methodVisitor = this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin(contextDescriptor), 8, "<clinit>", "()V", null, null);
        if (methodVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/MemberCodegen", "createClInitMethodVisitor"));
        }
        return methodVisitor;
    }

    @NotNull
    private SimpleFunctionDescriptorImpl createClInitFunctionDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/MemberCodegen", "createClInitFunctionDescriptor"));
        }
        SimpleFunctionDescriptorImpl clInit = SimpleFunctionDescriptorImpl.create(descriptor2, Annotations.Companion.getEMPTY(), Name.special("<clinit>"), CallableMemberDescriptor.Kind.SYNTHESIZED, KotlinSourceElementKt.toSourceElement(this.element));
        clInit.initialize((KotlinType)null, (ReceiverParameterDescriptor)null, Collections.emptyList(), Collections.emptyList(), (KotlinType)DescriptorUtilsKt.getModule(descriptor2).getBuiltIns().getUnitType(), (Modality)null, Visibilities.PRIVATE);
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = clInit;
        if (simpleFunctionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/MemberCodegen", "createClInitFunctionDescriptor"));
        }
        return simpleFunctionDescriptorImpl;
    }

    protected void generateInitializers(@NotNull Function0<ExpressionCodegen> createCodegen) {
        if (createCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "createCodegen", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateInitializers"));
        }
        NotNullLazyValue<ExpressionCodegen> codegen = LockBasedStorageManager.NO_LOCKS.createLazyValue(createCodegen);
        for (KtDeclaration declaration2 : ((KtDeclarationContainer)this.element).getDeclarations()) {
            KtExpression body2;
            if (declaration2 instanceof KtProperty) {
                if (!this.shouldInitializeProperty((KtProperty)declaration2)) continue;
                this.initializeProperty((ExpressionCodegen)codegen.invoke(), (KtProperty)declaration2);
                continue;
            }
            if (!(declaration2 instanceof KtAnonymousInitializer) || (body2 = ((KtAnonymousInitializer)declaration2).getBody()) == null) continue;
            ((ExpressionCodegen)codegen.invoke()).gen(body2, Type.VOID_TYPE);
        }
    }

    public void beforeMethodBody(@NotNull MethodVisitor mv) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/MemberCodegen", "beforeMethodBody"));
        }
    }

    private void initializeProperty(@NotNull ExpressionCodegen codegen, @NotNull KtProperty property2) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/MemberCodegen", "initializeProperty"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/codegen/MemberCodegen", "initializeProperty"));
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.bindingContext.get(BindingContext.VARIABLE, property2);
        assert (propertyDescriptor != null);
        KtExpression initializer2 = property2.getDelegateExpressionOrInitializer();
        assert (initializer2 != null) : "shouldInitializeProperty must return false if initializer is null";
        StackValue.Property propValue = codegen.intermediateValueForProperty(propertyDescriptor, true, false, null, true, StackValue.LOCAL_0, null);
        ResolvedCall<FunctionDescriptor> provideDelegateResolvedCall = this.bindingContext.get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, propertyDescriptor);
        if (provideDelegateResolvedCall == null) {
            propValue.store(codegen.gen(initializer2), codegen.v);
            return;
        }
        StackValue provideDelegateReceiver = codegen.gen(initializer2);
        int indexOfDelegatedProperty = PropertyCodegen.indexOfDelegatedProperty(property2);
        StackValue delegateValue = PropertyCodegen.invokeDelegatedPropertyConventionMethodWithReceiver(codegen, this.typeMapper, provideDelegateResolvedCall, indexOfDelegatedProperty, 1, provideDelegateReceiver, propertyDescriptor);
        propValue.store(delegateValue, codegen.v);
    }

    protected boolean shouldInitializeProperty(@NotNull KtProperty property2) {
        ConstantValue<?> initializerValue;
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/codegen/MemberCodegen", "shouldInitializeProperty"));
        }
        if (!property2.hasDelegateExpressionOrInitializer()) {
            return false;
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.bindingContext.get(BindingContext.VARIABLE, property2);
        assert (propertyDescriptor != null);
        if (propertyDescriptor.isConst()) {
            return false;
        }
        KtExpression initializer2 = property2.getInitializer();
        ConstantValue<?> constantValue = initializerValue = initializer2 != null ? ExpressionCodegen.getCompileTimeConstant(initializer2, this.bindingContext, this.state.getShouldInlineConstVals()) : null;
        if (initializerValue == null) {
            return this.state.getClassBuilderMode().generateBodies;
        }
        KotlinType jetType = this.getPropertyOrDelegateType(property2, propertyDescriptor);
        Type type2 = this.typeMapper.mapType(jetType);
        return !MemberCodegen.skipDefaultValue(propertyDescriptor, initializerValue.getValue(), type2);
    }

    @NotNull
    private KotlinType getPropertyOrDelegateType(@NotNull KtProperty property2, @NotNull PropertyDescriptor descriptor2) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/codegen/MemberCodegen", "getPropertyOrDelegateType"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/MemberCodegen", "getPropertyOrDelegateType"));
        }
        KtExpression delegateExpression = property2.getDelegateExpression();
        if (delegateExpression != null) {
            KotlinType delegateType = this.bindingContext.getType(delegateExpression);
            assert (delegateType != null) : "Type of delegate expression should be recorded";
            KotlinType kotlinType = delegateType;
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/MemberCodegen", "getPropertyOrDelegateType"));
            }
            return kotlinType;
        }
        KotlinType kotlinType = descriptor2.getType();
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/MemberCodegen", "getPropertyOrDelegateType"));
        }
        return kotlinType;
    }

    private static boolean skipDefaultValue(@NotNull PropertyDescriptor propertyDescriptor, Object value2, @NotNull Type type2) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/MemberCodegen", "skipDefaultValue"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/MemberCodegen", "skipDefaultValue"));
        }
        if (AsmUtil.isPrimitive(type2)) {
            if (!propertyDescriptor.getType().isMarkedNullable() && value2 instanceof Number) {
                if (type2 == Type.INT_TYPE && ((Number)value2).intValue() == 0) {
                    return true;
                }
                if (type2 == Type.BYTE_TYPE && ((Number)value2).byteValue() == 0) {
                    return true;
                }
                if (type2 == Type.LONG_TYPE && ((Number)value2).longValue() == 0L) {
                    return true;
                }
                if (type2 == Type.SHORT_TYPE && ((Number)value2).shortValue() == 0) {
                    return true;
                }
                if (type2 == Type.DOUBLE_TYPE && ((Number)value2).doubleValue() == 0.0) {
                    return true;
                }
                if (type2 == Type.FLOAT_TYPE && ((Number)value2).floatValue() == 0.0f) {
                    return true;
                }
            }
            if (type2 == Type.BOOLEAN_TYPE && value2 instanceof Boolean && !((Boolean)value2).booleanValue()) {
                return true;
            }
            if (type2 == Type.CHAR_TYPE && value2 instanceof Character && ((Character)value2).charValue() == '\u0000') {
                return true;
            }
        } else if (value2 == null) {
            return true;
        }
        return false;
    }

    protected void generatePropertyMetadataArrayFieldIfNeeded(@NotNull Type thisAsmType) {
        if (thisAsmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisAsmType", "org/jetbrains/kotlin/codegen/MemberCodegen", "generatePropertyMetadataArrayFieldIfNeeded"));
        }
        ArrayList<KtProperty> delegatedProperties = new ArrayList<KtProperty>();
        for (KtDeclaration declaration2 : ((KtDeclarationContainer)this.element).getDeclarations()) {
            KtProperty property2;
            if (!(declaration2 instanceof KtProperty) || !(property2 = (KtProperty)declaration2).hasDelegate()) continue;
            delegatedProperties.add(property2);
        }
        if (delegatedProperties.isEmpty()) {
            return;
        }
        this.v.newField(JvmDeclarationOrigin.NO_ORIGIN, 4120, "$$delegatedProperties", "[" + AsmTypes.K_PROPERTY_TYPE, null, null);
        if (!this.state.getClassBuilderMode().generateBodies) {
            return;
        }
        InstructionAdapter iv = this.createOrGetClInitCodegen().v;
        iv.iconst(delegatedProperties.size());
        iv.newarray(AsmTypes.K_PROPERTY_TYPE);
        int size = delegatedProperties.size();
        for (int i = 0; i < size; ++i) {
            PropertyDescriptor property3 = (PropertyDescriptor)BindingContextUtils.getNotNull(this.bindingContext, BindingContext.VARIABLE, delegatedProperties.get(i));
            iv.dup();
            iv.iconst(i);
            int receiverCount = (property3.getDispatchReceiverParameter() != null ? 1 : 0) + (property3.getExtensionReceiverParameter() != null ? 1 : 0);
            Type implType = property3.isVar() ? AsmTypes.MUTABLE_PROPERTY_REFERENCE_IMPL[receiverCount] : AsmTypes.PROPERTY_REFERENCE_IMPL[receiverCount];
            iv.anew(implType);
            iv.dup();
            ClosureCodegen.generateCallableReferenceDeclarationContainer(iv, property3, this.state);
            iv.aconst((Object)property3.getName().asString());
            PropertyReferenceCodegen.generateCallableReferenceSignature(iv, property3, this.state);
            iv.invokespecial(implType.getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{AsmTypes.K_DECLARATION_CONTAINER_TYPE, AsmTypes.JAVA_STRING_TYPE, AsmTypes.JAVA_STRING_TYPE}), false);
            Method wrapper = PropertyReferenceCodegen.getWrapperMethodForPropertyReference(property3, receiverCount);
            iv.invokestatic("kotlin/jvm/internal/Reflection", wrapper.getName(), wrapper.getDescriptor(), false);
            StackValue.onStack(implType).put(AsmTypes.K_PROPERTY_TYPE, iv);
            iv.astore(AsmTypes.K_PROPERTY_TYPE);
        }
        iv.putstatic(thisAsmType.getInternalName(), "$$delegatedProperties", "[" + AsmTypes.K_PROPERTY_TYPE);
    }

    public String getClassName() {
        return this.v.getThisName();
    }

    @NotNull
    public FieldOwnerContext<?> getContext() {
        FieldOwnerContext fieldOwnerContext = this.context;
        if (fieldOwnerContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/MemberCodegen", "getContext"));
        }
        return fieldOwnerContext;
    }

    @NotNull
    public ReifiedTypeParametersUsages getReifiedTypeParametersUsages() {
        ReifiedTypeParametersUsages reifiedTypeParametersUsages = this.reifiedTypeParametersUsages;
        if (reifiedTypeParametersUsages == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/MemberCodegen", "getReifiedTypeParametersUsages"));
        }
        return reifiedTypeParametersUsages;
    }

    public MemberCodegen<?> getParentCodegen() {
        return this.parentCodegen;
    }

    public String toString() {
        return this.context.toString();
    }

    @NotNull
    public DefaultSourceMapper getOrCreateSourceMapper() {
        if (this.sourceMapper == null) {
            this.sourceMapper = new DefaultSourceMapper(SourceInfo.Companion.createInfo((KtElement)this.element, this.getClassName()));
        }
        DefaultSourceMapper defaultSourceMapper = this.sourceMapper;
        if (defaultSourceMapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/MemberCodegen", "getOrCreateSourceMapper"));
        }
        return defaultSourceMapper;
    }

    protected void generateConstInstance(@NotNull Type thisAsmType, @NotNull Type fieldAsmType) {
        if (thisAsmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisAsmType", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateConstInstance"));
        }
        if (fieldAsmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldAsmType", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateConstInstance"));
        }
        this.v.newField(JvmDeclarationOriginKt.OtherOrigin(this.element), 25, "INSTANCE", fieldAsmType.getDescriptor(), null, null);
        if (this.state.getClassBuilderMode().generateBodies) {
            InstructionAdapter iv = this.createOrGetClInitCodegen().v;
            iv.anew(thisAsmType);
            iv.dup();
            iv.invokespecial(thisAsmType.getInternalName(), "<init>", "()V", false);
            iv.putstatic(thisAsmType.getInternalName(), "INSTANCE", fieldAsmType.getDescriptor());
        }
    }

    protected void generateSyntheticAccessors() {
        for (AccessorForCallableDescriptor<?> accessor : this.context.getAccessors()) {
            this.generateSyntheticAccessor(accessor);
        }
    }

    private void generateSyntheticAccessor(@NotNull AccessorForCallableDescriptor<?> accessorForCallableDescriptor) {
        if (accessorForCallableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessorForCallableDescriptor", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateSyntheticAccessor"));
        }
        if (accessorForCallableDescriptor instanceof FunctionDescriptor) {
            final FunctionDescriptor accessor = (FunctionDescriptor)((Object)accessorForCallableDescriptor);
            final FunctionDescriptor original = (FunctionDescriptor)accessorForCallableDescriptor.getCalleeDescriptor();
            this.functionCodegen.generateMethod(JvmDeclarationOriginKt.Synthetic(null, original), accessor, new FunctionGenerationStrategy.CodegenBased(this.state){

                @Override
                public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                    if (codegen == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/MemberCodegen$1", "doGenerateBody"));
                    }
                    if (signature == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/MemberCodegen$1", "doGenerateBody"));
                    }
                    MemberCodegen.markLineNumberForElement((PsiElement)MemberCodegen.this.element.getPsiOrParent(), codegen.v);
                    MemberCodegen.this.generateMethodCallTo(original, accessor, codegen.v).coerceTo(signature.getReturnType(), codegen.v);
                    codegen.v.areturn(signature.getReturnType());
                }
            });
        } else if (accessorForCallableDescriptor instanceof AccessorForPropertyDescriptor) {
            class PropertyAccessorStrategy
            extends FunctionGenerationStrategy.CodegenBased {
                private final PropertyAccessorDescriptor callableDescriptor;

                PropertyAccessorStrategy(PropertyAccessorDescriptor callableDescriptor) {
                    if (propertyDescriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/kotlin/codegen/MemberCodegen$1PropertyAccessorStrategy", "<init>"));
                    }
                    super(MemberCodegen.this.state);
                    this.callableDescriptor = callableDescriptor;
                }

                @Override
                public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                    if (codegen == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/MemberCodegen$1PropertyAccessorStrategy", "doGenerateBody"));
                    }
                    if (signature == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/MemberCodegen$1PropertyAccessorStrategy", "doGenerateBody"));
                    }
                    boolean syntheticBackingField = accessor instanceof AccessorForPropertyBackingFieldFromLocal;
                    boolean forceFieldForCompanionProperty = JvmAbi.isPropertyWithBackingFieldInOuterClass(original) && !DescriptorUtils.isCompanionObject(accessor.getContainingDeclaration());
                    boolean forceField = forceFieldForCompanionProperty || syntheticBackingField || original.getVisibility() == JavaVisibilities.PROTECTED_STATIC_VISIBILITY;
                    StackValue.Property property2 = codegen.intermediateValueForProperty(original, forceField, syntheticBackingField, accessor.getSuperCallTarget(), forceFieldForCompanionProperty, StackValue.none(), null);
                    InstructionAdapter iv = codegen.v;
                    MemberCodegen.markLineNumberForElement((PsiElement)MemberCodegen.this.element.getPsiOrParent(), iv);
                    Type[] argTypes = signature.getAsmMethod().getArgumentTypes();
                    int reg = 0;
                    for (int i = 0; i < argTypes.length; ++i) {
                        Type argType = argTypes[i];
                        iv.load(reg, argType);
                        reg += argType.getSize();
                    }
                    if (this.callableDescriptor instanceof PropertyGetterDescriptor) {
                        property2.put(signature.getReturnType(), iv);
                    } else {
                        ((StackValue)property2).store(StackValue.onStack(property2.type), iv, true);
                    }
                    iv.areturn(signature.getReturnType());
                }
            }
            final AccessorForPropertyDescriptor accessor = (AccessorForPropertyDescriptor)accessorForCallableDescriptor;
            final PropertyDescriptor original = accessor.getCalleeDescriptor();
            if (accessor.isWithSyntheticGetterAccessor()) {
                PropertyGetterDescriptorImpl getter = accessor.getGetter();
                assert (getter != null);
                this.functionCodegen.generateMethod(JvmDeclarationOriginKt.Synthetic(null, original.getGetter() != null ? original.getGetter() : original), getter, new PropertyAccessorStrategy(getter));
            }
            if (accessor.isVar() && accessor.isWithSyntheticSetterAccessor()) {
                PropertySetterDescriptor setter = accessor.getSetter();
                assert (setter != null);
                this.functionCodegen.generateMethod(JvmDeclarationOriginKt.Synthetic(null, original.getSetter() != null ? original.getSetter() : original), setter, new PropertyAccessorStrategy(setter));
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    protected StackValue generateMethodCallTo(@NotNull FunctionDescriptor functionDescriptor2, @Nullable FunctionDescriptor accessorDescriptor, @NotNull InstructionAdapter iv) {
        if (functionDescriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateMethodCallTo"));
        }
        if (iv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iv", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateMethodCallTo"));
        }
        CallableMethod callableMethod = this.typeMapper.mapToCallableMethod(functionDescriptor2, accessorDescriptor instanceof AccessorForCallableDescriptor && ((AccessorForCallableDescriptor)((Object)accessorDescriptor)).getSuperCallTarget() != null);
        boolean hasDispatchReceiver = !DescriptorUtils.isStaticDeclaration(functionDescriptor2) && !JvmCodegenUtil.isNonDefaultInterfaceMember(functionDescriptor2, this.state);
        int reg = hasDispatchReceiver ? 1 : 0;
        boolean accessorIsConstructor = accessorDescriptor instanceof AccessorForConstructorDescriptor;
        if (!accessorIsConstructor && functionDescriptor2 instanceof ConstructorDescriptor) {
            iv.anew(callableMethod.getOwner());
            iv.dup();
            reg = 0;
        } else if ((accessorIsConstructor || accessorDescriptor != null && KotlinTypeMapper.isAccessor(accessorDescriptor) && hasDispatchReceiver) && !CodegenUtilKt.isJvmStaticInObjectOrClass(functionDescriptor2)) {
            iv.load(0, AsmTypes.OBJECT_TYPE);
        }
        for (Type argType : callableMethod.getParameterTypes()) {
            if (AsmTypes.DEFAULT_CONSTRUCTOR_MARKER.equals((Object)argType)) {
                iv.aconst(null);
                continue;
            }
            iv.load(reg, argType);
            reg += argType.getSize();
        }
        callableMethod.genInvokeInstruction(iv);
        return StackValue.onStack(callableMethod.getReturnType());
    }

    protected void generateKotlinClassMetadataAnnotation(@NotNull ClassDescriptor descriptor2, boolean isScript) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateKotlinClassMetadataAnnotation"));
        }
        DescriptorSerializer serializer = DescriptorSerializer.create(descriptor2, new JvmSerializerExtension(this.v.getSerializationBindings(), this.state));
        ProtoBuf.Class classProto = serializer.classProto(descriptor2).build();
        int flags = isScript ? 4 : 0;
        WriteAnnotationUtilKt.writeKotlinMetadata(this.v, this.state, KotlinClassHeader.Kind.CLASS, flags, (Function1<? super AnnotationVisitor, Unit>)((Function1)av -> {
            AsmUtil.writeAnnotationData(av, serializer, classProto);
            return Unit.INSTANCE;
        }));
    }
}

