/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compiler.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.compiler.plugin.CliOption;
import org.jetbrains.kotlin.compiler.plugin.CliOptionValue;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\u001e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001\u001a\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0001\u00a8\u0006\f"}, d2={"cliPluginUsageString", "", "pluginId", "options", "", "Lorg/jetbrains/kotlin/compiler/plugin/CliOption;", "getPluginOptionString", "key", "value", "parsePluginOption", "Lorg/jetbrains/kotlin/compiler/plugin/CliOptionValue;", "argumentValue", "plugin-api"})
public final class CliOptionsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String cliPluginUsageString(@NotNull String pluginId, @NotNull Collection<CliOption> options2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)pluginId, (String)"pluginId");
        Intrinsics.checkParameterIsNotNull(options2, (String)"options");
        int LEFT_INDENT = 2;
        int MAX_OPTION_WIDTH = 26;
        Iterable iterable = $receiver$iv = (Iterable)options2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            CliOption cliOption = (CliOption)item$iv$iv;
            Collection collection = destination$iv$iv;
            String name2 = it.getName() + " " + it.getValueDescription();
            String margin = name2.length() > MAX_OPTION_WIDTH ? "\n" + StringsKt.repeat((CharSequence)" ", (int)(MAX_OPTION_WIDTH + LEFT_INDENT + 1)) : StringsKt.repeat((CharSequence)" ", (int)(1 + MAX_OPTION_WIDTH - name2.length()));
            List modifiers2 = CollectionsKt.listOfNotNull((Object[])new String[]{it.getRequired() ? "required" : null, it.getAllowMultipleOccurrences() ? "multiple" : null});
            String modifiersEnclosed = modifiers2.isEmpty() ? "" : " (" + CollectionsKt.joinToString$default((Iterable)modifiers2, null, null, null, (int)0, null, null, (int)63, null) + ")";
            String string = StringsKt.repeat((CharSequence)" ", (int)LEFT_INDENT) + name2 + margin + it.getDescription() + modifiersEnclosed;
            collection.add(string);
        }
        List renderedOptions = (List)destination$iv$iv;
        return "Plugin " + "\"" + pluginId + "\"" + " usage:" + "\n" + CollectionsKt.joinToString$default((Iterable)renderedOptions, (CharSequence)"\n", null, (CharSequence)"\n", (int)0, null, null, (int)58, null);
    }

    @Nullable
    public static final CliOptionValue parsePluginOption(@NotNull String argumentValue) {
        Intrinsics.checkParameterIsNotNull((Object)argumentValue, (String)"argumentValue");
        Pattern pattern = Pattern.compile("^plugin:([^:]*):([^=]*)=(.*)$");
        Matcher matcher2 = pattern.matcher(argumentValue);
        if (matcher2.matches()) {
            String string = matcher2.group(1);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"matcher.group(1)");
            String string2 = matcher2.group(2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"matcher.group(2)");
            String string3 = matcher2.group(3);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"matcher.group(3)");
            return new CliOptionValue(string, string2, string3);
        }
        return null;
    }

    @NotNull
    public static final String getPluginOptionString(@NotNull String pluginId, @NotNull String key, @NotNull String value2) {
        Intrinsics.checkParameterIsNotNull((Object)pluginId, (String)"pluginId");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        return "plugin:" + pluginId + ":" + key + "=" + value2;
    }
}

