/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.TypeSubstitutor;

public class ClassConstructorDescriptorImpl
extends FunctionDescriptorImpl
implements ClassConstructorDescriptor {
    protected final boolean isPrimary;
    private static final Name NAME = Name.special("<init>");

    protected ClassConstructorDescriptorImpl(@NotNull ClassDescriptor containingDeclaration, @Nullable ConstructorDescriptor original, @NotNull Annotations annotations2, boolean isPrimary, @NotNull CallableMemberDescriptor.Kind kind2, @NotNull SourceElement source) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "<init>"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "<init>"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "<init>"));
        }
        super(containingDeclaration, original, annotations2, NAME, kind2, source);
        this.isPrimary = isPrimary;
    }

    @NotNull
    public static ClassConstructorDescriptorImpl create(@NotNull ClassDescriptor containingDeclaration, @NotNull Annotations annotations2, boolean isPrimary, @NotNull SourceElement source) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "create"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "create"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "create"));
        }
        ClassConstructorDescriptorImpl classConstructorDescriptorImpl = new ClassConstructorDescriptorImpl(containingDeclaration, null, annotations2, isPrimary, CallableMemberDescriptor.Kind.DECLARATION, source);
        if (classConstructorDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "create"));
        }
        return classConstructorDescriptorImpl;
    }

    @NotNull
    public static ClassConstructorDescriptorImpl createSynthesized(@NotNull ClassDescriptor containingDeclaration, @NotNull Annotations annotations2, boolean isPrimary, @NotNull SourceElement source) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "createSynthesized"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "createSynthesized"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "createSynthesized"));
        }
        ClassConstructorDescriptorImpl classConstructorDescriptorImpl = new ClassConstructorDescriptorImpl(containingDeclaration, null, annotations2, isPrimary, CallableMemberDescriptor.Kind.SYNTHESIZED, source);
        if (classConstructorDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "createSynthesized"));
        }
        return classConstructorDescriptorImpl;
    }

    public ClassConstructorDescriptorImpl initialize(@NotNull List<ValueParameterDescriptor> unsubstitutedValueParameters, @NotNull Visibility visibility, @NotNull List<TypeParameterDescriptor> typeParameterDescriptors) {
        if (unsubstitutedValueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unsubstitutedValueParameters", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "initialize"));
        }
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "initialize"));
        }
        if (typeParameterDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptors", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "initialize"));
        }
        super.initialize(null, this.calculateDispatchReceiverParameter(), typeParameterDescriptors, unsubstitutedValueParameters, null, Modality.FINAL, visibility);
        return this;
    }

    public ClassConstructorDescriptorImpl initialize(@NotNull List<ValueParameterDescriptor> unsubstitutedValueParameters, @NotNull Visibility visibility) {
        if (unsubstitutedValueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unsubstitutedValueParameters", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "initialize"));
        }
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "initialize"));
        }
        this.initialize(unsubstitutedValueParameters, visibility, this.getContainingDeclaration().getDeclaredTypeParameters());
        return this;
    }

    @Nullable
    public ReceiverParameterDescriptor calculateDispatchReceiverParameter() {
        DeclarationDescriptor classContainer;
        ClassDescriptor classDescriptor = this.getContainingDeclaration();
        if (classDescriptor.isInner() && (classContainer = classDescriptor.getContainingDeclaration()) instanceof ClassDescriptor) {
            return ((ClassDescriptor)classContainer).getThisAsReceiverParameter();
        }
        return null;
    }

    @Override
    @NotNull
    public ClassDescriptor getContainingDeclaration() {
        ClassDescriptor classDescriptor = (ClassDescriptor)super.getContainingDeclaration();
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "getContainingDeclaration"));
        }
        return classDescriptor;
    }

    @Override
    @NotNull
    public ClassDescriptor getConstructedClass() {
        ClassDescriptor classDescriptor = this.getContainingDeclaration();
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "getConstructedClass"));
        }
        return classDescriptor;
    }

    @Override
    @NotNull
    public ClassConstructorDescriptor getOriginal() {
        ClassConstructorDescriptor classConstructorDescriptor = (ClassConstructorDescriptor)super.getOriginal();
        if (classConstructorDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "getOriginal"));
        }
        return classConstructorDescriptor;
    }

    @Override
    @Nullable
    public ClassConstructorDescriptor substitute(@NotNull TypeSubstitutor originalSubstitutor) {
        if (originalSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalSubstitutor", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "substitute"));
        }
        return (ClassConstructorDescriptor)super.substitute(originalSubstitutor);
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor2, D data) {
        return visitor2.visitConstructorDescriptor(this, data);
    }

    @Override
    public boolean isPrimary() {
        return this.isPrimary;
    }

    @Override
    @NotNull
    public Collection<? extends FunctionDescriptor> getOverriddenDescriptors() {
        Set set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "getOverriddenDescriptors"));
        }
        return set;
    }

    @Override
    public void setOverriddenDescriptors(@NotNull Collection<? extends CallableMemberDescriptor> overriddenDescriptors) {
        if (overriddenDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overriddenDescriptors", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "setOverriddenDescriptors"));
        }
        assert (overriddenDescriptors.isEmpty()) : "Constructors cannot override anything";
    }

    @Override
    @NotNull
    protected ClassConstructorDescriptorImpl createSubstitutedCopy(@NotNull DeclarationDescriptor newOwner, @Nullable FunctionDescriptor original, @NotNull CallableMemberDescriptor.Kind kind2, @Nullable Name newName2, @NotNull Annotations annotations2, @NotNull SourceElement source) {
        if (newOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newOwner", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "createSubstitutedCopy"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "createSubstitutedCopy"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "createSubstitutedCopy"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "createSubstitutedCopy"));
        }
        if (kind2 != CallableMemberDescriptor.Kind.DECLARATION && kind2 != CallableMemberDescriptor.Kind.SYNTHESIZED) {
            throw new IllegalStateException("Attempt at creating a constructor that is not a declaration: \ncopy from: " + this + "\nnewOwner: " + newOwner + "\nkind: " + (Object)((Object)kind2));
        }
        assert (newName2 == null) : "Attempt to rename constructor: " + this;
        ClassConstructorDescriptorImpl classConstructorDescriptorImpl = new ClassConstructorDescriptorImpl((ClassDescriptor)newOwner, this, annotations2, this.isPrimary, CallableMemberDescriptor.Kind.DECLARATION, source);
        if (classConstructorDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "createSubstitutedCopy"));
        }
        return classConstructorDescriptorImpl;
    }

    @Override
    @NotNull
    public ClassConstructorDescriptor copy(DeclarationDescriptor newOwner, Modality modality, Visibility visibility, CallableMemberDescriptor.Kind kind2, boolean copyOverrides) {
        ClassConstructorDescriptor classConstructorDescriptor = (ClassConstructorDescriptor)super.copy(newOwner, modality, visibility, kind2, copyOverrides);
        if (classConstructorDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl", "copy"));
        }
        return classConstructorDescriptor;
    }
}

