/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions.internal;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.actions.internal.KotlinInternalMode;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ)\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\u001e\u0010\u0016\u001a\u00020\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\u001a\u001a\u00020\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\f\u0010\u001f\u001a\u00020\u001b*\u00020 H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/actions/internal/FindImplicitNothingAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "allFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "filesOrDirs", "", "([Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/util/Collection;", "allKotlinFiles", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtFile;", "project", "Lcom/intellij/openapi/project/Project;", "([Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)Lkotlin/sequences/Sequence;", "find", "files", "selectedKotlinFiles", "update", "hasExplicitNothing", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isNothingOrNothingFunctionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "idea"})
public final class FindImplicitNothingAction
extends AnAction {
    private final Logger LOG = Logger.getInstance((String)"#org.jetbrains.kotlin.idea.actions.internal.FindImplicitNothingAction");

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        List selectedFiles = SequencesKt.toList(this.selectedKotlinFiles(e));
        Object object = CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Project project = (Project)object;
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(this, selectedFiles, project){
            final /* synthetic */ FindImplicitNothingAction this$0;
            final /* synthetic */ List $selectedFiles;
            final /* synthetic */ Project $project;

            public final void run() {
                Collection collection = this.$selectedFiles;
                Project project = this.$project;
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                FindImplicitNothingAction.access$find(this.this$0, collection, project);
            }
            {
                this.this$0 = findImplicitNothingAction;
                this.$selectedFiles = list2;
                this.$project = project;
            }
        }, "Finding Implicit Nothing's", true, project);
    }

    private final void find(Collection<? extends KtFile> files2, Project project) {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        ArrayList found2 = new ArrayList();
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)files2)) {
            int i = indexedValue.component1();
            KtFile file2 = (KtFile)indexedValue.component2();
            ProgressIndicator progressIndicator2 = progressIndicator;
            if (progressIndicator2 != null) {
                progressIndicator2.setText("Scanning files: " + i + " of " + files2.size() + " file. " + found2.size() + " occurences found");
            }
            ProgressIndicator progressIndicator3 = progressIndicator;
            if (progressIndicator3 != null) {
                progressIndicator3.setText2(file2.getVirtualFile().getPath());
            }
            ResolutionFacade resolutionFacade = ResolutionUtils.getResolutionFacade(file2);
            file2.acceptChildren(new KtVisitorVoid(this, resolutionFacade, found2){
                final /* synthetic */ FindImplicitNothingAction this$0;
                final /* synthetic */ ResolutionFacade $resolutionFacade;
                final /* synthetic */ ArrayList $found;

                public void visitKtElement(@NotNull KtElement element2) {
                    Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                    ProgressManager.checkCanceled();
                    element2.acceptChildren(this);
                }

                public void visitCallExpression(@NotNull KtCallExpression expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    expression2.acceptChildren(this);
                    try {
                        BindingContext bindingContext2 = ResolutionFacade.DefaultImpls.analyze$default(this.$resolutionFacade, expression2, null, 2, null);
                        KotlinType kotlinType = bindingContext2.getType(expression2);
                        if (kotlinType == null) {
                            return;
                        }
                        KotlinType type2 = kotlinType;
                        if (KotlinBuiltIns.isNothing(type2) && !FindImplicitNothingAction.access$hasExplicitNothing(this.this$0, expression2, bindingContext2)) {
                            this.$found.add(expression2);
                        }
                    }
                    catch (ProcessCanceledException e) {
                        throw (Throwable)e;
                    }
                    catch (Throwable t) {
                        FindImplicitNothingAction.access$getLOG$p(this.this$0).error(t);
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$resolutionFacade = $captured_local_variable$1;
                    this.$found = $captured_local_variable$2;
                }
            });
            ProgressIndicator progressIndicator4 = progressIndicator;
            if (progressIndicator4 == null) continue;
            progressIndicator4.setFraction((double)(i + 1) / (double)files2.size());
        }
        SwingUtilities.invokeLater(new Runnable(found2, project, files2){
            final /* synthetic */ ArrayList $found;
            final /* synthetic */ Project $project;
            final /* synthetic */ Collection $files;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                Collection collection = this.$found;
                if (!collection.isEmpty()) {
                    Object[] objectArray;
                    Collection collection2;
                    void $receiver$iv$iv;
                    Object[] $receiver$iv;
                    Object[] objectArray2 = $receiver$iv = (Object[])this.$found;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        void it;
                        KtCallExpression ktCallExpression = (KtCallExpression)item$iv$iv;
                        collection2 = destination$iv$iv;
                        objectArray = new UsageInfo2UsageAdapter(new UsageInfo((PsiElement)it));
                        collection2.add(objectArray);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    Object[] thisCollection$iv = $receiver$iv;
                    UsageInfo2UsageAdapter[] usageInfo2UsageAdapterArray = thisCollection$iv.toArray(new UsageInfo2UsageAdapter[thisCollection$iv.size()]);
                    if (usageInfo2UsageAdapterArray == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    UsageInfo2UsageAdapter[] usages2 = usageInfo2UsageAdapterArray;
                    UsageViewPresentation presentation = new UsageViewPresentation();
                    presentation.setTabName("Implicit Nothing's");
                    thisCollection$iv = new UsageTarget[0];
                    collection2 = UsageViewManager.getInstance((Project)this.$project);
                    objectArray = objectArray2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)collection2.showUsages((UsageTarget[])objectArray, (Usage[])usages2, presentation), (String)"UsageViewManager.getInst\u2026(), usages, presentation)");
                } else {
                    Messages.showInfoMessage((Project)this.$project, (String)("Not found in " + this.$files.size() + " file(s)"), (String)"Not Found");
                }
            }
            {
                this.$found = arrayList;
                this.$project = project;
                this.$files = collection;
            }
        });
    }

    private final boolean hasExplicitNothing(@NotNull KtExpression $receiver, BindingContext bindingContext2) {
        KtExpression callee;
        KtExpression ktExpression = CallUtilKt.getCalleeExpressionIfAny($receiver);
        if (ktExpression == null) {
            return false;
        }
        KtExpression ktExpression2 = callee = ktExpression;
        if (ktExpression2 instanceof KtSimpleNameExpression) {
            KtCallableDeclaration declaration2;
            CallableDescriptor callableDescriptor;
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)bindingContext2.get(BindingContext.REFERENCE_TARGET, callee);
            if (declarationDescriptor == null) {
                return false;
            }
            DeclarationDescriptor target = declarationDescriptor;
            DeclarationDescriptor declarationDescriptor2 = target;
            if (!(declarationDescriptor2 instanceof CallableDescriptor)) {
                declarationDescriptor2 = null;
            }
            CallableDescriptor callableDescriptor2 = (CallableDescriptor)declarationDescriptor2;
            if (callableDescriptor2 == null) {
                return false;
            }
            CallableDescriptor callableDescriptor3 = callableDescriptor = callableDescriptor2.getOriginal();
            Intrinsics.checkExpressionValueIsNotNull((Object)callableDescriptor3, (String)"callableDescriptor");
            PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(callableDescriptor3);
            if (!(psiElement2 instanceof KtCallableDeclaration)) {
                psiElement2 = null;
            }
            if ((declaration2 = (KtCallableDeclaration)psiElement2) != null && declaration2.getTypeReference() == null) {
                return false;
            }
            KotlinType kotlinType = callableDescriptor.getReturnType();
            if (kotlinType == null) {
                return false;
            }
            KotlinType type2 = kotlinType;
            return this.isNothingOrNothingFunctionType(type2);
        }
        return this.hasExplicitNothing(callee, bindingContext2);
    }

    private final boolean isNothingOrNothingFunctionType(@NotNull KotlinType $receiver) {
        return KotlinBuiltIns.isNothing($receiver) || FunctionTypesKt.isFunctionType($receiver) && this.isNothingOrNothingFunctionType(FunctionTypesKt.getReturnTypeFromFunctionType($receiver));
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (!KotlinInternalMode.Instance.getEnabled()) {
            e.getPresentation().setVisible(false);
            e.getPresentation().setEnabled(false);
        } else {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(SequencesKt.any(this.selectedKotlinFiles(e)));
        }
    }

    private final Sequence<KtFile> selectedKotlinFiles(AnActionEvent e) {
        VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFileArray == null) {
            return SequencesKt.sequenceOf((Object[])new KtFile[0]);
        }
        VirtualFile[] virtualFiles = virtualFileArray;
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            return SequencesKt.sequenceOf((Object[])new KtFile[0]);
        }
        Project project2 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFiles, (String)"virtualFiles");
        Project project3 = project2;
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        return this.allKotlinFiles(virtualFiles, project3);
    }

    private final Sequence<KtFile> allKotlinFiles(VirtualFile[] filesOrDirs, Project project) {
        PsiManager manager = PsiManager.getInstance((Project)project);
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.allFiles(filesOrDirs)), (Function1)((Function1)new Function1<VirtualFile, KtFile>(manager){
            final /* synthetic */ PsiManager $manager;

            @Nullable
            public final KtFile invoke(@NotNull VirtualFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                PsiFile psiFile = this.$manager.findFile(it);
                if (!(psiFile instanceof KtFile)) {
                    psiFile = null;
                }
                return (KtFile)psiFile;
            }
            {
                this.$manager = psiManager;
                super(1);
            }
        }));
    }

    private final Collection<VirtualFile> allFiles(VirtualFile[] filesOrDirs) {
        ArrayList result2 = new ArrayList();
        for (int i = 0; i < filesOrDirs.length; ++i) {
            VirtualFile file2 = filesOrDirs[i];
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Unit>(result2, new VirtualFileVisitor.Option[0]){
                final /* synthetic */ ArrayList $result;

                public boolean visitFile(@NotNull VirtualFile file2) {
                    Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                    this.$result.add(file2);
                    return true;
                }
                {
                    this.$result = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            }));
        }
        return result2;
    }

    public static final /* synthetic */ void access$find(FindImplicitNothingAction $this, @NotNull Collection files2, @NotNull Project project) {
        $this.find(files2, project);
    }

    public static final /* synthetic */ boolean access$hasExplicitNothing(FindImplicitNothingAction $this, @NotNull KtExpression $receiver, @NotNull BindingContext bindingContext2) {
        return $this.hasExplicitNothing($receiver, bindingContext2);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG$p(FindImplicitNothingAction $this) {
        return $this.LOG;
    }
}

