/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.notification.Notification;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinNotificationManager;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinStatus;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.RepositoryDescription;
import org.jetbrains.kotlin.idea.configuration.ui.notifications.ConfigureKotlinNotification;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.vfilefinder.IDEVirtualFileFinder;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\u001a9\u0010\u000f\u001a0\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011 \u0012*\u0017\u0012\u000e\b\u0001\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u0010\u00a2\u0006\u0002\b\u00130\u0010\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\u0010\u0014\u001a\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00162\u0006\u0010\u0017\u001a\u00020\n\u001a\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00162\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u00162\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001c\u001a\u00020\t\u001a\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u00162\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u001f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0011\u001a$\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u000e\b\u0002\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\u0016\u001a\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\u001f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0011\u001a\u0010\u0010#\u001a\u0004\u0018\u00010\u00012\u0006\u0010$\u001a\u00020\t\u001a\u000e\u0010%\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\n\u001a\u000e\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020)\u001a\u000e\u0010*\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\n\u001a\u000e\u0010+\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\n\u001a\u000e\u0010,\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\n\u001a\u000e\u0010-\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\n\u001a\u000e\u0010.\u001a\u00020&2\u0006\u0010$\u001a\u00020\t\u001a\u000e\u0010/\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\n\u001a\u000e\u00100\u001a\u00020&2\u0006\u0010$\u001a\u00020\t\u001a\u0018\u00101\u001a\u00020&2\u0006\u00102\u001a\u00020\t2\u0006\u00103\u001a\u00020\tH\u0002\u001a\u000e\u00104\u001a\u0002052\u0006\u0010\u0017\u001a\u00020\n\u001a\u001e\u00104\u001a\u0002052\u0006\u0010\u0018\u001a\u00020\u00192\u000e\b\u0002\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\u001f\u001a\u000e\u00106\u001a\u00020&2\u0006\u0010$\u001a\u00020\t\u001a\u001c\u00107\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n08*\b\u0012\u0004\u0012\u00020\n0\u0016\u001a\u0014\u00109\u001a\u00020&*\u00020\u00112\u0006\u0010\u0017\u001a\u00020\nH\u0002\u001a\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\n0\u001f*\b\u0012\u0004\u0012\u00020\n0\u0016\u001a\n\u0010;\u001a\u00020\t*\u00020\u0001\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0017\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0017\u0010\r\u001a\u0004\u0018\u00010\t*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006<"}, d2={"EAP_11_REPOSITORY", "Lorg/jetbrains/kotlin/idea/configuration/RepositoryDescription;", "getEAP_11_REPOSITORY", "()Lorg/jetbrains/kotlin/idea/configuration/RepositoryDescription;", "EAP_REPOSITORY", "getEAP_REPOSITORY", "SNAPSHOT_REPOSITORY", "getSNAPSHOT_REPOSITORY", "externalProjectId", "", "Lcom/intellij/openapi/module/Module;", "getExternalProjectId", "(Lcom/intellij/openapi/module/Module;)Ljava/lang/String;", "externalProjectPath", "getExternalProjectPath", "allConfigurators", "", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "()[Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "getAbleToRunConfigurators", "", "module", "project", "Lcom/intellij/openapi/project/Project;", "getConfigurableModulesWithKotlinFiles", "getConfiguratorByName", "name", "getModulesWithKotlinFiles", "getNonConfiguredModules", "", "configurator", "getNonConfiguredModulesWithKotlinFiles", "excludeModules", "getRepositoryForVersion", "version", "hasAnyKotlinRuntimeInScope", "", "hasKotlinCommonRuntimeInScope", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "hasKotlinFilesInSources", "hasKotlinFilesOnlyInTests", "hasKotlinJsRuntimeInScope", "hasKotlinJvmRuntimeInScope", "isEap", "isModuleConfigured", "isSnapshot", "isSourceRootPrefix", "externalId", "previousModuleExternalId", "showConfigureKotlinNotificationIfNeeded", "", "useEap11Repository", "buildExternalPathMap", "", "canConfigure", "excludeSourceRootModules", "toRepositorySnippet", "idea"})
public final class ConfigureKotlinInProjectUtilsKt {
    @NotNull
    private static final RepositoryDescription SNAPSHOT_REPOSITORY = new RepositoryDescription("sonatype.oss.snapshots", "Sonatype OSS Snapshot Repository", "http://oss.sonatype.org/content/repositories/snapshots", null, true);
    @NotNull
    private static final RepositoryDescription EAP_REPOSITORY = new RepositoryDescription("bintray.kotlin.eap", "Bintray Kotlin EAP Repository", "http://dl.bintray.com/kotlin/kotlin-eap", "https://bintray.com/kotlin/kotlin-eap/kotlin/", false);
    @NotNull
    private static final RepositoryDescription EAP_11_REPOSITORY = new RepositoryDescription("bintray.kotlin.eap", "Bintray Kotlin 1.1 EAP Repository", "http://dl.bintray.com/kotlin/kotlin-eap-1.1", "https://bintray.com/kotlin/kotlin-eap-1.1/kotlin/", false);

    @NotNull
    public static final RepositoryDescription getSNAPSHOT_REPOSITORY() {
        return SNAPSHOT_REPOSITORY;
    }

    @NotNull
    public static final RepositoryDescription getEAP_REPOSITORY() {
        return EAP_REPOSITORY;
    }

    @NotNull
    public static final RepositoryDescription getEAP_11_REPOSITORY() {
        return EAP_11_REPOSITORY;
    }

    @NotNull
    public static final String toRepositorySnippet(@NotNull RepositoryDescription $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return "maven {" + "\n" + "url '" + $receiver.getUrl() + "'" + "\n" + "}";
    }

    @Nullable
    public static final RepositoryDescription getRepositoryForVersion(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return ConfigureKotlinInProjectUtilsKt.isSnapshot(version) ? SNAPSHOT_REPOSITORY : (ConfigureKotlinInProjectUtilsKt.useEap11Repository(version) ? EAP_11_REPOSITORY : (ConfigureKotlinInProjectUtilsKt.isEap(version) ? EAP_REPOSITORY : null));
    }

    public static final boolean isModuleConfigured(@NotNull Module module) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Object[] $receiver$iv = ConfigureKotlinInProjectUtilsKt.allConfigurators();
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object element$iv = $receiver$iv[i];
                KotlinProjectConfigurator it = (KotlinProjectConfigurator)element$iv;
                if (!Intrinsics.areEqual((Object)((Object)it.getStatus(module)), (Object)((Object)ConfigureKotlinStatus.CONFIGURED))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<Module> getModulesWithKotlinFiles(@NotNull Project project) {
        void var3_3;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (project.isDisposed()) {
            return CollectionsKt.emptyList();
        }
        if (!FileTypeIndex.containsFileOfType((FileType)((FileType)KotlinFileType.INSTANCE), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project))) {
            return CollectionsKt.emptyList();
        }
        Iterable $receiver$iv = ProjectStructureUtilKt.allModules(project);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Module module = (Module)element$iv$iv;
            if (!FileTypeIndex.containsFileOfType((FileType)((FileType)KotlinFileType.INSTANCE), (GlobalSearchScope)module.getModuleScope(true))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<Module> getConfigurableModulesWithKotlinFiles(@NotNull Project project) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Collection<Module> modules = ConfigureKotlinInProjectUtilsKt.getModulesWithKotlinFiles(project);
        if (modules.isEmpty()) {
            return modules;
        }
        Map<String, Module> pathMap = ConfigureKotlinInProjectUtilsKt.buildExternalPathMap(ArraysKt.asList((Object[])ModuleManager.getInstance((Project)project).getModules()));
        Iterable iterable = modules;
        Collection destination$iv = new HashSet();
        for (Object item$iv : $receiver$iv) {
            Module module;
            void module2;
            Module module3 = (Module)item$iv;
            Collection collection = destination$iv;
            String externalPath = ConfigureKotlinInProjectUtilsKt.getExternalProjectPath((Module)module2);
            if (externalPath == null) {
                module = module2;
            } else {
                module = pathMap.get(externalPath);
                if (module == null) {
                    module = module2;
                }
            }
            void var12_10 = module;
            collection.add(var12_10);
        }
        return destination$iv;
    }

    public static final void showConfigureKotlinNotificationIfNeeded(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        if (ConfigureKotlinInProjectUtilsKt.isModuleConfigured(module)) {
            return;
        }
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        ConfigureKotlinNotificationManager.notify$default(ConfigureKotlinNotificationManager.INSTANCE, project, null, 2, null);
    }

    public static final void showConfigureKotlinNotificationIfNeeded(@NotNull Project project, @NotNull List<? extends Module> excludeModules) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(excludeModules, (String)"excludeModules");
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(project, excludeModules){
            final /* synthetic */ Project $project;
            final /* synthetic */ List $excludeModules;

            public final void run() {
                String notificationString2 = (String)DumbService.getInstance((Project)this.$project).runReadActionInSmartMode((Computable)new Computable<String>(this){
                    final /* synthetic */ showConfigureKotlinNotificationIfNeeded.1 this$0;

                    @Nullable
                    public final String compute() {
                        boolean bl;
                        block1: {
                            List modules = CollectionsKt.minus((Iterable)ConfigureKotlinInProjectUtilsKt.getConfigurableModulesWithKotlinFiles(this.this$0.$project), (Iterable)this.this$0.$excludeModules);
                            Iterable $receiver$iv = modules;
                            for (T element$iv : $receiver$iv) {
                                Module p1 = (Module)element$iv;
                                if (ConfigureKotlinInProjectUtilsKt.isModuleConfigured(p1)) continue;
                                bl = false;
                                break block1;
                            }
                            bl = true;
                        }
                        return bl ? null : ConfigureKotlinNotification.Companion.getNotificationString(this.this$0.$project, this.this$0.$excludeModules);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                if (notificationString2 != null) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(this, notificationString2){
                        final /* synthetic */ showConfigureKotlinNotificationIfNeeded.1 this$0;
                        final /* synthetic */ String $notificationString;

                        public final void run() {
                            ConfigureKotlinNotificationManager.INSTANCE.notify(this.this$0.$project, (Notification)new ConfigureKotlinNotification(this.this$0.$project, this.this$0.$excludeModules, this.$notificationString));
                        }
                        {
                            this.this$0 = var1_1;
                            this.$notificationString = string;
                        }
                    });
                }
            }
            {
                this.$project = project;
                this.$excludeModules = list2;
            }
        });
    }

    public static /* bridge */ /* synthetic */ void showConfigureKotlinNotificationIfNeeded$default(Project project, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        ConfigureKotlinInProjectUtilsKt.showConfigureKotlinNotificationIfNeeded(project, list2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<KotlinProjectConfigurator> getAbleToRunConfigurators(@NotNull Project project) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Object[] $receiver$iv = ConfigureKotlinInProjectUtilsKt.getConfigurableModulesWithKotlinFiles(project);
        Object[] modules = $receiver$iv.isEmpty() ? (Object[])ProjectStructureUtilKt.allModules(project) : $receiver$iv;
        Object[] $i$a$1$ifEmpty = $receiver$iv = (Object[])ConfigureKotlinInProjectUtilsKt.allConfigurators();
        Collection destination$iv$iv = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            boolean bl;
            void element$iv$iv;
            block2: {
                element$iv$iv = $receiver$iv$iv[i];
                KotlinProjectConfigurator configurator = (KotlinProjectConfigurator)element$iv$iv;
                Iterable $receiver$iv2 = (Iterable)modules;
                for (Object element$iv : $receiver$iv2) {
                    Module module;
                    Module module2 = module = (Module)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"module");
                    if (!Intrinsics.areEqual((Object)((Object)configurator.getStatus(module2)), (Object)((Object)ConfigureKotlinStatus.CAN_BE_CONFIGURED))) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<KotlinProjectConfigurator> getAbleToRunConfigurators(@NotNull Module module) {
        void var3_3;
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Object[] objectArray = $receiver$iv = (Object[])ConfigureKotlinInProjectUtilsKt.allConfigurators();
        Collection destination$iv$iv = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void element$iv$iv = $receiver$iv$iv[i];
            KotlinProjectConfigurator it = (KotlinProjectConfigurator)element$iv$iv;
            if (!Intrinsics.areEqual((Object)((Object)it.getStatus(module)), (Object)((Object)ConfigureKotlinStatus.CAN_BE_CONFIGURED))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    @Nullable
    public static final KotlinProjectConfigurator getConfiguratorByName(@NotNull String name2) {
        Object object;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            Object[] $receiver$iv = ConfigureKotlinInProjectUtilsKt.allConfigurators();
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object element$iv = $receiver$iv[i];
                KotlinProjectConfigurator it = (KotlinProjectConfigurator)element$iv;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
                object = element$iv;
                break block1;
            }
            object = null;
        }
        return (KotlinProjectConfigurator)object;
    }

    @NotNull
    public static final KotlinProjectConfigurator[] allConfigurators() {
        return (KotlinProjectConfigurator[])Extensions.getExtensions(KotlinProjectConfigurator.Companion.getEP_NAME());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Module> getNonConfiguredModules(@NotNull Project project, @NotNull KotlinProjectConfigurator configurator) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)configurator, (String)"configurator");
        Iterable $receiver$iv = ProjectStructureUtilKt.allModules(project);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Module module;
            Module module2 = module = (Module)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"module");
            if (!ConfigureKotlinInProjectUtilsKt.canConfigure(configurator, module2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return ConfigureKotlinInProjectUtilsKt.excludeSourceRootModules((List)destination$iv$iv);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean canConfigure(@NotNull KotlinProjectConfigurator $receiver, Module module) {
        Object element$iv;
        KotlinProjectConfigurator it;
        if (!Intrinsics.areEqual((Object)((Object)$receiver.getStatus(module)), (Object)((Object)ConfigureKotlinStatus.CAN_BE_CONFIGURED))) return false;
        Iterable $receiver$iv = CollectionsKt.minus((Iterable)ArraysKt.toList((Object[])ConfigureKotlinInProjectUtilsKt.allConfigurators()), (Object)$receiver);
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
        } while (!Intrinsics.areEqual((Object)((Object)(it = (KotlinProjectConfigurator)(element$iv = iterator2.next())).getStatus(module)), (Object)((Object)ConfigureKotlinStatus.CONFIGURED)));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Module> excludeSourceRootModules(@NotNull Collection<? extends Module> $receiver) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Map<String, Module> pathMap = ConfigureKotlinInProjectUtilsKt.buildExternalPathMap($receiver);
        Iterable iterable = $receiver$iv = (Iterable)$receiver;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Module it = (Module)element$iv$iv;
            if (!(ConfigureKotlinInProjectUtilsKt.getExternalProjectId(it) == null || ConfigureKotlinInProjectUtilsKt.getExternalProjectPath(it) == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)pathMap.values());
    }

    @NotNull
    public static final Map<String, Module> buildExternalPathMap(@NotNull Collection<? extends Module> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Map pathMap = new LinkedHashMap();
        for (Module module : $receiver) {
            String externalId = ConfigureKotlinInProjectUtilsKt.getExternalProjectId(module);
            String externalPath = ConfigureKotlinInProjectUtilsKt.getExternalProjectPath(module);
            if (externalId == null || externalPath == null) continue;
            Module previousModule = (Module)pathMap.get(externalPath);
            if (previousModule != null) {
                String string = ConfigureKotlinInProjectUtilsKt.getExternalProjectId(previousModule);
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                if (!ConfigureKotlinInProjectUtilsKt.isSourceRootPrefix(externalId, string)) continue;
            }
            Map map2 = pathMap;
            Module module2 = module;
            map2.put(externalPath, module2);
        }
        return pathMap;
    }

    private static final boolean isSourceRootPrefix(String externalId, String previousModuleExternalId) {
        return externalId.length() < previousModuleExternalId.length() && StringsKt.startsWith$default((String)previousModuleExternalId, (String)externalId, (boolean)false, (int)2, null);
    }

    @Nullable
    public static final String getExternalProjectId(@NotNull Module $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return ExternalSystemApiUtil.getExternalProjectId((Module)$receiver);
    }

    @Nullable
    public static final String getExternalProjectPath(@NotNull Module $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return ExternalSystemApiUtil.getExternalProjectPath((Module)$receiver);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Module> getNonConfiguredModulesWithKotlinFiles(@NotNull Project project, @NotNull KotlinProjectConfigurator configurator) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)configurator, (String)"configurator");
        Collection<Module> modules = ConfigureKotlinInProjectUtilsKt.getConfigurableModulesWithKotlinFiles(project);
        Iterable iterable = $receiver$iv = (Iterable)modules;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Module module = (Module)element$iv$iv;
            if (!Intrinsics.areEqual((Object)((Object)configurator.getStatus(module)), (Object)((Object)ConfigureKotlinStatus.CAN_BE_CONFIGURED))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<Module> getNonConfiguredModulesWithKotlinFiles(@NotNull Project project, @NotNull Collection<? extends Module> excludeModules) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(excludeModules, (String)"excludeModules");
        List modulesWithKotlinFiles = CollectionsKt.minus((Iterable)ConfigureKotlinInProjectUtilsKt.getConfigurableModulesWithKotlinFiles(project), (Iterable)excludeModules);
        KotlinProjectConfigurator[] configurators = ConfigureKotlinInProjectUtilsKt.allConfigurators();
        Iterable iterable = $receiver$iv = (Iterable)modulesWithKotlinFiles;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            boolean bl;
            block2: {
                Module module = (Module)element$iv$iv;
                Object[] $receiver$iv2 = configurators;
                for (int i = 0; i < $receiver$iv2.length; ++i) {
                    Object element$iv = $receiver$iv2[i];
                    KotlinProjectConfigurator it = (KotlinProjectConfigurator)element$iv;
                    if (!Intrinsics.areEqual((Object)((Object)it.getStatus(module)), (Object)((Object)ConfigureKotlinStatus.CAN_BE_CONFIGURED))) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Collection getNonConfiguredModulesWithKotlinFiles$default(Project project, Collection collection, int n, Object object) {
        if ((n & 2) != 0) {
            collection = CollectionsKt.emptyList();
        }
        return ConfigureKotlinInProjectUtilsKt.getNonConfiguredModulesWithKotlinFiles(project, collection);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasAnyKotlinRuntimeInScope(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        GlobalSearchScope scope2 = module.getModuleWithDependenciesAndLibrariesScope(ConfigureKotlinInProjectUtilsKt.hasKotlinFilesOnlyInTests(module));
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        GlobalSearchScope globalSearchScope = scope2;
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"scope");
        if (KotlinRuntimeLibraryUtilKt.getKotlinJvmRuntimeMarkerClass(project, globalSearchScope) != null) return true;
        Project project2 = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"module.project");
        GlobalSearchScope globalSearchScope2 = scope2;
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope2, (String)"scope");
        if (KotlinRuntimeLibraryUtilKt.hasKotlinJsKjsmFile(project2, globalSearchScope2)) return true;
        GlobalSearchScope globalSearchScope3 = scope2;
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope3, (String)"scope");
        if (!ConfigureKotlinInProjectUtilsKt.hasKotlinCommonRuntimeInScope(globalSearchScope3)) return false;
        return true;
    }

    public static final boolean hasKotlinJvmRuntimeInScope(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        GlobalSearchScope scope2 = module.getModuleWithDependenciesAndLibrariesScope(ConfigureKotlinInProjectUtilsKt.hasKotlinFilesOnlyInTests(module));
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        GlobalSearchScope globalSearchScope = scope2;
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"scope");
        return KotlinRuntimeLibraryUtilKt.getKotlinJvmRuntimeMarkerClass(project, globalSearchScope) != null;
    }

    public static final boolean hasKotlinJsRuntimeInScope(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        GlobalSearchScope scope2 = module.getModuleWithDependenciesAndLibrariesScope(ConfigureKotlinInProjectUtilsKt.hasKotlinFilesOnlyInTests(module));
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        GlobalSearchScope globalSearchScope = scope2;
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"scope");
        return KotlinRuntimeLibraryUtilKt.hasKotlinJsKjsmFile(project, globalSearchScope);
    }

    public static final boolean hasKotlinCommonRuntimeInScope(@NotNull GlobalSearchScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        IDEVirtualFileFinder iDEVirtualFileFinder = new IDEVirtualFileFinder(scope2);
        FqName fqName2 = KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME");
        return iDEVirtualFileFinder.hasMetadataPackage(fqName2);
    }

    public static final boolean hasKotlinFilesOnlyInTests(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return !ConfigureKotlinInProjectUtilsKt.hasKotlinFilesInSources(module) && FileTypeIndex.containsFileOfType((FileType)((FileType)KotlinFileType.INSTANCE), (GlobalSearchScope)module.getModuleScope(true));
    }

    public static final boolean hasKotlinFilesInSources(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return FileTypeIndex.containsFileOfType((FileType)((FileType)KotlinFileType.INSTANCE), (GlobalSearchScope)module.getModuleScope(false));
    }

    public static final boolean isSnapshot(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return StringsKt.contains((CharSequence)version, (CharSequence)"SNAPSHOT", (boolean)true);
    }

    public static final boolean isEap(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return StringsKt.contains$default((CharSequence)version, (CharSequence)"rc", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)version, (CharSequence)"eap", (boolean)false, (int)2, null);
    }

    public static final boolean useEap11Repository(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return new Regex("1\\.1(\\.\\d)?-[A-Za-z][A-Za-z0-9-]*").matches((CharSequence)version) && !StringsKt.startsWith$default((String)version, (String)"1.1.0-dev", (boolean)false, (int)2, null);
    }
}

