/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.libraries.Library;
import java.util.Arrays;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinWithLibraryConfigurator;
import org.jetbrains.kotlin.idea.versions.LibraryJarDescriptor;
import org.jetbrains.kotlin.idea.versions.OutdatedKotlinRuntimeCheckerKt;
import org.jetbrains.kotlin.js.resolve.JsPlatform;
import org.jetbrains.kotlin.resolve.TargetPlatform;

public class KotlinJsModuleConfigurator
extends KotlinWithLibraryConfigurator {
    public static final String NAME = "js";

    @Override
    @NotNull
    public String getName() {
        if (NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator", "getName"));
        }
        return NAME;
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        JsPlatform jsPlatform = JsPlatform.INSTANCE;
        if (jsPlatform == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator", "getTargetPlatform"));
        }
        return jsPlatform;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        if ("JavaScript" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator", "getPresentableText"));
        }
        return "JavaScript";
    }

    @Override
    public boolean isConfigured(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator", "isConfigured"));
        }
        return ConfigureKotlinInProjectUtilsKt.hasKotlinJsRuntimeInScope(module);
    }

    @Override
    @NotNull
    protected String getLibraryName() {
        if ("KotlinJavaScript" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator", "getLibraryName"));
        }
        return "KotlinJavaScript";
    }

    @Override
    @NotNull
    protected String getDialogTitle() {
        if ("Create Kotlin JavaScript Library" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator", "getDialogTitle"));
        }
        return "Create Kotlin JavaScript Library";
    }

    @Override
    @NotNull
    protected String getLibraryCaption() {
        if ("Kotlin JavaScript Library" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator", "getLibraryCaption"));
        }
        return "Kotlin JavaScript Library";
    }

    @Override
    @NotNull
    protected String getMessageForOverrideDialog() {
        if ("JavaScript Library Creation" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator", "getMessageForOverrideDialog"));
        }
        return "JavaScript Library Creation";
    }

    @Override
    @NotNull
    public List<LibraryJarDescriptor> getLibraryJarDescriptors(@Nullable Sdk sdk) {
        List<LibraryJarDescriptor> list2 = Arrays.asList(LibraryJarDescriptor.JS_STDLIB_JAR, LibraryJarDescriptor.JS_STDLIB_SRC_JAR);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator", "getLibraryJarDescriptors"));
        }
        return list2;
    }

    @Override
    @NotNull
    protected Function1<Library, Boolean> getLibraryMatcher() {
        Function1 function1 = OutdatedKotlinRuntimeCheckerKt::isKotlinJsRuntime;
        if (function1 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator", "getLibraryMatcher"));
        }
        return function1;
    }

    KotlinJsModuleConfigurator() {
    }
}

