/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HyperlinkLabel;
import java.awt.Component;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinSetupEnvironmentNotificationProvider;
import org.jetbrains.kotlin.idea.configuration.KotlinSetupEnvironmentNotificationProvider$Companion$createSetupSdkPanel$;
import org.jetbrains.kotlin.idea.configuration.ui.KotlinConfigurationCheckerComponent;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.versions.UnsupportedAbiVersionNotificationPanelProvider;
import org.jetbrains.kotlin.idea.versions.UnsupportedAbiVersionNotificationPanelProviderKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinSetupEnvironmentNotificationProvider;", "Lcom/intellij/ui/EditorNotifications$Provider;", "Lcom/intellij/ui/EditorNotificationPanel;", "myProject", "Lcom/intellij/openapi/project/Project;", "notifications", "Lcom/intellij/ui/EditorNotifications;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ui/EditorNotifications;)V", "createNotificationPanel", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getKey", "Lcom/intellij/openapi/util/Key;", "Companion", "idea"})
public final class KotlinSetupEnvironmentNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private final Project myProject;
    private static final Key<EditorNotificationPanel> KEY;
    public static final Companion Companion;

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key key = KotlinSetupEnvironmentNotificationProvider.Companion.getKEY();
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"KEY");
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)fileEditor, (String)"fileEditor");
        if (Intrinsics.areEqual((Object)file2.getFileType(), (Object)((Object)KotlinFileType.INSTANCE)) ^ true) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        if (psiFile2.getLanguage() != KotlinLanguage.INSTANCE) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiFile2));
        if (module == null) {
            return null;
        }
        Module module2 = module;
        if (!ModuleRootManager.getInstance((Module)module2).getFileIndex().isInSourceContent(file2)) {
            return null;
        }
        if (ModuleRootManager.getInstance((Module)module2).getSdk() == null) {
            PsiFile psiFile3 = psiFile2;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile3, (String)"psiFile");
            return KotlinSetupEnvironmentNotificationProvider.Companion.createSetupSdkPanel(this.myProject, psiFile3);
        }
        Project project = module2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        if (!KotlinConfigurationCheckerComponent.Companion.getInstance(project).isSyncing()) {
            Module module3 = module2;
            Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"module");
            if (!ConfigureKotlinInProjectUtilsKt.hasAnyKotlinRuntimeInScope(module3)) {
                Module module4 = module2;
                Intrinsics.checkExpressionValueIsNotNull((Object)module4, (String)"module");
                if (UnsupportedAbiVersionNotificationPanelProvider.Companion.collectBadRoots(module4).isEmpty()) {
                    Module module5 = module2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)module5, (String)"module");
                    return KotlinSetupEnvironmentNotificationProvider.Companion.createKotlinNotConfiguredPanel(module5);
                }
            }
        }
        return null;
    }

    public KotlinSetupEnvironmentNotificationProvider(@NotNull Project myProject, final @NotNull EditorNotifications notifications) {
        Intrinsics.checkParameterIsNotNull((Object)myProject, (String)"myProject");
        Intrinsics.checkParameterIsNotNull((Object)notifications, (String)"notifications");
        this.myProject = myProject;
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(@Nullable ModuleRootEvent event) {
                notifications.updateAllNotifications();
            }
        });
    }

    static {
        Companion = new Companion(null);
        KEY = Key.create((String)"Setup SDK");
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R'\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinSetupEnvironmentNotificationProvider$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ui/EditorNotificationPanel;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getKEY", "()Lcom/intellij/openapi/util/Key;", "createConfiguratorsPopup", "Lcom/intellij/openapi/ui/popup/ListPopup;", "project", "Lcom/intellij/openapi/project/Project;", "configurators", "", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "createKotlinNotConfiguredPanel", "module", "Lcom/intellij/openapi/module/Module;", "createSetupSdkPanel", "file", "Lcom/intellij/psi/PsiFile;", "idea"})
    public static final class Companion {
        private final Key<EditorNotificationPanel> getKEY() {
            return KEY;
        }

        private final EditorNotificationPanel createSetupSdkPanel(Project project, PsiFile file2) {
            EditorNotificationPanel editorNotificationPanel;
            EditorNotificationPanel $receiver = editorNotificationPanel = new EditorNotificationPanel();
            $receiver.setText(ProjectBundle.message((String)"project.sdk.not.defined", (Object[])new Object[0]));
            $receiver.createActionLabel(ProjectBundle.message((String)"project.sdk.setup", (Object[])new Object[0]), new Runnable(project, file2){
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ PsiFile $file$inlined;
                {
                    this.$project$inlined = project;
                    this.$file$inlined = psiFile;
                }

                public final void run() {
                    if (ProjectSettingsService.getInstance((Project)this.$project$inlined).chooseAndSetSdk() == null) {
                        return;
                    }
                    ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(this){
                        final /* synthetic */ Companion$createSetupSdkPanel$$inlined$apply$lambda$1 this$0;
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }

                        public final void invoke() {
                            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)this.this$0.$file$inlined));
                            if (module != null) {
                                ModuleRootModificationUtil.setSdkInherited((Module)module);
                            }
                        }
                    });
                }
            });
            return editorNotificationPanel;
        }

        private final EditorNotificationPanel createKotlinNotConfiguredPanel(Module module) {
            EditorNotificationPanel editorNotificationPanel;
            EditorNotificationPanel $receiver = editorNotificationPanel = new EditorNotificationPanel();
            $receiver.setText("Kotlin not configured");
            List configurators = CollectionsKt.toList((Iterable)ConfigureKotlinInProjectUtilsKt.getAbleToRunConfigurators(module));
            if (!configurators.isEmpty()) {
                UnsupportedAbiVersionNotificationPanelProviderKt.createComponentActionLabel($receiver, "Configure", (Function1<? super HyperlinkLabel, Unit>)((Function1)new Function1<HyperlinkLabel, Unit>(configurators, module){
                    final /* synthetic */ List $configurators;
                    final /* synthetic */ Module $module$inlined;
                    {
                        this.$configurators = list2;
                        this.$module$inlined = module;
                        super(1);
                    }

                    public final void invoke(HyperlinkLabel label2) {
                        KotlinProjectConfigurator singleConfigurator = (KotlinProjectConfigurator)CollectionsKt.singleOrNull((List)this.$configurators);
                        if (singleConfigurator != null) {
                            Project project = this.$module$inlined.getProject();
                            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
                            singleConfigurator.configure(project, CollectionsKt.emptyList());
                        } else {
                            Project project = this.$module$inlined.getProject();
                            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
                            ListPopup configuratorsPopup = KotlinSetupEnvironmentNotificationProvider.Companion.createConfiguratorsPopup(project, this.$configurators);
                            configuratorsPopup.showUnderneathOf((Component)label2);
                        }
                    }
                }));
            }
            return editorNotificationPanel;
        }

        @NotNull
        public final ListPopup createConfiguratorsPopup(@NotNull Project project, @NotNull List<? extends KotlinProjectConfigurator> configurators) {
            ListPopup configuratorsPopup;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull(configurators, (String)"configurators");
            BaseListPopupStep<KotlinProjectConfigurator> step2 = new BaseListPopupStep<KotlinProjectConfigurator>(project, configurators, "Choose Configurator", configurators){
                final /* synthetic */ Project $project;
                final /* synthetic */ List $configurators;

                @NotNull
                public String getTextFor(@Nullable KotlinProjectConfigurator value2) {
                    Object object = value2;
                    if (object == null || (object = object.getPresentableText()) == null) {
                        object = "<none>";
                    }
                    return object;
                }

                @Nullable
                public PopupStep<?> onChosen(@Nullable KotlinProjectConfigurator selectedValue, boolean finalChoice) {
                    return this.doFinalStep(new Runnable(this, selectedValue){
                        final /* synthetic */ createConfiguratorsPopup.step.1 this$0;
                        final /* synthetic */ KotlinProjectConfigurator $selectedValue;

                        public final void run() {
                            block0: {
                                KotlinProjectConfigurator kotlinProjectConfigurator = this.$selectedValue;
                                if (kotlinProjectConfigurator == null) break block0;
                                kotlinProjectConfigurator.configure(this.this$0.$project, CollectionsKt.emptyList());
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$selectedValue = kotlinProjectConfigurator;
                        }
                    });
                }
                {
                    this.$project = $captured_local_variable$0;
                    this.$configurators = $captured_local_variable$1;
                    super($super_call_param$2, $super_call_param$3);
                }
            };
            ListPopup listPopup = configuratorsPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step2);
            Intrinsics.checkExpressionValueIsNotNull((Object)listPopup, (String)"configuratorsPopup");
            return listPopup;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

