/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.navigation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.BinaryModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.resolve.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.caches.resolve.SourceForBinaryModuleInfo;
import org.jetbrains.kotlin.idea.decompiler.navigation.MemberMatching;
import org.jetbrains.kotlin.idea.decompiler.navigation.SourceNavigationHelper$WhenMappings;
import org.jetbrains.kotlin.idea.decompiler.navigation.SourceNavigationHelperKt;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelPropertyFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelTypeAliasFqNameIndex;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.debugText.DebugTextUtilKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000256B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J7\u0010\u0010\u001a\u0004\u0018\u0001H\u0011\"\b\b\u0000\u0010\u0011*\u00020\t2\u0006\u0010\u0012\u001a\u0002H\u00112\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u00142\u0006\u0010\u001c\u001a\u00020\tH\u0002J.\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u00182\u000e\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\"H\u0002J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0$2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010%\u001a\u00020&2\u0006\u0010\n\u001a\u00020&J\u0010\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u000eJ\u000e\u0010*\u001a\u00020&2\u0006\u0010\n\u001a\u00020&J\u0010\u0010+\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u000eJ\u0016\u0010,\u001a\u00020\u00072\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0$H\u0002J\u0018\u0010/\u001a\u00020&2\u0006\u00100\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u00101\u001a\u0002022\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u00103\u001a\u0004\u0018\u0001042\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "forceResolve", "", "convertPropertyOrFunction", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "declaration", "navigationKind", "Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;", "findClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "decompiledClassOrObject", "findFirstMatchingInIndex", "T", "entity", "index", "Lcom/intellij/psi/stubs/StringStubIndexExtension;", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;Lcom/intellij/psi/stubs/StringStubIndexExtension;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "findSpecialProperty", "memberName", "Lorg/jetbrains/kotlin/name/Name;", "containingClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "getIndexForTopLevelPropertyOrFunction", "decompiledDeclaration", "getInitialMemberCandidates", "", "sourceClassOrObject", "name", "declarationClass", "Ljava/lang/Class;", "getInitialTopLevelCandidates", "", "getNavigationElement", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getOriginalClass", "Lcom/intellij/psi/PsiClass;", "classOrObject", "getOriginalElement", "getOriginalPsiClassOrCreateLightClass", "haveRenamesInImports", "files", "Lorg/jetbrains/kotlin/psi/KtFile;", "navigateToDeclaration", "from", "setForceResolve", "", "targetScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "NavigationKind", "SourceAndDecompiledConversionVisitor", "idea-analysis"})
public final class SourceNavigationHelper {
    private static final Logger LOG;
    private static boolean forceResolve;
    public static final SourceNavigationHelper INSTANCE;

    public final void setForceResolve(boolean forceResolve) {
        SourceNavigationHelper.forceResolve = forceResolve;
    }

    private final GlobalSearchScope targetScope(KtNamedDeclaration declaration2, NavigationKind navigationKind) {
        GlobalSearchScope globalSearchScope;
        KtFile containingFile = declaration2.getContainingKtFile();
        VirtualFile virtualFile2 = containingFile.getVirtualFile();
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile vFile = virtualFile2;
        Project project = declaration2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"declaration.project");
        IdeaModuleInfo fromModuleInfo = GetModuleInfoKt.getModuleInfoByVirtualFile(project, vFile);
        switch (SourceNavigationHelper$WhenMappings.$EnumSwitchMapping$0[navigationKind.ordinal()]) {
            case 1: {
                IdeaModuleInfo ideaModuleInfo;
                IdeaModuleInfo ideaModuleInfo2 = fromModuleInfo;
                if (!(ideaModuleInfo2 instanceof BinaryModuleInfo)) {
                    ideaModuleInfo2 = null;
                }
                if ((ideaModuleInfo = (BinaryModuleInfo)ideaModuleInfo2) != null && (ideaModuleInfo = ideaModuleInfo.getSourcesModuleInfo()) != null) {
                    globalSearchScope = ideaModuleInfo.sourceScope();
                    break;
                }
                globalSearchScope = null;
                break;
            }
            case 2: {
                IdeaModuleInfo ideaModuleInfo;
                IdeaModuleInfo ideaModuleInfo3 = fromModuleInfo;
                if (!(ideaModuleInfo3 instanceof SourceForBinaryModuleInfo)) {
                    ideaModuleInfo3 = null;
                }
                if ((ideaModuleInfo = (SourceForBinaryModuleInfo)ideaModuleInfo3) != null && (ideaModuleInfo = ideaModuleInfo.getBinariesModuleInfo()) != null) {
                    globalSearchScope = ideaModuleInfo.binariesScope();
                    break;
                }
                globalSearchScope = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return globalSearchScope;
    }

    private final boolean haveRenamesInImports(Collection<? extends KtFile> files2) {
        boolean bl;
        block3: {
            Iterable $receiver$iv = files2;
            for (Object element$iv : $receiver$iv) {
                boolean bl2;
                block2: {
                    KtFile it = (KtFile)element$iv;
                    Iterable $receiver$iv2 = it.getImportDirectives();
                    for (Object element$iv2 : $receiver$iv2) {
                        KtImportDirective it2 = (KtImportDirective)element$iv2;
                        if (!(it2.getAliasName() != null)) continue;
                        bl2 = true;
                        break block2;
                    }
                    bl2 = false;
                }
                if (!bl2) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    private final KtNamedDeclaration findSpecialProperty(Name memberName, KtClass containingClass) {
        List<KtParameter> constructorParameters = containingClass.getPrimaryConstructorParameters();
        for (KtParameter constructorParameter : constructorParameters) {
            if (!Intrinsics.areEqual((Object)memberName, (Object)constructorParameter.getNameAsName()) || !constructorParameter.hasValOrVar()) continue;
            return constructorParameter;
        }
        if (containingClass.hasModifier(KtTokens.ENUM_KEYWORD)) {
            for (KtEnumEntry enumEntry : ContainerUtil.findAll((Collection)containingClass.getDeclarations(), KtEnumEntry.class)) {
                if (!Intrinsics.areEqual((Object)memberName, (Object)enumEntry.getNameAsName())) continue;
                return enumEntry;
            }
        }
        return null;
    }

    private final KtNamedDeclaration convertPropertyOrFunction(KtNamedDeclaration declaration2, NavigationKind navigationKind) {
        Object decompiledClassOrObject;
        Collection candidates2;
        if (declaration2 instanceof KtPrimaryConstructor) {
            KtClassOrObject sourceClassOrObject = this.findClassOrObject(((KtPrimaryConstructor)declaration2).getContainingClassOrObject(), navigationKind);
            KtDeclarationStub ktDeclarationStub = sourceClassOrObject;
            return ktDeclarationStub != null && (ktDeclarationStub = ktDeclarationStub.getPrimaryConstructor()) != null ? (KtNamedDeclaration)((Object)ktDeclarationStub) : (KtNamedDeclaration)sourceClassOrObject;
        }
        String memberNameAsString = declaration2.getName();
        if (memberNameAsString == null) {
            LOG.debug("Declaration with null name:" + DebugTextUtilKt.getDebugText(declaration2));
            return null;
        }
        Name memberName = Name.identifier(memberNameAsString);
        PsiElement decompiledContainer = declaration2.getParent();
        PsiElement psiElement2 = decompiledContainer;
        if (psiElement2 instanceof KtFile) {
            candidates2 = this.getInitialTopLevelCandidates(declaration2, navigationKind);
        } else if (psiElement2 instanceof KtClassBody) {
            Object object;
            Object object2;
            Iterator iterator2;
            KtClassOrObject sourceClassOrObject;
            PsiElement psiElement3 = decompiledContainer.getParent();
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
            }
            decompiledClassOrObject = (KtClassOrObject)psiElement3;
            KtClassOrObject ktClassOrObject = sourceClassOrObject = this.findClassOrObject((KtClassOrObject)decompiledClassOrObject, navigationKind);
            if (ktClassOrObject != null) {
                iterator2 = ktClassOrObject;
                KtClassOrObject it = iterator2;
                Name name2 = memberName;
                Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"memberName");
                object2 = INSTANCE.getInitialMemberCandidates(sourceClassOrObject, name2, declaration2.getClass());
            } else {
                object2 = iterator2 = null;
            }
            if ((object = iterator2) == null) {
                object = CollectionsKt.emptyList();
            }
            candidates2 = (Collection)object;
            if (candidates2.isEmpty() && declaration2 instanceof KtProperty && sourceClassOrObject instanceof KtClass) {
                Name name3 = memberName;
                Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"memberName");
                return this.findSpecialProperty(name3, (KtClass)sourceClassOrObject);
            }
        } else {
            throw (Throwable)new IllegalStateException("Unexpected container of " + (Intrinsics.areEqual((Object)((Object)navigationKind), (Object)((Object)NavigationKind.CLASS_FILES_TO_SOURCES)) ? "decompiled" : "source") + " declaration: " + decompiledContainer.getClass().getSimpleName());
        }
        if (candidates2.isEmpty()) {
            return null;
        }
        if (!forceResolve) {
            KtNamedDeclaration it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv = candidates2;
            decompiledClassOrObject = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (KtNamedDeclaration)element$iv$iv;
                if (!MemberMatching.sameReceiverPresenceAndParametersCount(it, declaration2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            candidates2 = (List)destination$iv$iv;
            if (candidates2.size() <= 1) {
                return (KtNamedDeclaration)CollectionsKt.firstOrNull((List)((List)candidates2));
            }
            if (!this.haveRenamesInImports(SourceNavigationHelperKt.access$getContainingFiles(candidates2))) {
                $receiver$iv$iv = $receiver$iv = (Iterable)candidates2;
                destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    it = (KtNamedDeclaration)element$iv$iv;
                    if (!MemberMatching.receiverAndParametersShortTypesMatch(it, declaration2)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                candidates2 = (List)destination$iv$iv;
                if (candidates2.size() <= 1) {
                    return (KtNamedDeclaration)CollectionsKt.firstOrNull((List)((List)candidates2));
                }
            }
        }
        for (KtNamedDeclaration candidate : candidates2) {
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptor$default(candidate, null, 1, null);
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableDescriptor");
            }
            CallableDescriptor candidateDescriptor = (CallableDescriptor)declarationDescriptor;
            if (!MemberMatching.receiversMatch(declaration2, candidateDescriptor) || !MemberMatching.valueParametersTypesMatch(declaration2, candidateDescriptor)) continue;
            KtNamedDeclaration ktNamedDeclaration = declaration2;
            if (ktNamedDeclaration == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeParameterListOwner");
            }
            if (!MemberMatching.typeParametersMatch((KtTypeParameterListOwner)ktNamedDeclaration, candidateDescriptor.getTypeParameters())) continue;
            return candidate;
        }
        return null;
    }

    private final <T extends KtNamedDeclaration> T findFirstMatchingInIndex(T entity, NavigationKind navigationKind, StringStubIndexExtension<T> index2) {
        FqName fqName2 = entity.getFqName();
        if (fqName2 == null) {
            Intrinsics.throwNpe();
        }
        FqName classFqName = fqName2;
        GlobalSearchScope globalSearchScope = this.targetScope(entity, navigationKind);
        if (globalSearchScope == null) {
            return null;
        }
        GlobalSearchScope scope2 = globalSearchScope;
        return (T)((KtNamedDeclaration)CollectionsKt.firstOrNull((Iterable)index2.get((Object)classFqName.asString(), entity.getProject(), scope2)));
    }

    private final KtClassOrObject findClassOrObject(KtClassOrObject decompiledClassOrObject, NavigationKind navigationKind) {
        KtNamedDeclaration ktNamedDeclaration = decompiledClassOrObject;
        KotlinFullClassNameIndex kotlinFullClassNameIndex = KotlinFullClassNameIndex.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinFullClassNameIndex), (String)"KotlinFullClassNameIndex.getInstance()");
        return (KtClassOrObject)this.findFirstMatchingInIndex(ktNamedDeclaration, navigationKind, kotlinFullClassNameIndex);
    }

    private final Collection<KtNamedDeclaration> getInitialTopLevelCandidates(KtNamedDeclaration declaration2, NavigationKind navigationKind) {
        GlobalSearchScope globalSearchScope = this.targetScope(declaration2, navigationKind);
        if (globalSearchScope == null) {
            return CollectionsKt.emptyList();
        }
        GlobalSearchScope scope2 = globalSearchScope;
        StringStubIndexExtension<? extends KtNamedDeclaration> index2 = this.getIndexForTopLevelPropertyOrFunction(declaration2);
        FqName fqName2 = declaration2.getFqName();
        if (fqName2 == null) {
            Intrinsics.throwNpe();
        }
        Collection collection = index2.get((Object)fqName2.asString(), declaration2.getProject(), scope2);
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"index.get(declaration.fq\u2026claration.project, scope)");
        return collection;
    }

    private final StringStubIndexExtension<? extends KtNamedDeclaration> getIndexForTopLevelPropertyOrFunction(KtNamedDeclaration decompiledDeclaration) {
        KtNamedDeclaration ktNamedDeclaration = decompiledDeclaration;
        if (ktNamedDeclaration instanceof KtNamedFunction) {
            KotlinTopLevelFunctionFqnNameIndex kotlinTopLevelFunctionFqnNameIndex = KotlinTopLevelFunctionFqnNameIndex.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinTopLevelFunctionFqnNameIndex), (String)"KotlinTopLevelFunctionFqnNameIndex.getInstance()");
            return kotlinTopLevelFunctionFqnNameIndex;
        }
        if (ktNamedDeclaration instanceof KtProperty) {
            KotlinTopLevelPropertyFqnNameIndex kotlinTopLevelPropertyFqnNameIndex = KotlinTopLevelPropertyFqnNameIndex.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinTopLevelPropertyFqnNameIndex), (String)"KotlinTopLevelPropertyFqnNameIndex.getInstance()");
            return kotlinTopLevelPropertyFqnNameIndex;
        }
        throw (Throwable)new IllegalArgumentException("Neither function nor declaration: " + decompiledDeclaration.getClass().getName());
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtNamedDeclaration> getInitialMemberCandidates(KtClassOrObject sourceClassOrObject, Name name2, Class<? extends KtNamedDeclaration> declarationClass) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.filterIsInstance((Iterable)sourceClassOrObject.getDeclarations(), declarationClass);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KtNamedDeclaration declaration2 = (KtNamedDeclaration)element$iv$iv;
            if (!Intrinsics.areEqual((Object)name2, (Object)declaration2.getNameAsSafeName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final PsiClass getOriginalPsiClassOrCreateLightClass(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
        FqName fqName2 = classOrObject.getFqName();
        if (fqName2 != null) {
            FqNameUnsafe fqNameUnsafe = fqName2.toUnsafe();
            Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"fqName.toUnsafe()");
            ClassId javaClassId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqNameUnsafe);
            if (javaClassId != null) {
                return JavaPsiFacade.getInstance((Project)classOrObject.getProject()).findClass(javaClassId.asSingleFqName().asString(), GlobalSearchScope.allScope((Project)classOrObject.getProject()));
            }
        }
        return LightClassUtilsKt.toLightClass(classOrObject);
    }

    @Nullable
    public final PsiClass getOriginalClass(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
        FqName fqName2 = classOrObject.getFqName();
        if (fqName2 == null) {
            return null;
        }
        FqName fqName3 = fqName2;
        KtFile file2 = classOrObject.getContainingKtFile();
        VirtualFile vFile = file2.getVirtualFile();
        Project project = file2.getProject();
        ProjectFileIndex idx = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (vFile == null || !idx.isInLibrarySource(vFile)) {
            return null;
        }
        THashSet orderEntries = new THashSet((Collection)idx.getOrderEntriesForFile(vFile));
        return JavaPsiFacade.getInstance((Project)project).findClass(fqName3.asString(), new GlobalSearchScope(idx, orderEntries, project, project){
            final /* synthetic */ ProjectFileIndex $idx;
            final /* synthetic */ THashSet $orderEntries;
            final /* synthetic */ Project $project;

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                Intrinsics.checkParameterIsNotNull((Object)file1, (String)"file1");
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file2");
                return 0;
            }

            public boolean contains(@NotNull VirtualFile file2) {
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                List entries2 = this.$idx.getOrderEntriesForFile(file2);
                for (OrderEntry entry : entries2) {
                    if (!this.$orderEntries.contains((Object)entry)) continue;
                    return true;
                }
                return false;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                Intrinsics.checkParameterIsNotNull((Object)aModule, (String)"aModule");
                return false;
            }

            public boolean isSearchInLibraries() {
                return true;
            }
            {
                this.$idx = $captured_local_variable$0;
                this.$orderEntries = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                super($super_call_param$3);
            }
        });
    }

    @NotNull
    public final KtDeclaration getNavigationElement(@NotNull KtDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        return this.navigateToDeclaration(declaration2, NavigationKind.CLASS_FILES_TO_SOURCES);
    }

    @NotNull
    public final KtDeclaration getOriginalElement(@NotNull KtDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        return this.navigateToDeclaration(declaration2, NavigationKind.SOURCES_TO_CLASS_FILES);
    }

    private final KtDeclaration navigateToDeclaration(KtDeclaration from, NavigationKind navigationKind) {
        KtDeclaration ktDeclaration;
        if (DumbService.isDumb((Project)from.getProject())) {
            return from;
        }
        switch (SourceNavigationHelper$WhenMappings.$EnumSwitchMapping$1[navigationKind.ordinal()]) {
            case 1: {
                if (from.getContainingKtFile().isCompiled()) break;
                return from;
            }
            case 2: {
                if (from.getContainingKtFile().isCompiled()) {
                    return from;
                }
                if (!ProjectRootsUtil.isInContent(from, false, true, false, true)) {
                    return from;
                }
                if (!KtPsiUtil.isLocal(from)) break;
                return from;
            }
        }
        if ((ktDeclaration = (KtDeclaration)from.accept(new SourceAndDecompiledConversionVisitor(navigationKind), Unit.INSTANCE)) == null) {
            ktDeclaration = from;
        }
        return ktDeclaration;
    }

    private SourceNavigationHelper() {
        INSTANCE = this;
        LOG = Logger.getInstance(SourceNavigationHelper.class);
    }

    static {
        new SourceNavigationHelper();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;", "", "(Ljava/lang/String;I)V", "CLASS_FILES_TO_SOURCES", "SOURCES_TO_CLASS_FILES", "idea-analysis"})
    public static final class NavigationKind
    extends Enum<NavigationKind> {
        public static final /* enum */ NavigationKind CLASS_FILES_TO_SOURCES;
        public static final /* enum */ NavigationKind SOURCES_TO_CLASS_FILES;
        private static final /* synthetic */ NavigationKind[] $VALUES;

        static {
            NavigationKind[] navigationKindArray = new NavigationKind[2];
            NavigationKind[] navigationKindArray2 = navigationKindArray;
            navigationKindArray[0] = CLASS_FILES_TO_SOURCES = new NavigationKind();
            navigationKindArray[1] = SOURCES_TO_CLASS_FILES = new NavigationKind();
            $VALUES = navigationKindArray;
        }

        public static NavigationKind[] values() {
            return (NavigationKind[])$VALUES.clone();
        }

        public static NavigationKind valueOf(String string) {
            return Enum.valueOf(NavigationKind.class, string);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\fJ\u001f\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0015J\u001f\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0019J\u001f\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001f\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010!J\u001f\u0010\"\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010$J\u001f\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$SourceAndDecompiledConversionVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "", "navigationKind", "Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;", "(Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;)V", "visitClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "data", "(Lorg/jetbrains/kotlin/psi/KtClass;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitNamedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "(Lorg/jetbrains/kotlin/psi/KtParameter;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtDeclaration;", "visitPrimaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "(Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitSecondaryConstructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "(Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitTypeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "typeAlias", "(Lorg/jetbrains/kotlin/psi/KtTypeAlias;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "idea-analysis"})
    private static final class SourceAndDecompiledConversionVisitor
    extends KtVisitor<KtDeclaration, Unit> {
        private final NavigationKind navigationKind;

        @Override
        @Nullable
        public KtNamedDeclaration visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull Unit data) {
            Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return INSTANCE.convertPropertyOrFunction(function2, this.navigationKind);
        }

        @Override
        @Nullable
        public KtNamedDeclaration visitProperty(@NotNull KtProperty property2, @NotNull Unit data) {
            Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return INSTANCE.convertPropertyOrFunction(property2, this.navigationKind);
        }

        @Override
        @Nullable
        public KtClassOrObject visitObjectDeclaration(@NotNull KtObjectDeclaration declaration2, @NotNull Unit data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return INSTANCE.findClassOrObject(declaration2, this.navigationKind);
        }

        @Override
        @Nullable
        public KtClassOrObject visitClass(@NotNull KtClass klass2, @NotNull Unit data) {
            Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return INSTANCE.findClassOrObject(klass2, this.navigationKind);
        }

        @Override
        @Nullable
        public KtTypeAlias visitTypeAlias(@NotNull KtTypeAlias typeAlias2, @NotNull Unit data) {
            Intrinsics.checkParameterIsNotNull((Object)typeAlias2, (String)"typeAlias");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return (KtTypeAlias)INSTANCE.findFirstMatchingInIndex(typeAlias2, this.navigationKind, KotlinTopLevelTypeAliasFqNameIndex.Companion.getInstance());
        }

        @Override
        @Nullable
        public KtDeclaration visitParameter(@NotNull KtParameter parameter, @NotNull Unit data) {
            Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            PsiElement psiElement2 = parameter.getParent().getParent();
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallableDeclaration");
            }
            KtCallableDeclaration callableDeclaration = (KtCallableDeclaration)psiElement2;
            List<KtParameter> parameters2 = callableDeclaration.getValueParameters();
            int index2 = parameters2.indexOf(parameter);
            Object r = callableDeclaration.accept(this, Unit.INSTANCE);
            if (!(r instanceof KtCallableDeclaration)) {
                r = null;
            }
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)r;
            if (ktCallableDeclaration == null) {
                return null;
            }
            KtCallableDeclaration sourceCallable = ktCallableDeclaration;
            List<KtParameter> sourceParameters = sourceCallable.getValueParameters();
            if (sourceParameters.size() != parameters2.size()) {
                return null;
            }
            return sourceParameters.get(index2);
        }

        @Override
        @Nullable
        public KtNamedDeclaration visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor2, @NotNull Unit data) {
            Intrinsics.checkParameterIsNotNull((Object)constructor2, (String)"constructor");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return INSTANCE.convertPropertyOrFunction(constructor2, this.navigationKind);
        }

        @Override
        @Nullable
        public KtNamedDeclaration visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor2, @NotNull Unit data) {
            Intrinsics.checkParameterIsNotNull((Object)constructor2, (String)"constructor");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return INSTANCE.convertPropertyOrFunction(constructor2, this.navigationKind);
        }

        public SourceAndDecompiledConversionVisitor(@NotNull NavigationKind navigationKind) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)navigationKind), (String)"navigationKind");
            this.navigationKind = navigationKind;
        }
    }
}

