/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.stubBuilder;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderContext;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuildingKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.TypeClsStubBuilder;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.flags.FlagsKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.flags.FlagsToModifiers;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinModifierListStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeAliasStubImpl;
import org.jetbrains.kotlin.serialization.Flags;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"createTypeAliasStub", "", "parent", "Lcom/intellij/psi/stubs/StubElement;", "Lcom/intellij/psi/PsiElement;", "typeAliasProto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$TypeAlias;", "protoContainer", "Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer;", "context", "Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/ClsStubBuilderContext;", "idea-analysis"})
public final class TypeAliasClsStubBuildingKt {
    /*
     * WARNING - void declaration
     */
    public static final void createTypeAliasStub(@NotNull StubElement<? extends PsiElement> parent2, @NotNull ProtoBuf.TypeAlias typeAliasProto, @NotNull ProtoContainer protoContainer, @NotNull ClsStubBuilderContext context) {
        ClassId classId;
        Intrinsics.checkParameterIsNotNull(parent2, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)typeAliasProto, (String)"typeAliasProto");
        Intrinsics.checkParameterIsNotNull((Object)protoContainer, (String)"protoContainer");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Name shortName = context.getNameResolver().getName(typeAliasProto.getName());
        ProtoContainer protoContainer2 = protoContainer;
        if (protoContainer2 instanceof ProtoContainer.Class) {
            classId = ((ProtoContainer.Class)protoContainer).getClassId().createNestedClassId(shortName);
        } else if (protoContainer2 instanceof ProtoContainer.Package) {
            classId = ClassId.topLevel(((ProtoContainer.Package)protoContainer).getFqName().child(shortName));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        ClassId classId2 = classId;
        KotlinTypeAliasStubImpl typeAlias2 = new KotlinTypeAliasStubImpl(parent2, ClsStubBuildingKt.ref(classId2.getShortClassName()), ClsStubBuildingKt.ref(classId2.asSingleFqName()), !classId2.isNestedClass());
        List list2 = CollectionsKt.arrayListOf((Object[])new FlagsToModifiers[]{FlagsKt.getVISIBILITY()});
        int n = typeAliasProto.getFlags();
        Object object = (StubElement)typeAlias2;
        List list3 = CollectionsKt.emptyList();
        KotlinModifierListStubImpl modifierList = ClsStubBuildingKt.createModifierListStubForDeclaration((StubElement<? extends PsiElement>)object, n, list2, list3);
        TypeClsStubBuilder typeStubBuilder = new TypeClsStubBuilder(context);
        StubElement stubElement = (StubElement)typeAlias2;
        List<ProtoBuf.TypeParameter> list4 = typeAliasProto.getTypeParameterList();
        Intrinsics.checkExpressionValueIsNotNull(list4, (String)"typeAliasProto.typeParameterList");
        List<Pair<Name, ProtoBuf.Type>> restConstraints = typeStubBuilder.createTypeParameterListStub((StubElement<? extends PsiElement>)stubElement, list4);
        boolean bl = restConstraints.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "'where' constraints are not allowed for type aliases";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Boolean bl2 = Flags.HAS_ANNOTATIONS.get(typeAliasProto.getFlags());
        Intrinsics.checkExpressionValueIsNotNull((Object)bl2, (String)"Flags.HAS_ANNOTATIONS.get(typeAliasProto.flags)");
        if (bl2.booleanValue()) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable $i$a$1$assert = $receiver$iv = (Iterable)typeAliasProto.getAnnotationList();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ProtoBuf.Annotation annotation2 = (ProtoBuf.Annotation)item$iv$iv;
                object = destination$iv$iv;
                ClassId classId3 = context.getNameResolver().getClassId(it.getId());
                object.add(classId3);
            }
            ClsStubBuildingKt.createAnnotationStubs((List)destination$iv$iv, modifierList);
        }
        StubElement stubElement2 = (StubElement)typeAlias2;
        ProtoBuf.Type type2 = typeAliasProto.getUnderlyingType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"typeAliasProto.underlyingType");
        typeStubBuilder.createTypeReferenceStub((StubElement<? extends PsiElement>)stubElement2, type2);
    }
}

