/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.JarUserDataManager;
import org.jetbrains.kotlin.idea.framework.KotlinJavaScriptLibraryDetectionUtil;
import org.jetbrains.kotlin.js.resolve.JsPlatform;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;
import org.jetbrains.kotlin.serialization.deserialization.MetadataPackageFragment;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/framework/CommonLibraryDetectionUtil;", "", "()V", "getLibraryPlatform", "Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "isKotlinMetadataFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "HasCommonKotlinMetadataInJar", "idea-analysis"})
public final class CommonLibraryDetectionUtil {
    public static final CommonLibraryDetectionUtil INSTANCE;

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final TargetPlatform getLibraryPlatform(@NotNull Library library2) {
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        if (library2 instanceof LibraryEx && ((LibraryEx)library2).isDisposed()) {
            return JvmPlatform.INSTANCE;
        }
        VirtualFile[] virtualFileArray = library2.getFiles(OrderRootType.CLASSES);
        for (int i = 0; i < virtualFileArray.length; ++i) {
            void platform;
            VirtualFile root = virtualFileArray[i];
            ProgressManager.checkCanceled();
            VirtualFile virtualFile2 = JarFileSystem.getInstance().getVirtualFileForJar(root);
            if (virtualFile2 == null) {
                virtualFile2 = root;
            }
            VirtualFile jarRoot = virtualFile2;
            JarUserDataManager.JarBooleanPropertyCounter jarBooleanPropertyCounter = HasCommonKotlinMetadataInJar.INSTANCE;
            VirtualFile virtualFile3 = jarRoot;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"jarRoot");
            Boolean hasCommonMetadata = JarUserDataManager.INSTANCE.hasFileWithProperty(jarBooleanPropertyCounter, virtualFile3);
            if (Intrinsics.areEqual((Object)hasCommonMetadata, (Object)true)) {
                return TargetPlatform.Default.INSTANCE;
            }
            JarUserDataManager.JarBooleanPropertyCounter jarBooleanPropertyCounter2 = KotlinJavaScriptLibraryDetectionUtil.HasKotlinJSMetadataInJar.INSTANCE;
            VirtualFile virtualFile4 = root;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile4, (String)"root");
            Boolean hasJSMetadata = JarUserDataManager.INSTANCE.hasFileWithProperty(jarBooleanPropertyCounter2, virtualFile4);
            if (Intrinsics.areEqual((Object)hasJSMetadata, (Object)true)) {
                return JsPlatform.INSTANCE;
            }
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            VfsUtilCore.processFilesRecursively((VirtualFile)root, (Processor)((Processor)new Processor<VirtualFile>((Ref.ObjectRef)platform){
                final /* synthetic */ Ref.ObjectRef $platform;

                public final boolean process(VirtualFile file2) {
                    if (Intrinsics.areEqual((Object)file2.getFileType(), (Object)JavaClassFileType.INSTANCE)) {
                        this.$platform.element = JvmPlatform.INSTANCE;
                    } else {
                        VirtualFile virtualFile2 = file2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file");
                        if (CommonLibraryDetectionUtil.access$isKotlinMetadataFile(CommonLibraryDetectionUtil.INSTANCE, virtualFile2)) {
                            this.$platform.element = TargetPlatform.Default.INSTANCE;
                        } else {
                            VirtualFile virtualFile3 = file2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"file");
                            if (KotlinJavaScriptLibraryDetectionUtil.INSTANCE.isJsFileWithMetadata(virtualFile3)) {
                                this.$platform.element = JsPlatform.INSTANCE;
                            }
                        }
                    }
                    return (TargetPlatform)this.$platform.element == null;
                }
                {
                    this.$platform = objectRef;
                }
            }));
            TargetPlatform targetPlatform = (TargetPlatform)platform.element;
            if (targetPlatform != null) {
                TargetPlatform targetPlatform2;
                TargetPlatform it = targetPlatform2 = targetPlatform;
                return it;
            }
            objectRef = null;
        }
        return JvmPlatform.INSTANCE;
    }

    private final boolean isKotlinMetadataFile(VirtualFile file2) {
        return !file2.isDirectory() && Intrinsics.areEqual((Object)file2.getExtension(), (Object)MetadataPackageFragment.Companion.getMETADATA_FILE_EXTENSION());
    }

    private CommonLibraryDetectionUtil() {
        INSTANCE = this;
    }

    static {
        new CommonLibraryDetectionUtil();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/framework/CommonLibraryDetectionUtil$HasCommonKotlinMetadataInJar;", "Lorg/jetbrains/kotlin/idea/caches/JarUserDataManager$JarBooleanPropertyCounter;", "()V", "hasProperty", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "idea-analysis"})
    public static final class HasCommonKotlinMetadataInJar
    extends JarUserDataManager.JarBooleanPropertyCounter {
        public static final HasCommonKotlinMetadataInJar INSTANCE;

        @Override
        public boolean hasProperty(@NotNull VirtualFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            return INSTANCE.isKotlinMetadataFile(file2);
        }

        private HasCommonKotlinMetadataInJar() {
            String string = Reflection.getOrCreateKotlinClass(HasCommonKotlinMetadataInJar.class).getSimpleName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            super(string);
            INSTANCE = this;
        }

        static {
            new HasCommonKotlinMetadataInJar();
        }
    }
}

