/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.JarUserDataManager;
import org.jetbrains.kotlin.idea.framework.JavaRuntimeDetectionUtil;
import org.jetbrains.kotlin.idea.framework.KotlinJavaScriptLibraryDetectionUtil;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0016\u0010\u0007\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/framework/KotlinJavaScriptLibraryDetectionUtil;", "", "()V", "isJsFileWithMetadata", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isKotlinJavaScriptLibrary", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "classesRoots", "", "HasKotlinJSMetadataInJar", "idea-analysis"})
public final class KotlinJavaScriptLibraryDetectionUtil {
    public static final KotlinJavaScriptLibraryDetectionUtil INSTANCE;

    @JvmStatic
    public static final boolean isKotlinJavaScriptLibrary(@NotNull Library library2) {
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        if (library2 instanceof LibraryEx && ((LibraryEx)library2).isDisposed()) {
            return false;
        }
        return KotlinJavaScriptLibraryDetectionUtil.isKotlinJavaScriptLibrary(ArraysKt.toList((Object[])library2.getFiles(OrderRootType.CLASSES)));
    }

    @JvmStatic
    public static final boolean isKotlinJavaScriptLibrary(@NotNull List<? extends VirtualFile> classesRoots) {
        Intrinsics.checkParameterIsNotNull(classesRoots, (String)"classesRoots");
        if (JavaRuntimeDetectionUtil.getRuntimeJar(classesRoots) != null) {
            return false;
        }
        Iterable $receiver$iv = classesRoots;
        for (Object element$iv : $receiver$iv) {
            VirtualFile root = (VirtualFile)element$iv;
            ProgressManager.checkCanceled();
            Boolean hasMetadata = HasKotlinJSMetadataInJar.INSTANCE.hasMetadataFromCache(root);
            if (hasMetadata != null) {
                return hasMetadata;
            }
            if (VfsUtilCore.processFilesRecursively((VirtualFile)root, (Processor)isKotlinJavaScriptLibrary.1.1.INSTANCE)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isJsFileWithMetadata(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (file2.isDirectory()) return false;
        if (!Intrinsics.areEqual((Object)"js", (Object)file2.getExtension())) return false;
        byte[] byArray = file2.contentsToByteArray(false);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"file.contentsToByteArray(false)");
        byte[] byArray2 = byArray;
        if (!KotlinJavascriptMetadataUtils.hasMetadata(new String(byArray2, Charsets.UTF_8))) return false;
        return true;
    }

    private KotlinJavaScriptLibraryDetectionUtil() {
        INSTANCE = this;
    }

    static {
        new KotlinJavaScriptLibraryDetectionUtil();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/framework/KotlinJavaScriptLibraryDetectionUtil$HasKotlinJSMetadataInJar;", "Lorg/jetbrains/kotlin/idea/caches/JarUserDataManager$JarBooleanPropertyCounter;", "()V", "hasMetadataFromCache", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/Boolean;", "hasProperty", "file", "idea-analysis"})
    public static final class HasKotlinJSMetadataInJar
    extends JarUserDataManager.JarBooleanPropertyCounter {
        public static final HasKotlinJSMetadataInJar INSTANCE;

        @Override
        public boolean hasProperty(@NotNull VirtualFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            return INSTANCE.isJsFileWithMetadata(file2);
        }

        @Nullable
        public final Boolean hasMetadataFromCache(@NotNull VirtualFile root) {
            Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
            return JarUserDataManager.INSTANCE.hasFileWithProperty(INSTANCE, root);
        }

        private HasKotlinJSMetadataInJar() {
            String string = Reflection.getOrCreateKotlinClass(HasKotlinJSMetadataInJar.class).getSimpleName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            super(string);
            INSTANCE = this;
        }

        static {
            new HasKotlinJSMetadataInJar();
        }
    }
}

