/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.execution.testframework.TestIconMapper;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.Function;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.highlighter.KotlinTestRunLineMarkerContributor;
import org.jetbrains.kotlin.idea.highlighter.KotlinTestRunLineMarkerContributor$WhenMappings;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinTestRunLineMarkerContributor;", "Lcom/intellij/execution/lineMarker/RunLineMarkerContributor;", "()V", "getInfo", "Lcom/intellij/execution/lineMarker/RunLineMarkerContributor$Info;", "element", "Lcom/intellij/psi/PsiElement;", "getTestStateIcon", "Ljavax/swing/Icon;", "url", "", "project", "Lcom/intellij/openapi/project/Project;", "idea"})
public final class KotlinTestRunLineMarkerContributor
extends RunLineMarkerContributor {
    /*
     * Enabled aggressive block sorting
     */
    private final Icon getTestStateIcon(String url, Project project) {
        Icon icon;
        TestStateInfo.Magnitude magnitude;
        Icon defaultIcon = AllIcons.RunConfigurations.TestState.Run;
        TestStateStorage.Record record2 = TestStateStorage.getInstance((Project)project).getState(url);
        if (record2 == null) return defaultIcon;
        TestStateStorage.Record state = record2;
        TestStateInfo.Magnitude magnitude2 = magnitude = TestIconMapper.getMagnitude((int)state.magnitude);
        if (magnitude2 != null) {
            switch (KotlinTestRunLineMarkerContributor$WhenMappings.$EnumSwitchMapping$0[magnitude2.ordinal()]) {
                case 1: 
                case 2: {
                    icon = AllIcons.RunConfigurations.TestState.Red2;
                    return icon;
                }
                case 3: 
                case 4: {
                    icon = AllIcons.RunConfigurations.TestState.Green2;
                    return icon;
                }
            }
        }
        icon = defaultIcon;
        return icon;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement element2) {
        void url;
        Pair pair2;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        PsiElement $receiver$iv = element2;
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtNamedDeclaration.class, (boolean)true);
        if (ktNamedDeclaration == null) {
            return null;
        }
        KtNamedDeclaration declaration2 = ktNamedDeclaration;
        if (Intrinsics.areEqual((Object)declaration2.getNameIdentifier(), (Object)element2) ^ true) {
            return null;
        }
        if (!(declaration2 instanceof KtClassOrObject) && !(declaration2 instanceof KtNamedFunction)) {
            return null;
        }
        if (ResolutionUtils.resolveToDescriptorIfAny$default(declaration2, null, 1, null) == null) {
            return null;
        }
        Project project = element2.getProject();
        KtNamedDeclaration ktNamedDeclaration2 = declaration2;
        if (ktNamedDeclaration2 instanceof KtClassOrObject) {
            KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)declaration2);
            if (ktLightClass == null) {
                return null;
            }
            KtLightClass lightClass2 = ktLightClass;
            TestFramework testFramework = TestFrameworks.detectFramework((PsiClass)lightClass2);
            if (testFramework == null) {
                return null;
            }
            TestFramework framework = testFramework;
            if (!framework.isTestClass((PsiElement)lightClass2)) {
                return null;
            }
            String string = lightClass2.getQualifiedName();
            if (string == null) {
                return null;
            }
            String qualifiedName2 = string;
            pair2 = TuplesKt.to((Object)("java:suite://" + qualifiedName2), (Object)framework);
        } else if (ktNamedDeclaration2 instanceof KtNamedFunction) {
            PsiMethod psiMethod2 = (PsiMethod)CollectionsKt.firstOrNull(LightClassUtilsKt.toLightMethods(declaration2));
            if (psiMethod2 == null) {
                return null;
            }
            PsiMethod lightMethod = psiMethod2;
            PsiClass psiClass2 = lightMethod.getContainingClass();
            if (!(psiClass2 instanceof KtLightClass)) {
                psiClass2 = null;
            }
            KtLightClass ktLightClass = (KtLightClass)psiClass2;
            if (ktLightClass == null) {
                return null;
            }
            KtLightClass lightClass3 = ktLightClass;
            TestFramework testFramework = TestFrameworks.detectFramework((PsiClass)lightClass3);
            if (testFramework == null) {
                return null;
            }
            TestFramework framework = testFramework;
            if (!framework.isTestMethod((PsiElement)lightMethod)) {
                return null;
            }
            pair2 = TuplesKt.to((Object)("java:test://" + lightClass3.getQualifiedName() + "." + lightMethod.getName()), (Object)framework);
        } else {
            return null;
        }
        Pair pair3 = pair2;
        String $i$f$getStrictParentOfType = (String)pair3.component1();
        TestFramework testFramework = (TestFramework)pair3.component2();
        pair3 = null;
        Project project2 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        Icon icon = this.getTestStateIcon((String)url, project2);
        if (icon == null) {
            void framework;
            Icon icon2 = framework.getIcon();
            icon = icon2;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"framework.icon");
        }
        Icon icon3 = icon;
        return new RunLineMarkerContributor.Info(icon3, (Function)getInfo.1.INSTANCE, ExecutorAction.Companion.getActions(1));
    }
}

