/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.gradle;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.inspections.gradle.DifferentStdlibGradleVersionInspectionKt;
import org.jetbrains.kotlin.idea.inspections.gradle.KotlinGradleInspectionVisitor;
import org.jetbrains.kotlin.idea.inspections.gradle.KotlinGradleInspectionVisitorKt;
import org.jetbrains.kotlin.idea.inspections.gradle.NodeWithData;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.plugins.gradle.codeInspection.GradleBaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000b2\u00020\u0001:\u0003\u000b\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007H\u0014\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentStdlibGradleVersionInspection;", "Lorg/jetbrains/plugins/gradle/codeInspection/GradleBaseInspection;", "()V", "buildErrorString", "", "args", "", "", "([Ljava/lang/Object;)Ljava/lang/String;", "buildVisitor", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor;", "Companion", "MyVisitor", "VersionFinder", "idea"})
public final class DifferentStdlibGradleVersionInspection
extends GradleBaseInspection {
    @NotNull
    private static final List<String> COMPILE_DEPENDENCY_STATEMENTS;
    public static final Companion Companion;

    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new MyVisitor(CollectionsKt.listOf((Object[])new String[]{KotlinRuntimeLibraryUtilKt.getMAVEN_STDLIB_ID(), KotlinRuntimeLibraryUtilKt.getMAVEN_STDLIB_ID_JRE7(), KotlinRuntimeLibraryUtilKt.getMAVEN_STDLIB_ID_JRE8()}));
    }

    @NotNull
    protected String buildErrorString(Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        return "Plugin version (" + args[0] + ") is not the same as library version (" + args[1] + ")";
    }

    static {
        Companion = new Companion(null);
        COMPILE_DEPENDENCY_STATEMENTS = CollectionsKt.listOf((Object[])new String[]{"classpath", "compile"});
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH$J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentStdlibGradleVersionInspection$VersionFinder;", "Lorg/jetbrains/kotlin/idea/inspections/gradle/KotlinGradleInspectionVisitor;", "libraryIds", "", "", "(Ljava/util/List;)V", "onFound", "", "stdlibVersion", "stdlibStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "visitClosure", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "idea"})
    private static abstract class VersionFinder
    extends KotlinGradleInspectionVisitor {
        private final List<String> libraryIds;

        protected abstract void onFound(@NotNull String var1, @NotNull GrCallExpression var2);

        public void visitClosure(@NotNull GrClosableBlock closure) {
            Intrinsics.checkParameterIsNotNull((Object)closure, (String)"closure");
            super.visitClosure(closure);
            PsiElement $receiver$iv = (PsiElement)closure;
            GrMethodCall grMethodCall = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, GrMethodCall.class, (boolean)true);
            if (grMethodCall == null) {
                return;
            }
            GrMethodCall dependenciesCall = grMethodCall;
            if (Intrinsics.areEqual((Object)dependenciesCall.getInvokedExpression().getText(), (Object)"dependencies") ^ true) {
                return;
            }
            if (!(dependenciesCall.getParent() instanceof PsiFile)) {
                return;
            }
            GrCallExpression grCallExpression = Companion.findLibraryStatement(closure, "org.jetbrains.kotlin", this.libraryIds);
            if (grCallExpression == null) {
                return;
            }
            GrCallExpression stdlibStatement = grCallExpression;
            PsiFile psiFile = closure.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"closure.containingFile");
            String string = Companion.getResolvedKotlinStdlibVersion(psiFile, this.libraryIds);
            if (string == null) {
                return;
            }
            String stdlibVersion = string;
            this.onFound(stdlibVersion, stdlibStatement);
        }

        public VersionFinder(@NotNull List<String> libraryIds) {
            Intrinsics.checkParameterIsNotNull(libraryIds, (String)"libraryIds");
            this.libraryIds = libraryIds;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentStdlibGradleVersionInspection$MyVisitor;", "Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentStdlibGradleVersionInspection$VersionFinder;", "libraryIds", "", "", "(Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentStdlibGradleVersionInspection;Ljava/util/List;)V", "onFound", "", "stdlibVersion", "stdlibStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "idea"})
    private final class MyVisitor
    extends VersionFinder {
        @Override
        protected void onFound(@NotNull String stdlibVersion, @NotNull GrCallExpression stdlibStatement) {
            Intrinsics.checkParameterIsNotNull((Object)stdlibVersion, (String)"stdlibVersion");
            Intrinsics.checkParameterIsNotNull((Object)stdlibStatement, (String)"stdlibStatement");
            PsiFile psiFile = stdlibStatement.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"stdlibStatement.containingFile");
            String gradlePluginVersion = KotlinGradleInspectionVisitorKt.getResolvedKotlinGradleVersion(psiFile);
            if (Intrinsics.areEqual((Object)stdlibVersion, (Object)gradlePluginVersion) ^ true) {
                this.registerError((PsiElement)stdlibStatement, new Object[]{gradlePluginVersion, stdlibVersion});
            }
        }

        public MyVisitor(List<String> libraryIds) {
            Intrinsics.checkParameterIsNotNull(libraryIds, (String)"libraryIds");
            super(libraryIds);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J \u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentStdlibGradleVersionInspection$Companion;", "", "()V", "COMPILE_DEPENDENCY_STATEMENTS", "", "", "getCOMPILE_DEPENDENCY_STATEMENTS", "()Ljava/util/List;", "findLibraryStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "libraryGroup", "libraryIds", "getKotlinStdlibVersions", "", "gradleFile", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFileBase;", "libraryId", "getResolvedKotlinStdlibVersion", "file", "Lcom/intellij/psi/PsiFile;", "idea"})
    public static final class Companion {
        @NotNull
        public final List<String> getCOMPILE_DEPENDENCY_STATEMENTS() {
            return COMPILE_DEPENDENCY_STATEMENTS;
        }

        @NotNull
        public final Collection<String> getKotlinStdlibVersions(@NotNull GroovyFileBase gradleFile, @NotNull List<String> libraryId) {
            Intrinsics.checkParameterIsNotNull((Object)gradleFile, (String)"gradleFile");
            Intrinsics.checkParameterIsNotNull(libraryId, (String)"libraryId");
            LinkedHashSet versions = new LinkedHashSet();
            VersionFinder visitor2 = new VersionFinder(versions, libraryId, libraryId){
                final /* synthetic */ LinkedHashSet $versions;
                final /* synthetic */ List $libraryId;

                public void visitElement(@NotNull GroovyPsiElement element2) {
                    Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                    element2.acceptChildren((GroovyElementVisitor)this);
                }

                protected void onFound(@NotNull String stdlibVersion, @NotNull GrCallExpression stdlibStatement) {
                    Intrinsics.checkParameterIsNotNull((Object)stdlibVersion, (String)"stdlibVersion");
                    Intrinsics.checkParameterIsNotNull((Object)stdlibStatement, (String)"stdlibStatement");
                    Collection collection = this.$versions;
                    collection.add(stdlibVersion);
                }
                {
                    this.$versions = $captured_local_variable$0;
                    this.$libraryId = $captured_local_variable$1;
                    super($super_call_param$2);
                }
            };
            gradleFile.accept((GroovyElementVisitor)visitor2);
            return versions;
        }

        private final GrCallExpression findLibraryStatement(GrClosableBlock closure, String libraryGroup, List<String> libraryIds) {
            PsiElement $receiver$iv = (PsiElement)closure;
            PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$receiver$iv, GrCallExpression.class);
            if (psiElementArray == null) {
                Object[] elements$iv$iv = new GrCallExpression[0];
                psiElementArray = (PsiElement[])elements$iv$iv;
            }
            GrCallExpression[] applicationStatements = (GrCallExpression[])psiElementArray;
            for (int i = 0; i < applicationStatements.length; ++i) {
                boolean bl;
                GrCallExpression statement2;
                block5: {
                    GrReferenceExpression startExpression;
                    statement2 = applicationStatements[i];
                    Object $receiver$iv2 = (PsiElement)statement2;
                    PsiElement[] psiElementArray2 = PsiTreeUtil.getChildrenOfType((PsiElement)$receiver$iv2, GrReferenceExpression.class);
                    if (psiElementArray2 == null) {
                        Object[] elements$iv$iv = new GrReferenceExpression[0];
                        psiElementArray2 = (PsiElement[])elements$iv$iv;
                    }
                    if ((GrReferenceExpression)ArraysKt.firstOrNull((Object[])psiElementArray2) == null) {
                        continue;
                    }
                    if (!this.getCOMPILE_DEPENDENCY_STATEMENTS().contains(startExpression.getText())) continue;
                    $receiver$iv2 = libraryIds;
                    Iterator iterator2 = $receiver$iv2.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv = iterator2.next();
                        String it = (String)element$iv;
                        if (!StringsKt.contains$default((CharSequence)statement2.getText(), (CharSequence)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
                if (!bl || !StringsKt.contains$default((CharSequence)statement2.getText(), (CharSequence)libraryGroup, (boolean)false, (int)2, null)) continue;
                return statement2;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private final String getResolvedKotlinStdlibVersion(PsiFile file2, List<String> libraryIds) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            DataNode<ProjectData> dataNode = KotlinGradleInspectionVisitorKt.findGradleProjectStructure(file2);
            if (dataNode == null) {
                return null;
            }
            DataNode<ProjectData> projectStructureNode = dataNode;
            Module module = ProjectRootManager.getInstance((Project)file2.getProject()).getFileIndex().getModuleForFile(file2.getVirtualFile());
            if (module == null) {
                return null;
            }
            Module module2 = module;
            Key key = ProjectKeys.MODULE;
            Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"ProjectKeys.MODULE");
            Iterable iterable = $receiver$iv = (Iterable)KotlinGradleInspectionVisitorKt.findAll(projectStructureNode, key);
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                NodeWithData it = (NodeWithData)element$iv$iv;
                if (!Intrinsics.areEqual((Object)((ModuleData)it.getData()).getInternalName(), (Object)module2.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (NodeWithData moduleData : (List)destination$iv$iv) {
                String string;
                String string2 = DifferentStdlibGradleVersionInspectionKt.getResolvedKotlinStdlibVersionByModuleData(moduleData.getNode(), libraryIds);
                if (string2 == null) continue;
                String it = string = string2;
                return it;
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

