/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.project;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.event.PomModelListener;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.project.KotlinCodeBlockModificationListenerKt;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/project/KotlinCodeBlockModificationListener;", "", "modificationTracker", "Lcom/intellij/psi/util/PsiModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "treeAspect", "Lcom/intellij/pom/tree/TreeAspect;", "(Lcom/intellij/psi/util/PsiModificationTracker;Lcom/intellij/openapi/project/Project;Lcom/intellij/pom/tree/TreeAspect;)V", "Companion", "idea-analysis"})
public final class KotlinCodeBlockModificationListener {
    private final TreeAspect treeAspect;
    private static final Class<? extends KtDeclaration>[] BLOCK_DECLARATION_TYPES;
    public static final Companion Companion;

    public KotlinCodeBlockModificationListener(@NotNull PsiModificationTracker modificationTracker2, @NotNull Project project, @NotNull TreeAspect treeAspect) {
        Intrinsics.checkParameterIsNotNull((Object)modificationTracker2, (String)"modificationTracker");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)treeAspect, (String)"treeAspect");
        this.treeAspect = treeAspect;
        PomModel model = PomManager.getModel((Project)project);
        final PsiModificationTrackerImpl modificationTracker3 = (PsiModificationTrackerImpl)modificationTracker2;
        model.addModelListener(new PomModelListener(){

            public boolean isAspectChangeInteresting(@NotNull PomModelAspect aspect) {
                Intrinsics.checkParameterIsNotNull((Object)aspect, (String)"aspect");
                return Intrinsics.areEqual((Object)aspect, (Object)treeAspect);
            }

            public void modelChanged(@NotNull PomModelEvent event) {
                boolean bl;
                KtFile file2;
                block6: {
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    TreeChangeEvent treeChangeEvent = (TreeChangeEvent)event.getChangeSet((PomModelAspect)treeAspect);
                    if (treeChangeEvent == null) {
                        return;
                    }
                    TreeChangeEvent changeSet = treeChangeEvent;
                    PsiFile psiFile = changeSet.getRootElement().getPsi().getContainingFile();
                    if (!(psiFile instanceof KtFile)) {
                        psiFile = null;
                    }
                    KtFile ktFile = (KtFile)psiFile;
                    if (ktFile == null) {
                        return;
                    }
                    file2 = ktFile;
                    Object[] $receiver$iv = changeSet.getChangedElements();
                    for (int i = 0; i < $receiver$iv.length; ++i) {
                        Object element$iv = $receiver$iv[i];
                        ASTNode it = (ASTNode)element$iv;
                        PsiElement psiElement2 = it.getPsi();
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"it.psi");
                        if (!(!Companion.isInsideCodeBlock(psiElement2))) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
                if (bl) {
                    if (file2.isPhysical()) {
                        modificationTracker3.incCounter();
                    }
                    Companion.incOutOfBlockModificationCount(file2);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        Companion = new Companion(null);
        Object[] elements$iv = new Class[]{KtProperty.class, KtNamedFunction.class};
        BLOCK_DECLARATION_TYPES = (Class[])var0;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R$\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/project/KotlinCodeBlockModificationListener$Companion;", "", "()V", "BLOCK_DECLARATION_TYPES", "", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getBLOCK_DECLARATION_TYPES", "()[Ljava/lang/Class;", "[Ljava/lang/Class;", "incOutOfBlockModificationCount", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isBlockDeclaration", "", "declaration", "isInsideCodeBlock", "element", "Lcom/intellij/psi/PsiElement;", "idea-analysis"})
    public static final class Companion {
        private final void incOutOfBlockModificationCount(KtFile file2) {
            Long l = (Long)file2.getUserData(KotlinCodeBlockModificationListenerKt.access$getFILE_OUT_OF_BLOCK_MODIFICATION_COUNT$p());
            if (l == null) {
                l = 0L;
            }
            Long count = l;
            file2.putUserData(KotlinCodeBlockModificationListenerKt.access$getFILE_OUT_OF_BLOCK_MODIFICATION_COUNT$p(), count + (long)1);
        }

        private final boolean isInsideCodeBlock(PsiElement element2) {
            boolean bl;
            PsiElement blockDeclaration;
            block11: {
                PsiElement lambda2 = KtPsiUtil.getTopmostParentOfTypes(element2, KtLambdaExpression.class);
                if (lambda2 instanceof KtLambdaExpression && KtPsiUtil.getTopmostParentOfTypes(lambda2, KtSuperTypeCallEntry.class) != null) {
                    return true;
                }
                Class<? extends KtDeclaration>[] classArray = this.getBLOCK_DECLARATION_TYPES();
                PsiElement psiElement2 = KtPsiUtil.getTopmostParentOfTypes(element2, Arrays.copyOf(classArray, classArray.length));
                if (psiElement2 == null) {
                    return false;
                }
                blockDeclaration = psiElement2;
                Sequence<PsiElement> $receiver$iv = PsiUtilsKt.getParents(blockDeclaration);
                for (Object element$iv : $receiver$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    if (!(!(it instanceof KtClassBody) && !(it instanceof KtClassOrObject) && !(it instanceof KtFile))) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
            if (bl) {
                return false;
            }
            PsiElement psiElement3 = blockDeclaration;
            if (psiElement3 instanceof KtNamedFunction) {
                if (((KtNamedFunction)blockDeclaration).hasBlockBody()) {
                    return PsiUtilsKt.isAncestor$default((PsiElement)((KtNamedFunction)blockDeclaration).getBodyExpression(), element2, false, 2, null);
                }
                if (((KtNamedFunction)blockDeclaration).hasDeclaredReturnType()) {
                    return PsiUtilsKt.isAncestor$default((PsiElement)((KtNamedFunction)blockDeclaration).getInitializer(), element2, false, 2, null);
                }
            } else if (psiElement3 instanceof KtProperty) {
                for (KtPropertyAccessor accessor : ((KtProperty)blockDeclaration).getAccessors()) {
                    if (!PsiUtilsKt.isAncestor$default((PsiElement)accessor.getInitializer(), element2, false, 2, null) && !PsiUtilsKt.isAncestor$default((PsiElement)accessor.getBodyExpression(), element2, false, 2, null)) continue;
                    return true;
                }
            } else {
                throw (Throwable)new IllegalStateException();
            }
            return false;
        }

        public final boolean isBlockDeclaration(@NotNull KtDeclaration declaration2) {
            boolean bl;
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                Object[] $receiver$iv = this.getBLOCK_DECLARATION_TYPES();
                for (int i = 0; i < $receiver$iv.length; ++i) {
                    Object element$iv = $receiver$iv[i];
                    Class it = (Class)element$iv;
                    if (!it.isInstance(declaration2)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        private final Class<? extends KtDeclaration>[] getBLOCK_DECLARATION_TYPES() {
            return BLOCK_DECLARATION_TYPES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

