/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.SearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.ProgressUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.quickfix.ChangeSuspendInHierarchyFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.search.declarationsSearch.ClassInheritorsSearchKt;
import org.jetbrains.kotlin.idea.search.declarationsSearch.HierarchySearchRequest;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.substitutions.SubstitutionUtilsKt;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeSuspendInHierarchyFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "element", "addModifier", "", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Z)V", "findAllFunctionToProcess", "", "project", "Lcom/intellij/openapi/project/Project;", "getFamilyName", "", "getText", "invoke", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "startInWriteAction", "Companion", "idea"})
public final class ChangeSuspendInHierarchyFix
extends KotlinQuickFixAction<KtNamedFunction> {
    private final boolean addModifier;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return this.addModifier ? "Add 'suspend' modifier to all functions in hierarchy" : "Remove 'suspend' modifier from all functions in hierarchy";
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<KtNamedFunction> findAllFunctionToProcess(Project project) {
        LinkedHashSet result2 = new LinkedHashSet();
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        KtNamedFunction ktNamedFunction = (KtNamedFunction)this.getElement();
        if (ktNamedFunction == null) {
            return SetsKt.emptySet();
        }
        KtNamedFunction function2 = ktNamedFunction;
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptor$default(function2, null, 1, null);
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
        }
        FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)declarationDescriptor;
        List<FunctionDescriptor> baseFunctionDescriptors = Companion.findTopMostOverriddables(functionDescriptor2);
        Iterable $receiver$iv = baseFunctionDescriptors;
        for (Object element$iv : $receiver$iv) {
            void $receiver$iv2;
            Object object;
            PsiElement baseClass;
            ClassDescriptor baseClassDescriptor;
            FunctionDescriptor baseFunctionDescriptor = (FunctionDescriptor)element$iv;
            DeclarationDescriptor declarationDescriptor2 = baseFunctionDescriptor.getContainingDeclaration();
            if (!(declarationDescriptor2 instanceof ClassDescriptor)) {
                declarationDescriptor2 = null;
            }
            if ((ClassDescriptor)declarationDescriptor2 == null) {
                continue;
            }
            if (DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project, baseClassDescriptor) == null) {
                continue;
            }
            PsiElement psiElement2 = baseClass;
            if (!(psiElement2 instanceof PsiNamedElement)) {
                psiElement2 = null;
            }
            if ((object = (PsiNamedElement)psiElement2) == null || (object = object.getName()) == null) {
                continue;
            }
            Object name2 = object;
            progressIndicator.setText("Looking for class " + (String)name2 + " inheritors...");
            Collection collection = CollectionsKt.listOf((Object)baseClass);
            SearchScope searchScope2 = baseClass.getUseScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)searchScope2, (String)"baseClass.useScope");
            List classes2 = CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)ClassInheritorsSearchKt.searchInheritors(new HierarchySearchRequest(baseClass, searchScope2, false, 4, null))));
            Iterable iterable = classes2;
            Collection destination$iv = result2;
            void $receiver$iv$iv = $receiver$iv2;
            for (Object element$iv$iv : $receiver$iv$iv) {
                KtNamedFunction ktNamedFunction2;
                KtNamedFunction ktNamedFunction3;
                Object element$iv2 = element$iv$iv;
                PsiElement it = (PsiElement)element$iv2;
                PsiElement psiElement3 = LightClassUtilsKt.getUnwrapped(it);
                if (!(psiElement3 instanceof KtClassOrObject)) {
                    psiElement3 = null;
                }
                if ((KtClassOrObject)psiElement3 == null) {
                    ktNamedFunction3 = null;
                } else {
                    KtClassOrObject subClass;
                    DeclarationDescriptor declarationDescriptor3 = ResolutionUtils.resolveToDescriptor$default(subClass, null, 1, null);
                    if (declarationDescriptor3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                    }
                    ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor3;
                    SimpleType simpleType2 = baseClassDescriptor.getDefaultType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"baseClassDescriptor.defaultType");
                    KotlinType kotlinType = simpleType2;
                    SimpleType simpleType3 = classDescriptor.getDefaultType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"classDescriptor.defaultType");
                    if (SubstitutionUtilsKt.getTypeSubstitutor(kotlinType, simpleType3) == null) {
                        ktNamedFunction3 = null;
                    } else {
                        FunctionDescriptor signatureInSubClass;
                        TypeSubstitutor substitutor3;
                        if (baseFunctionDescriptor.substitute(substitutor3) == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
                        }
                        if (org.jetbrains.kotlin.util.DescriptorUtilsKt.findCallableMemberBySignature(classDescriptor, signatureInSubClass, true) == null) {
                            ktNamedFunction3 = null;
                        } else {
                            CallableMemberDescriptor subFunctionDescriptor;
                            PsiElement psiElement4 = KotlinSourceElementKt.getPsi(subFunctionDescriptor.getSource());
                            if (!(psiElement4 instanceof KtNamedFunction)) {
                                psiElement4 = null;
                            }
                            ktNamedFunction3 = (KtNamedFunction)psiElement4;
                        }
                    }
                }
                if (ktNamedFunction3 == null) continue;
                KtNamedFunction it$iv = ktNamedFunction2 = ktNamedFunction3;
                destination$iv.add(it$iv);
            }
        }
        return result2;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Set set = (Set)ProgressUtilKt.runSynchronouslyWithProgress(project, "Analyzing class hierarchy...", true, (Function0)new Function0<Set<? extends KtNamedFunction>>(this, project){
            final /* synthetic */ ChangeSuspendInHierarchyFix this$0;
            final /* synthetic */ Project $project;

            @NotNull
            public final Set<KtNamedFunction> invoke() {
                return (Set)ApplicationUtilsKt.runReadAction((Function0)new Function0<Set<? extends KtNamedFunction>>(this){
                    final /* synthetic */ invoke.functions.1 this$0;

                    @NotNull
                    public final Set<KtNamedFunction> invoke() {
                        return ChangeSuspendInHierarchyFix.access$findAllFunctionToProcess(this.this$0.this$0, this.this$0.$project);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = changeSuspendInHierarchyFix;
                this.$project = project;
                super(0);
            }
        });
        if (set == null) {
            return;
        }
        Set functions2 = set;
        ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(this, functions2){
            final /* synthetic */ ChangeSuspendInHierarchyFix this$0;
            final /* synthetic */ Set $functions;

            public final void invoke() {
                Iterable $receiver$iv = this.$functions;
                for (T element$iv : $receiver$iv) {
                    KtNamedFunction it = (KtNamedFunction)element$iv;
                    if (ChangeSuspendInHierarchyFix.access$getAddModifier$p(this.this$0)) {
                        it.addModifier(KtTokens.SUSPEND_KEYWORD);
                        continue;
                    }
                    it.removeModifier(KtTokens.SUSPEND_KEYWORD);
                }
            }
            {
                this.this$0 = changeSuspendInHierarchyFix;
                this.$functions = set;
                super(0);
            }
        });
    }

    public ChangeSuspendInHierarchyFix(@NotNull KtNamedFunction element2, boolean addModifier2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        super((PsiElement)element2);
        this.addModifier = addModifier2;
    }

    @NotNull
    public static final /* synthetic */ Set access$findAllFunctionToProcess(ChangeSuspendInHierarchyFix $this, @NotNull Project project) {
        return $this.findAllFunctionToProcess(project);
    }

    public static final /* synthetic */ boolean access$getAddModifier$p(ChangeSuspendInHierarchyFix $this) {
        return $this.addModifier;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004*\u00020\tJ \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004*\b\u0012\u0004\u0012\u00020\u000b0\f2\u0006\u0010\r\u001a\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeSuspendInHierarchyFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "findTopMostOverriddables", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getOverridables", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "", "currentDescriptor", "idea"})
    public static final class Companion
    extends KotlinIntentionActionsFactory {
        @NotNull
        public final List<FunctionDescriptor> findTopMostOverriddables(@NotNull FunctionDescriptor $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            HashMap overridablesCache = new HashMap();
            Function1<FunctionDescriptor, List<? extends FunctionDescriptor>> getOverridables$ = new Function1<FunctionDescriptor, List<? extends FunctionDescriptor>>(overridablesCache){
                final /* synthetic */ HashMap $overridablesCache;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<FunctionDescriptor> invoke(@NotNull FunctionDescriptor $receiver) {
                    List list2;
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    Map $receiver$iv = this.$overridablesCache;
                    V value$iv = $receiver$iv.get($receiver);
                    if (value$iv == null) {
                        void $receiver$iv$iv;
                        Iterable $receiver$iv2;
                        DeclarationDescriptor declarationDescriptor = $receiver.getContainingDeclaration();
                        if (!(declarationDescriptor instanceof ClassDescriptorWithResolutionScopes)) {
                            declarationDescriptor = null;
                        }
                        ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = (ClassDescriptorWithResolutionScopes)declarationDescriptor;
                        if (classDescriptorWithResolutionScopes == null) {
                            return CollectionsKt.emptyList();
                        }
                        ClassDescriptorWithResolutionScopes classDescriptor = classDescriptorWithResolutionScopes;
                        Iterable iterable = $receiver$iv2 = (Iterable)DescriptorUtils.getSuperclassDescriptors(classDescriptor);
                        Collection destination$iv$iv = new ArrayList<E>();
                        for (T element$iv$iv : $receiver$iv$iv) {
                            List list3;
                            ClassDescriptor superClassDescriptor = (ClassDescriptor)element$iv$iv;
                            if (!(superClassDescriptor instanceof ClassDescriptorWithResolutionScopes)) {
                                list3 = CollectionsKt.emptyList();
                            } else {
                                MemberScope memberScope2 = ((ClassDescriptorWithResolutionScopes)superClassDescriptor).getUnsubstitutedMemberScope();
                                Name name2 = $receiver.getName();
                                Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"name");
                                Collection<SimpleFunctionDescriptor> candidates2 = memberScope2.getContributedFunctions(name2, NoLookupLocation.FROM_IDE);
                                SimpleType simpleType2 = ((ClassDescriptorWithResolutionScopes)superClassDescriptor).getDefaultType();
                                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"superClassDescriptor.defaultType");
                                KotlinType kotlinType = simpleType2;
                                SimpleType simpleType3 = classDescriptor.getDefaultType();
                                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"classDescriptor.defaultType");
                                if (SubstitutionUtilsKt.getTypeSubstitutor(kotlinType, simpleType3) == null) {
                                    list3 = CollectionsKt.emptyList();
                                } else {
                                    void $receiver$iv$iv2;
                                    Iterable $receiver$iv3;
                                    Iterable iterable2 = $receiver$iv3 = (Iterable)candidates2;
                                    Collection destination$iv$iv2 = new ArrayList<E>();
                                    for (T element$iv$iv2 : $receiver$iv$iv2) {
                                        FunctionDescriptor signature;
                                        TypeSubstitutor substitutor3;
                                        SimpleFunctionDescriptor it = (SimpleFunctionDescriptor)element$iv$iv2;
                                        if (it.substitute(substitutor3) == null) {
                                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
                                        }
                                        if (!Intrinsics.areEqual((Object)org.jetbrains.kotlin.util.DescriptorUtilsKt.findCallableMemberBySignature(classDescriptor, signature, true), (Object)$receiver)) continue;
                                        destination$iv$iv2.add(element$iv$iv2);
                                    }
                                    list3 = (List)destination$iv$iv2;
                                }
                            }
                            Iterable list$iv$iv = list3;
                            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                        }
                        List answer$iv = (List)destination$iv$iv;
                        $receiver$iv.put($receiver, answer$iv);
                        list2 = answer$iv;
                    } else {
                        void var3_3;
                        list2 = var3_3;
                    }
                    return list2;
                }
                {
                    this.$overridablesCache = hashMap;
                    super(1);
                }
            };
            Object r = DFS.dfs(CollectionsKt.listOf((Object)$receiver), new DFS.Neighbors<N>(getOverridables$){
                final /* synthetic */ findTopMostOverriddables.1 $getOverridables;

                @NotNull
                public final Iterable<FunctionDescriptor> getNeighbors(FunctionDescriptor it) {
                    Object object;
                    Object object2 = it;
                    if (!(object2 instanceof FunctionDescriptor)) {
                        object2 = object = null;
                    }
                    return object2 != null && (object = this.$getOverridables.invoke((FunctionDescriptor)object)) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList();
                }
                {
                    this.$getOverridables = var1_1;
                }
            }, (DFS.NodeHandler)new DFS.CollectingNodeHandler<FunctionDescriptor, FunctionDescriptor, ArrayList<FunctionDescriptor>>(getOverridables$, (Iterable)new ArrayList()){
                final /* synthetic */ findTopMostOverriddables.1 $getOverridables;

                public void afterChildren(@NotNull FunctionDescriptor current) {
                    Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                    if (this.$getOverridables.invoke(current).isEmpty()) {
                        ((ArrayList)this.result).add(current);
                    }
                }
                {
                    this.$getOverridables = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            });
            Intrinsics.checkExpressionValueIsNotNull(r, (String)"DFS.dfs(\n               \u2026 }\n                    })");
            return (List)r;
        }

        /*
         * WARNING - void declaration
         */
        private final List<DeclarationDescriptor> getOverridables(@NotNull Collection<? extends DeclarationDescriptor> $receiver, FunctionDescriptor currentDescriptor2) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            DeclarationDescriptor declarationDescriptor = currentDescriptor2.getContainingDeclaration();
            if (!(declarationDescriptor instanceof ClassDescriptor)) {
                declarationDescriptor = null;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
            if (classDescriptor == null) {
                return CollectionsKt.emptyList();
            }
            ClassDescriptor currentClassDescriptor = classDescriptor;
            Iterable iterable = $receiver$iv = (Iterable)$receiver;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                boolean bl;
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv$iv;
                if (!(it instanceof FunctionDescriptor) || Intrinsics.areEqual((Object)it, (Object)currentDescriptor2)) {
                    bl = false;
                } else if (((FunctionDescriptor)it).isSuspend() == currentDescriptor2.isSuspend()) {
                    bl = false;
                } else {
                    ClassDescriptor containingClassDescriptor;
                    DeclarationDescriptor declarationDescriptor2 = ((FunctionDescriptor)it).getContainingDeclaration();
                    if (!(declarationDescriptor2 instanceof ClassDescriptor)) {
                        declarationDescriptor2 = null;
                    }
                    if ((ClassDescriptor)declarationDescriptor2 == null) {
                        bl = false;
                    } else if (!DescriptorUtilsKt.isSubclassOf(currentClassDescriptor, containingClassDescriptor)) {
                        bl = false;
                    } else {
                        SimpleType simpleType2 = containingClassDescriptor.getDefaultType();
                        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"containingClassDescriptor.defaultType");
                        KotlinType kotlinType = simpleType2;
                        SimpleType simpleType3 = currentClassDescriptor.getDefaultType();
                        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"currentClassDescriptor.defaultType");
                        if (SubstitutionUtilsKt.getTypeSubstitutor(kotlinType, simpleType3) == null) {
                            bl = false;
                        } else {
                            TypeSubstitutor substitutor3;
                            FunctionDescriptor functionDescriptor2 = ((FunctionDescriptor)it).substitute(substitutor3);
                            if (!(functionDescriptor2 instanceof FunctionDescriptor)) {
                                functionDescriptor2 = null;
                            }
                            if (functionDescriptor2 == null) {
                                bl = false;
                            } else {
                                FunctionDescriptor signatureInCurrentClass = functionDescriptor2;
                                bl = Intrinsics.areEqual((Object)((Object)OverridingUtil.DEFAULT.isOverridableBy(signatureInCurrentClass, currentDescriptor2, null).getResult()), (Object)((Object)OverridingUtil.OverrideCompatibilityInfo.Result.CONFLICT));
                            }
                        }
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Override
        @NotNull
        protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (!(psiElement2 instanceof KtNamedFunction)) {
                psiElement2 = null;
            }
            KtNamedFunction ktNamedFunction = (KtNamedFunction)psiElement2;
            if (ktNamedFunction == null) {
                return CollectionsKt.emptyList();
            }
            KtNamedFunction currentFunction = ktNamedFunction;
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptor$default(currentFunction, null, 1, null);
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
            }
            FunctionDescriptor currentDescriptor2 = (FunctionDescriptor)declarationDescriptor;
            Collection $receiver$iv = this.getOverridables((Collection)((DiagnosticWithParameters1)Errors.CONFLICTING_OVERLOADS.cast(diagnostic)).getA(), currentDescriptor2);
            if ($receiver$iv.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            return CollectionsKt.listOf((Object[])new ChangeSuspendInHierarchyFix[]{new ChangeSuspendInHierarchyFix(currentFunction, true), new ChangeSuspendInHierarchyFix(currentFunction, false)});
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

