/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.versions;

import com.intellij.framework.library.LibraryVersionProperties;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.framework.JSLibraryStdPresentationProvider;
import org.jetbrains.kotlin.idea.framework.JavaRuntimeDetectionUtil;
import org.jetbrains.kotlin.idea.framework.JavaRuntimePresentationProvider;
import org.jetbrains.kotlin.idea.framework.JsLibraryStdDetectionUtil;
import org.jetbrains.kotlin.idea.framework.KotlinLibraryUtilKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.versions.OutdatedKotlinRuntimeCheckerKt;
import org.jetbrains.kotlin.idea.versions.VersionedLibrary;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u001a\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u001a&\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00052\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\f\u001a\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0002\u001a\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\t\u001a\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\t\u001a\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\t\u001a\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\t\u001a\u0018\u0010\u0018\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001a\u001a\u00020\u0001\u001a\u001c\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u001e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"OUTDATED_RUNTIME_GROUP_DISPLAY_ID", "", "SUPPRESSED_PROPERTY_NAME", "collectModulesWithOutdatedRuntime", "", "Lcom/intellij/openapi/module/Module;", "libraries", "Lorg/jetbrains/kotlin/idea/versions/VersionedLibrary;", "findKotlinRuntimeLibrary", "Lcom/intellij/openapi/roots/libraries/Library;", "module", "predicate", "Lkotlin/Function1;", "", "findOutdatedKotlinLibraries", "project", "Lcom/intellij/openapi/project/Project;", "getKotlinLibraryVersionProperties", "Lcom/intellij/framework/library/LibraryVersionProperties;", "library", "getOutdatedRuntimeLibraryVersion", "isKotlinJavaRuntime", "isKotlinJsRuntime", "isKotlinRuntime", "isRuntimeOutdated", "libraryVersion", "runtimeVersion", "notifyOutdatedKotlinRuntime", "", "outdatedLibraries", "", "idea"})
public final class OutdatedKotlinRuntimeCheckerKt {
    private static final String SUPPRESSED_PROPERTY_NAME = "oudtdated.runtime.suppressed.plugin.version";
    private static final String OUTDATED_RUNTIME_GROUP_DISPLAY_ID = "Outdated Kotlin Runtime";

    @NotNull
    public static final List<VersionedLibrary> findOutdatedKotlinLibraries(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String pluginVersion = KotlinPluginUtil.getPluginVersion();
        if (KotlinPluginUtil.isSnapshotVersion()) {
            return CollectionsKt.emptyList();
        }
        if (Intrinsics.areEqual((Object)pluginVersion, (Object)PropertiesComponent.getInstance((Project)project).getValue(SUPPRESSED_PROPERTY_NAME))) {
            return CollectionsKt.emptyList();
        }
        ArrayList<VersionedLibrary> outdatedLibraries = new ArrayList<VersionedLibrary>();
        for (Map.Entry entry : KotlinRuntimeLibraryUtilKt.findAllUsedLibraries(project).entrySet()) {
            Object object = entry;
            Library library2 = (Library)object.getKey();
            object = entry;
            Collection modules = (Collection)object.getValue();
            Library library3 = library2;
            Intrinsics.checkExpressionValueIsNotNull((Object)library3, (String)"library");
            String string = OutdatedKotlinRuntimeCheckerKt.getOutdatedRuntimeLibraryVersion(library3);
            if (string == null) continue;
            Object version = object = string;
            Library library4 = library2;
            Intrinsics.checkExpressionValueIsNotNull((Object)library4, (String)"library");
            Collection collection = modules;
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"modules");
            outdatedLibraries.add(new VersionedLibrary(library4, (String)version, collection));
        }
        return outdatedLibraries;
    }

    @Nullable
    public static final String getOutdatedRuntimeLibraryVersion(@NotNull Library library2) {
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        LibraryVersionProperties libraryVersionProperties = OutdatedKotlinRuntimeCheckerKt.getKotlinLibraryVersionProperties(library2);
        if (libraryVersionProperties == null) {
            return null;
        }
        LibraryVersionProperties libraryVersionProperties2 = libraryVersionProperties;
        String libraryVersion = libraryVersionProperties2.getVersionString();
        String runtimeVersion = KotlinRuntimeLibraryUtilKt.bundledRuntimeVersion();
        return OutdatedKotlinRuntimeCheckerKt.isRuntimeOutdated(libraryVersion, runtimeVersion) ? libraryVersion : null;
    }

    private static final LibraryVersionProperties getKotlinLibraryVersionProperties(Library library2) {
        JavaRuntimePresentationProvider javaRuntimePresentationProvider = JavaRuntimePresentationProvider.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)javaRuntimePresentationProvider), (String)"JavaRuntimePresentationProvider.getInstance()");
        LibraryVersionProperties libraryVersionProperties = (LibraryVersionProperties)KotlinLibraryUtilKt.getLibraryProperties(javaRuntimePresentationProvider, library2);
        if (libraryVersionProperties == null) {
            JSLibraryStdPresentationProvider jSLibraryStdPresentationProvider = JSLibraryStdPresentationProvider.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)jSLibraryStdPresentationProvider), (String)"JSLibraryStdPresentationProvider.getInstance()");
            libraryVersionProperties = (LibraryVersionProperties)KotlinLibraryUtilKt.getLibraryProperties(jSLibraryStdPresentationProvider, library2);
        }
        return libraryVersionProperties;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Library findKotlinRuntimeLibrary(@NotNull Module module, @NotNull Function1<? super Library, Boolean> predicate2) {
        Object v0;
        block2: {
            void $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull(predicate2, (String)"predicate");
            Sequence $receiver$iv = (Sequence)ModuleRootManager.getInstance((Module)module).getOrderEntries();
            Sequence sequence2 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                void element$iv$iv = $receiver$iv$iv[i];
                if (!(element$iv$iv instanceof LibraryOrderEntry)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List orderEntries = (List)destination$iv$iv;
            $receiver$iv = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)orderEntries), (Function1)findKotlinRuntimeLibrary.2.INSTANCE);
            for (Object element$iv : $receiver$iv) {
                if (!((Boolean)predicate2.invoke(element$iv)).booleanValue()) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Library findKotlinRuntimeLibrary$default(Module module, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = findKotlinRuntimeLibrary.1.INSTANCE;
        }
        return OutdatedKotlinRuntimeCheckerKt.findKotlinRuntimeLibrary(module, (Function1<? super Library, Boolean>)function1);
    }

    public static final boolean isKotlinRuntime(@NotNull Library library2) {
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        return OutdatedKotlinRuntimeCheckerKt.isKotlinJavaRuntime(library2) || OutdatedKotlinRuntimeCheckerKt.isKotlinJsRuntime(library2);
    }

    public static final boolean isKotlinJavaRuntime(@NotNull Library library2) {
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        return JavaRuntimeDetectionUtil.getRuntimeJar(ArraysKt.asList((Object[])library2.getFiles(OrderRootType.CLASSES))) != null;
    }

    public static final boolean isKotlinJsRuntime(@NotNull Library library2) {
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        return JsLibraryStdDetectionUtil.INSTANCE.getJsStdLibJar(ArraysKt.asList((Object[])library2.getFiles(OrderRootType.CLASSES))) != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Module> collectModulesWithOutdatedRuntime(@NotNull List<VersionedLibrary> libraries) {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(libraries, (String)"libraries");
        Iterable iterable = $receiver$iv = (Iterable)libraries;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            VersionedLibrary it = (VersionedLibrary)element$iv$iv;
            Iterable list$iv$iv = it.getUsedInModules();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)var3_3;
    }

    public static final void notifyOutdatedKotlinRuntime(@NotNull Project project, @NotNull Collection<VersionedLibrary> outdatedLibraries) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(outdatedLibraries, (String)"outdatedLibraries");
        String pluginVersion = KotlinPluginUtil.getPluginVersion();
        if (outdatedLibraries.size() == 1) {
            VersionedLibrary versionedLibrary = (VersionedLibrary)CollectionsKt.first((Iterable)outdatedLibraries);
            String version = versionedLibrary.getVersion();
            String string2 = version;
            if (string2 == null) {
                string2 = "unknown";
            }
            String readableVersion = string2;
            String libraryName = versionedLibrary.getLibrary().getName();
            string = "<p>Your version of Kotlin runtime in '" + libraryName + "' library is " + readableVersion + ", while plugin version is " + pluginVersion + ".</p>" + "<p>Runtime library should be updated to avoid compatibility problems.</p>" + "<p><a href=\"update\">Update Runtime</a> <a href=\"ignore\">Ignore</a></p>";
        } else {
            String libraryNames2 = CollectionsKt.joinToString$default((Iterable)outdatedLibraries, null, null, null, (int)0, null, (Function1)notifyOutdatedKotlinRuntime.message.libraryNames.1.INSTANCE, (int)31, null);
            string = "<p>Version of Kotlin runtime is outdated in several libraries (" + libraryNames2 + "). Plugin version is " + pluginVersion + ".</p>" + "<p>Runtime libraries should be updated to avoid compatibility problems.</p>" + "<p><a href=\"update\">Update All</a> <a href=\"ignore\">Ignore</a></p>";
        }
        String message2 = string;
        Notifications.Bus.notify((Notification)new Notification(OUTDATED_RUNTIME_GROUP_DISPLAY_ID, OUTDATED_RUNTIME_GROUP_DISPLAY_ID, message2, NotificationType.WARNING, new NotificationListener(project, pluginVersion){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $pluginVersion;

            /*
             * WARNING - void declaration
             */
            public final void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)notification2, (String)"notification");
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                    if (Intrinsics.areEqual((Object)"update", (Object)event.getDescription())) {
                        void $receiver$iv$iv;
                        Iterable $receiver$iv;
                        Iterable iterable = $receiver$iv = (Iterable)OutdatedKotlinRuntimeCheckerKt.findOutdatedKotlinLibraries(this.$project);
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                        for (T item$iv$iv : $receiver$iv$iv) {
                            void it;
                            VersionedLibrary versionedLibrary = (VersionedLibrary)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            Library library2 = it.getLibrary();
                            collection.add(library2);
                        }
                        List outdatedLibraries = (List)destination$iv$iv;
                        ApplicationManager.getApplication().invokeLater(new Runnable(this, outdatedLibraries){
                            final /* synthetic */ notifyOutdatedKotlinRuntime.1 this$0;
                            final /* synthetic */ List $outdatedLibraries;

                            public final void run() {
                                KotlinRuntimeLibraryUtilKt.updateLibraries(this.this$0.$project, this.$outdatedLibraries);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$outdatedLibraries = list2;
                            }
                        });
                    } else if (Intrinsics.areEqual((Object)"ignore", (Object)event.getDescription())) {
                        PropertiesComponent.getInstance((Project)this.$project).setValue(OutdatedKotlinRuntimeCheckerKt.access$getSUPPRESSED_PROPERTY_NAME$p(), this.$pluginVersion);
                    } else {
                        throw (Throwable)((Object)new AssertionError());
                    }
                    notification2.expire();
                }
            }
            {
                this.$project = project;
                this.$pluginVersion = string;
            }
        }), (Project)project);
    }

    public static final boolean isRuntimeOutdated(@Nullable String libraryVersion, @NotNull String runtimeVersion) {
        Intrinsics.checkParameterIsNotNull((Object)runtimeVersion, (String)"runtimeVersion");
        return libraryVersion == null || StringsKt.startsWith$default((String)libraryVersion, (String)"internal-", (boolean)false, (int)2, null) != StringsKt.startsWith$default((String)runtimeVersion, (String)"internal-", (boolean)false, (int)2, null) || VersionComparatorUtil.compare((String)StringsKt.substringBefore$default((String)runtimeVersion, (String)"-release-", null, (int)2, null), (String)libraryVersion) > 0;
    }

    static {
        SUPPRESSED_PROPERTY_NAME = SUPPRESSED_PROPERTY_NAME;
        OUTDATED_RUNTIME_GROUP_DISPLAY_ID = OUTDATED_RUNTIME_GROUP_DISPLAY_ID;
    }

    @NotNull
    public static final /* synthetic */ String access$getSUPPRESSED_PROPERTY_NAME$p() {
        return SUPPRESSED_PROPERTY_NAME;
    }
}

