/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.EmptyIntHashSet;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntProcedure;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class InvertedIndexUtil {
    @NotNull
    public static <K, V, I> TIntHashSet collectInputIdsContainingAllKeys(@NotNull InvertedIndex<K, V, I> index, @NotNull Collection<K> dataKeys, @Nullable Condition<K> keyChecker, @Nullable Condition<V> valueChecker, @Nullable ValueContainer.IntPredicate idChecker) throws StorageException {
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/util/indexing/InvertedIndexUtil", "collectInputIdsContainingAllKeys"));
        }
        if (dataKeys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataKeys", "com/intellij/util/indexing/InvertedIndexUtil", "collectInputIdsContainingAllKeys"));
        }
        TIntHashSet mainIntersection = null;
        for (K dataKey : dataKeys) {
            if (keyChecker != null && !keyChecker.value(dataKey)) continue;
            final TIntHashSet copy = new TIntHashSet();
            ValueContainer<V> container = index.getData(dataKey);
            ValueContainer.ValueIterator<V> valueIt = container.getValueIterator();
            while (valueIt.hasNext()) {
                ValueContainer.IntPredicate predicate;
                Object value = valueIt.next();
                if (valueChecker != null && !valueChecker.value(value)) continue;
                ValueContainer.IntIterator iterator = valueIt.getInputIdsIterator();
                if (mainIntersection == null || iterator.size() < mainIntersection.size() || (predicate = valueIt.getValueAssociationPredicate()) == null) {
                    while (iterator.hasNext()) {
                        int id = iterator.next();
                        if ((mainIntersection != null || idChecker != null && !idChecker.contains(id)) && (mainIntersection == null || !mainIntersection.contains(id))) continue;
                        copy.add(id);
                    }
                    continue;
                }
                mainIntersection.forEach(new TIntProcedure(){

                    public boolean execute(int id) {
                        if (predicate.contains(id)) {
                            copy.add(id);
                        }
                        return true;
                    }
                });
            }
            mainIntersection = copy;
            if (!mainIntersection.isEmpty()) continue;
            TIntHashSet tIntHashSet = EmptyIntHashSet.INSTANCE;
            if (tIntHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/InvertedIndexUtil", "collectInputIdsContainingAllKeys"));
            }
            return tIntHashSet;
        }
        TIntHashSet tIntHashSet = mainIntersection == null ? EmptyIntHashSet.INSTANCE : mainIntersection;
        if (tIntHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/InvertedIndexUtil", "collectInputIdsContainingAllKeys"));
        }
        return tIntHashSet;
    }
}

