/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.scout;

import android.support.constraint.solver.widgets.ConstraintWidget;
import com.android.tools.sherpa.scout.Utils;

public class ScoutGroup {
    int[][] bounds;
    int mRows;
    int mCols;
    int[] mColAlign;
    boolean mSupported = true;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;
    private static final int ALIGN_CENTER = 0;

    ScoutGroup(ConstraintWidget[] widgets) {
        this.bounds = new int[4][widgets.length];
        for (int i = 0; i < widgets.length; ++i) {
            ConstraintWidget widget = widgets[i];
            this.bounds[0][i] = widget.getY();
            this.bounds[1][i] = this.bounds[0][i] + widget.getHeight();
            this.bounds[2][i] = widget.getX();
            this.bounds[3][i] = this.bounds[2][i] + widget.getWidth();
        }
        this.mRows = Utils.gaps(this.bounds[0], this.bounds[1]);
        this.mCols = Utils.gaps(this.bounds[2], this.bounds[3]);
        int[] r = Utils.cells(this.bounds[0], this.bounds[1]);
        int[] c = Utils.cells(this.bounds[2], this.bounds[3]);
        ConstraintWidget[][] table = new ConstraintWidget[this.mCols][this.mRows];
        for (ConstraintWidget widget : widgets) {
            int row = Utils.getPosition(r, widget.getY(), widget.getY() + widget.getHeight());
            int col = Utils.getPosition(c, widget.getX(), widget.getX() + widget.getWidth());
            if (row == -1 || col == -1) {
                this.mSupported = false;
                return;
            }
            table[col][row] = widget;
        }
        int skip = 0;
        for (int row = 0; row < this.mRows; ++row) {
            for (int col = 0; col < this.mCols; ++col) {
                if (table[col][row] == null) {
                    ++skip;
                    continue;
                }
                if (skip > 0) {
                    table[col][row].setContainerItemSkip(skip);
                    skip = 0;
                    continue;
                }
                table[col][row].setContainerItemSkip(0);
            }
        }
        this.mColAlign = new int[this.mCols];
        for (int i = 0; i < table.length; ++i) {
            ConstraintWidget[] constraintWidgets = table[i];
            this.mColAlign[i] = ScoutGroup.inferAlignment(constraintWidgets);
        }
    }

    private static int inferAlignment(ConstraintWidget[] widget) {
        float[] start = new float[widget.length];
        float[] center = new float[widget.length];
        float[] end = new float[widget.length];
        for (int i = 0; i < end.length; ++i) {
            if (widget[i] == null) {
                start[i] = Float.NaN;
                end[i] = Float.NaN;
                center[i] = Float.NaN;
                continue;
            }
            start[i] = widget[i].getX();
            end[i] = start[i] + (float)widget[i].getWidth();
            center[i] = (start[i] + end[i]) / 2.0f;
        }
        float startDiv = ScoutGroup.standardDeviation(start);
        float centerDiv = ScoutGroup.standardDeviation(center);
        float endDiv = ScoutGroup.standardDeviation(end);
        if (endDiv > startDiv && centerDiv > startDiv) {
            return 1;
        }
        if (startDiv > endDiv && centerDiv > endDiv) {
            return 2;
        }
        return 0;
    }

    private static float standardDeviation(float[] pos) {
        float sum = 0.0f;
        float sumSqr = 0.0f;
        int count = 0;
        for (float po : pos) {
            if (Float.isNaN(po)) continue;
            ++count;
            sum += po;
            sumSqr += po * po;
        }
        return (float)Math.sqrt(sumSqr / (float)count - sum / (float)count * (sum / (float)count));
    }
}

