/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.lang.ant.segments.Extractor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.io.BaseOutputReader;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;

public class AntProcessHandler
extends KillableColoredProcessHandler {
    private final Extractor myOut;
    private final Extractor myErr;

    private AntProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/lang/ant/config/execution/AntProcessHandler", "<init>"));
        }
        super(commandLine);
        this.myOut = new Extractor(this.getProcess().getInputStream(), commandLine.getCharset());
        this.myErr = new Extractor(this.getProcess().getErrorStream(), commandLine.getCharset());
        this.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                Disposer.dispose((Disposable)AntProcessHandler.this.myOut);
                Disposer.dispose((Disposable)AntProcessHandler.this.myErr);
            }
        });
    }

    @NotNull
    protected Reader createProcessOutReader() {
        Reader reader = this.myOut.createReader();
        if (reader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/config/execution/AntProcessHandler", "createProcessOutReader"));
        }
        return reader;
    }

    @NotNull
    protected Reader createProcessErrReader() {
        Reader reader = this.myErr.createReader();
        if (reader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/config/execution/AntProcessHandler", "createProcessErrReader"));
        }
        return reader;
    }

    @NotNull
    public Extractor getErr() {
        Extractor extractor = this.myErr;
        if (extractor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/config/execution/AntProcessHandler", "getErr"));
        }
        return extractor;
    }

    @NotNull
    public Extractor getOut() {
        Extractor extractor = this.myOut;
        if (extractor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/config/execution/AntProcessHandler", "getOut"));
        }
        return extractor;
    }

    @NotNull
    public static AntProcessHandler runCommandLine(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/lang/ant/config/execution/AntProcessHandler", "runCommandLine"));
        }
        AntProcessHandler processHandler = new AntProcessHandler(commandLine);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        AntProcessHandler antProcessHandler = processHandler;
        if (antProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/config/execution/AntProcessHandler", "runCommandLine"));
        }
        return antProcessHandler;
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        BaseOutputReader.Options options = BaseOutputReader.Options.NON_BLOCKING;
        if (options == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/config/execution/AntProcessHandler", "readerOptions"));
        }
        return options;
    }
}

