/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocatableConfigurationBase
extends RunConfigurationBase
implements LocatableConfiguration {
    private static final String ATTR_NAME_IS_GENERATED = "nameIsGenerated";
    private boolean myNameIsGenerated;

    protected LocatableConfigurationBase(@NotNull Project project, @NotNull ConfigurationFactory factory, String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/configurations/LocatableConfigurationBase", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/execution/configurations/LocatableConfigurationBase", "<init>"));
        }
        super(project, factory, name);
    }

    @Override
    @Attribute(value="nameIsGenerated")
    public boolean isGeneratedName() {
        return this.myNameIsGenerated && this.suggestedName() != null;
    }

    public void setGeneratedName() {
        this.setName(this.suggestedName());
        this.myNameIsGenerated = true;
    }

    public void setNameChangedByUser(boolean nameChangedByUser) {
        this.myNameIsGenerated = !nameChangedByUser;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        if (!this.isNewSerializationUsed()) {
            this.myNameIsGenerated = "true".equals(element.getAttributeValue(ATTR_NAME_IS_GENERATED));
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        if (!this.isNewSerializationUsed() && this.myNameIsGenerated && this.suggestedName() != null) {
            element.setAttribute(ATTR_NAME_IS_GENERATED, "true");
        }
    }

    @Nullable
    public String getActionName() {
        String name = this.getName();
        return name.length() < 20 ? name : name.substring(0, 20) + "...";
    }
}

