/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.util.messages.Topic;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class EditorColorsManager {
    public static final Topic<EditorColorsListener> TOPIC = Topic.create((String)"EditorColorsListener", EditorColorsListener.class);
    @NonNls
    public static final String DEFAULT_SCHEME_NAME = "Default";
    @NonNls
    public static final String COLOR_SCHEME_FILE_EXTENSION = ".icls";

    public static EditorColorsManager getInstance() {
        return ServiceManager.getService(EditorColorsManager.class);
    }

    public abstract void addColorsScheme(@NotNull EditorColorsScheme var1);

    @Deprecated
    public abstract void removeAllSchemes();

    @Deprecated
    public abstract void setSchemes(@NotNull List<EditorColorsScheme> var1);

    @NotNull
    public abstract EditorColorsScheme[] getAllSchemes();

    public abstract void setGlobalScheme(EditorColorsScheme var1);

    @NotNull
    public abstract EditorColorsScheme getGlobalScheme();

    public abstract EditorColorsScheme getScheme(@NotNull String var1);

    public abstract boolean isDefaultScheme(EditorColorsScheme var1);

    @Deprecated
    public final void addEditorColorsListener(@NotNull EditorColorsListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/colors/EditorColorsManager", "addEditorColorsListener"));
        }
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(TOPIC, (Object)listener);
    }

    @Deprecated
    public final void addEditorColorsListener(@NotNull EditorColorsListener listener, @NotNull Disposable disposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/colors/EditorColorsManager", "addEditorColorsListener"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/openapi/editor/colors/EditorColorsManager", "addEditorColorsListener"));
        }
        ApplicationManager.getApplication().getMessageBus().connect(disposable).subscribe(TOPIC, (Object)listener);
    }

    public abstract boolean isUseOnlyMonospacedFonts();

    public abstract void setUseOnlyMonospacedFonts(boolean var1);

    @NotNull
    public EditorColorsScheme getSchemeForCurrentUITheme() {
        EditorColorsScheme editorColorsScheme = this.getGlobalScheme();
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/EditorColorsManager", "getSchemeForCurrentUITheme"));
        }
        return editorColorsScheme;
    }
}

