/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.execution.CantRunException;
import com.intellij.execution.CommandLineWrapperUtil;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.UrlClassLoader;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkUtil {
    public static final String PROPERTY_DO_NOT_ESCAPE_CLASSPATH_URL = "idea.do.not.escape.classpath.url";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.JdkUtil");
    private static final String WRAPPER_CLASS = "com.intellij.rt.execution.CommandLineWrapper";

    private JdkUtil() {
    }

    @Nullable
    public static String getJdkMainAttribute(@NotNull Sdk jdk, @NotNull Attributes.Name attribute) {
        File signatureJar;
        String homePath;
        String versionString;
        if (jdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/intellij/openapi/projectRoots/JdkUtil", "getJdkMainAttribute"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/openapi/projectRoots/JdkUtil", "getJdkMainAttribute"));
        }
        if (attribute == Attributes.Name.IMPLEMENTATION_VERSION && (versionString = jdk.getVersionString()) != null) {
            int start = versionString.indexOf(34);
            int end = versionString.lastIndexOf(34);
            if (start >= 0 && end > start) {
                return versionString.substring(start + 1, end);
            }
        }
        if ((homePath = jdk.getHomePath()) != null && (signatureJar = FileUtil.findFirstThatExist((String[])new String[]{homePath + "/jre/lib/rt.jar", homePath + "/lib/rt.jar", homePath + "/lib/jrt-fs.jar", homePath + "/jre/lib/vm.jar", homePath + "/../Classes/classes.jar"})) != null) {
            return JarUtil.getJarAttribute((File)signatureJar, (Attributes.Name)attribute);
        }
        return null;
    }

    public static boolean checkForJdk(@NotNull String homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/openapi/projectRoots/JdkUtil", "checkForJdk"));
        }
        return JdkUtil.checkForJdk(new File(FileUtil.toSystemDependentName((String)homePath)));
    }

    public static boolean checkForJdk(@NotNull File homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/openapi/projectRoots/JdkUtil", "checkForJdk"));
        }
        File binPath = new File(homePath, "bin");
        if (!binPath.exists()) {
            return false;
        }
        FileFilter fileFilter = f -> {
            if (f.isDirectory()) {
                return false;
            }
            String name = FileUtil.getNameWithoutExtension((File)f);
            return "javac".equals(name) || "javah".equals(name);
        };
        File[] children = binPath.listFiles(fileFilter);
        return children != null && children.length >= 2 && JdkUtil.checkForRuntime(homePath.getAbsolutePath());
    }

    public static boolean checkForJre(@NotNull String homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/openapi/projectRoots/JdkUtil", "checkForJre"));
        }
        return JdkUtil.checkForJre(new File(FileUtil.toSystemDependentName((String)homePath)));
    }

    public static boolean checkForJre(@NotNull File homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/openapi/projectRoots/JdkUtil", "checkForJre"));
        }
        return new File(homePath, "bin/java").isFile() || new File(homePath, "bin/java.exe").isFile();
    }

    public static boolean checkForRuntime(@NotNull String homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/openapi/projectRoots/JdkUtil", "checkForRuntime"));
        }
        return new File(homePath, "jre/lib/rt.jar").exists() || new File(homePath, "lib/rt.jar").exists() || JdkUtil.isModularRuntime(homePath) || new File(homePath, "../Classes/classes.jar").exists() || new File(homePath, "jre/lib/vm.jar").exists() || new File(homePath, "classes").isDirectory();
    }

    public static boolean isModularRuntime(@NotNull String homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/openapi/projectRoots/JdkUtil", "isModularRuntime"));
        }
        return JdkUtil.isModularRuntime(new File(FileUtil.toSystemDependentName((String)homePath)));
    }

    public static boolean isModularRuntime(@NotNull File homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/openapi/projectRoots/JdkUtil", "isModularRuntime"));
        }
        return new File(homePath, "lib/jrt-fs.jar").isFile();
    }

    public static GeneralCommandLine setupJVMCommandLine(@NotNull SimpleJavaParameters javaParameters) throws CantRunException {
        if (javaParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaParameters", "com/intellij/openapi/projectRoots/JdkUtil", "setupJVMCommandLine"));
        }
        Sdk jdk = javaParameters.getJdk();
        if (jdk == null) {
            throw new CantRunException(ExecutionBundle.message("run.configuration.error.no.jdk.specified", new Object[0]));
        }
        SdkTypeId type = jdk.getSdkType();
        if (!(type instanceof JavaSdkType)) {
            throw new CantRunException(ExecutionBundle.message("run.configuration.error.no.jdk.specified", new Object[0]));
        }
        String exePath = ((JavaSdkType)((Object)type)).getVMExecutablePath(jdk);
        if (exePath == null) {
            throw new CantRunException(ExecutionBundle.message("run.configuration.cannot.find.vm.executable", new Object[0]));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(exePath);
        JdkUtil.setupCommandLine(commandLine, javaParameters);
        return commandLine;
    }

    private static void setupCommandLine(GeneralCommandLine commandLine, SimpleJavaParameters javaParameters) throws CantRunException {
        commandLine.withWorkDirectory(javaParameters.getWorkingDirectory());
        commandLine.withEnvironment(javaParameters.getEnv());
        commandLine.withParentEnvironmentType(javaParameters.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        ParametersList vmParameters = javaParameters.getVMParametersList();
        boolean dynamicClasspath = javaParameters.isDynamicClasspath();
        boolean dynamicVMOptions = dynamicClasspath && javaParameters.isDynamicVMOptions() && JdkUtil.useDynamicVMOptions();
        boolean dynamicParameters = dynamicClasspath && javaParameters.isDynamicParameters() && JdkUtil.useDynamicParameters();
        boolean dynamicMainClass = false;
        if (dynamicClasspath) {
            Class commandLineWrapper;
            if (JdkUtil.canUseArgFile(commandLine, javaParameters)) {
                JdkUtil.setArgFileParams(commandLine, javaParameters, vmParameters, dynamicVMOptions, dynamicParameters);
                dynamicMainClass = dynamicParameters;
            } else if (!JdkUtil.explicitClassPath(vmParameters) && (commandLineWrapper = JdkUtil.getCommandLineWrapperClass()) != null) {
                if (JdkUtil.canUseClasspathJar(javaParameters)) {
                    JdkUtil.setClasspathJarParams(commandLine, javaParameters, vmParameters, commandLineWrapper, dynamicVMOptions, dynamicParameters);
                } else {
                    JdkUtil.setCommandLineWrapperParams(commandLine, javaParameters, vmParameters, commandLineWrapper, dynamicVMOptions, dynamicParameters);
                }
            } else {
                dynamicParameters = false;
                dynamicClasspath = false;
            }
        }
        if (!dynamicClasspath) {
            JdkUtil.appendParamsEncodingClasspath(javaParameters, commandLine, vmParameters);
        }
        if (!dynamicMainClass) {
            commandLine.addParameters(JdkUtil.getMainClassParams(javaParameters));
        }
        if (!dynamicParameters) {
            commandLine.addParameters(javaParameters.getProgramParametersList().getList());
        }
    }

    private static boolean canUseArgFile(GeneralCommandLine commandLine, SimpleJavaParameters javaParameters) {
        return javaParameters.getModuleName() != null || JdkUtil.isModularRuntime(new File(commandLine.getExePath()).getParentFile().getParentFile());
    }

    private static boolean explicitClassPath(ParametersList vmParameters) {
        return vmParameters.hasParameter("-cp") || vmParameters.hasParameter("-classpath") || vmParameters.hasParameter("--class-path");
    }

    private static boolean explicitModulePath(ParametersList vmParameters) {
        return vmParameters.hasParameter("-p") || vmParameters.hasParameter("--module-path");
    }

    private static void setArgFileParams(GeneralCommandLine commandLine, SimpleJavaParameters javaParameters, ParametersList vmParameters, boolean dynamicVMOptions, boolean dynamicParameters) throws CantRunException {
        try {
            File argFile = FileUtil.createTempFile((String)"idea_arg_file", null);
            try (PrintWriter writer = new PrintWriter(argFile);){
                PathsList modulePath;
                if (dynamicVMOptions) {
                    for (String param : vmParameters.getList()) {
                        writer.println(param);
                    }
                } else {
                    commandLine.addParameters(vmParameters.getList());
                }
                PathsList classPath = javaParameters.getClassPath();
                if (!classPath.isEmpty() && !JdkUtil.explicitClassPath(vmParameters)) {
                    writer.println("-classpath");
                    writer.println(classPath.getPathsString());
                }
                if (!(modulePath = javaParameters.getModulePath()).isEmpty() && !JdkUtil.explicitModulePath(vmParameters)) {
                    writer.println("-p");
                    writer.println(modulePath.getPathsString());
                }
                if (dynamicParameters) {
                    for (String parameter : JdkUtil.getMainClassParams(javaParameters)) {
                        writer.println(parameter);
                    }
                    for (String parameter : javaParameters.getProgramParametersList().getList()) {
                        writer.println(parameter);
                    }
                }
            }
            JdkUtil.appendEncoding(javaParameters, commandLine, vmParameters);
            commandLine.addParameter("@" + argFile.getAbsolutePath());
            JdkUtil.getFilesToDeleteUserData(commandLine).add(argFile);
        }
        catch (IOException e) {
            JdkUtil.throwUnableToCreateTempFile(e);
        }
    }

    private static void setCommandLineWrapperParams(GeneralCommandLine commandLine, SimpleJavaParameters javaParameters, ParametersList vmParameters, Class commandLineWrapper, boolean dynamicVMOptions, boolean dynamicParameters) throws CantRunException {
        try {
            File vmParamsFile = null;
            if (dynamicVMOptions) {
                vmParamsFile = FileUtil.createTempFile((String)"idea_vm_params", null);
                try (PrintWriter writer = new PrintWriter(vmParamsFile);){
                    for (String string : vmParameters.getList()) {
                        if (JdkUtil.isUserDefinedProperty(string)) {
                            writer.println(string);
                            continue;
                        }
                        commandLine.addParameter(string);
                    }
                }
            } else {
                commandLine.addParameters(vmParameters.getList());
            }
            JdkUtil.appendEncoding(javaParameters, commandLine, vmParameters);
            File appParamsFile = null;
            if (dynamicParameters) {
                appParamsFile = FileUtil.createTempFile((String)"idea_app_params", null);
                PrintWriter writer = new PrintWriter(appParamsFile);
                Object object = null;
                try {
                    for (String parameter : javaParameters.getProgramParametersList().getList()) {
                        writer.println(parameter);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (writer != null) {
                        if (object != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            File classpathFile = FileUtil.createTempFile((String)"idea_classpath", null);
            Throwable throwable = null;
            try (PrintWriter writer = new PrintWriter(classpathFile);){
                for (String path2 : javaParameters.getClassPath().getPathList()) {
                    writer.println(path2);
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            LinkedHashSet<String> classpath = new LinkedHashSet<String>();
            classpath.add(PathUtil.getJarPathForClass(commandLineWrapper));
            if (UrlClassLoader.class.getName().equals(vmParameters.getPropertyValue("java.system.class.loader"))) {
                classpath.add(PathUtil.getJarPathForClass(UrlClassLoader.class));
                classpath.add(PathUtil.getJarPathForClass(StringUtilRt.class));
                classpath.add(PathUtil.getJarPathForClass(THashMap.class));
            }
            commandLine.addParameter("-classpath");
            commandLine.addParameter(StringUtil.join(classpath, (String)File.pathSeparator));
            commandLine.addParameter(commandLineWrapper.getName());
            commandLine.addParameter(classpathFile.getAbsolutePath());
            if (vmParamsFile != null) {
                commandLine.addParameter("@vm_params");
                commandLine.addParameter(vmParamsFile.getAbsolutePath());
            }
            if (appParamsFile != null) {
                commandLine.addParameter("@app_params");
                commandLine.addParameter(appParamsFile.getAbsolutePath());
            }
            Set<File> set = JdkUtil.getFilesToDeleteUserData(commandLine);
            ContainerUtil.addIfNotNull(set, (Object)classpathFile);
            ContainerUtil.addIfNotNull(set, (Object)vmParamsFile);
            ContainerUtil.addIfNotNull(set, (Object)appParamsFile);
        }
        catch (IOException e) {
            JdkUtil.throwUnableToCreateTempFile(e);
        }
    }

    private static void setClasspathJarParams(GeneralCommandLine commandLine, SimpleJavaParameters javaParameters, ParametersList vmParameters, Class commandLineWrapper, boolean dynamicVMOptions, boolean dynamicParameters) throws CantRunException {
        try {
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().putValue("Created-By", ApplicationNamesInfo.getInstance().getFullProductName());
            if (dynamicVMOptions) {
                ArrayList<String> properties = new ArrayList<String>();
                for (String param : vmParameters.getList()) {
                    if (JdkUtil.isUserDefinedProperty(param)) {
                        properties.add(param);
                        continue;
                    }
                    commandLine.addParameter(param);
                }
                manifest.getMainAttributes().putValue("VM-Options", ParametersListUtil.join(properties));
            } else {
                commandLine.addParameters(vmParameters.getList());
            }
            JdkUtil.appendEncoding(javaParameters, commandLine, vmParameters);
            if (dynamicParameters) {
                manifest.getMainAttributes().putValue("Program-Parameters", ParametersListUtil.join(javaParameters.getProgramParametersList().getList()));
            }
            boolean notEscape = vmParameters.hasParameter(PROPERTY_DO_NOT_ESCAPE_CLASSPATH_URL);
            List<String> classPathList = javaParameters.getClassPath().getPathList();
            File classpathJarFile = CommandLineWrapperUtil.createClasspathJarFile((Manifest)manifest, classPathList, (boolean)notEscape);
            String jarFilePath = classpathJarFile.getAbsolutePath();
            commandLine.addParameter("-classpath");
            if (dynamicVMOptions || dynamicParameters) {
                commandLine.addParameter(PathUtil.getJarPathForClass(commandLineWrapper) + File.pathSeparator + jarFilePath);
                commandLine.addParameter(commandLineWrapper.getName());
            }
            commandLine.addParameter(jarFilePath);
            JdkUtil.getFilesToDeleteUserData(commandLine).add(classpathJarFile);
        }
        catch (IOException e) {
            JdkUtil.throwUnableToCreateTempFile(e);
        }
    }

    private static boolean isUserDefinedProperty(String param) {
        return param.startsWith("-D") && !param.startsWith("-Dsun.") && !param.startsWith("-Djava.");
    }

    private static void throwUnableToCreateTempFile(IOException cause) throws CantRunException {
        throw new CantRunException("Failed to a create temporary file in " + FileUtilRt.getTempDirectory(), cause);
    }

    private static boolean canUseClasspathJar(SimpleJavaParameters javaParameters) {
        String currentPath = PathUtil.getJarPathForClass(ClassPath.class);
        if (javaParameters.isUseClasspathJar() && JdkUtil.useClasspathJar()) {
            try {
                ArrayList<URL> urls = new ArrayList<URL>();
                for (String path2 : javaParameters.getClassPath().getPathList()) {
                    if (path2.equals(currentPath)) continue;
                    try {
                        urls.add(new File(path2).toURI().toURL());
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                Class<?> aClass = Class.forName("com.intellij.util.lang.ClassPath", false, (ClassLoader)UrlClassLoader.build().urls(urls).get());
                try {
                    aClass.getDeclaredMethod("initLoaders", URL.class, Boolean.TYPE, Integer.TYPE);
                }
                catch (NoSuchMethodException e) {
                    return false;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private static void appendParamsEncodingClasspath(SimpleJavaParameters javaParameters, GeneralCommandLine commandLine, ParametersList vmParameters) {
        PathsList modulePath;
        commandLine.addParameters(vmParameters.getList());
        JdkUtil.appendEncoding(javaParameters, commandLine, vmParameters);
        PathsList classPath = javaParameters.getClassPath();
        if (!classPath.isEmpty() && !JdkUtil.explicitClassPath(vmParameters)) {
            commandLine.addParameter("-classpath");
            commandLine.addParameter(classPath.getPathsString());
        }
        if (!(modulePath = javaParameters.getModulePath()).isEmpty() && !JdkUtil.explicitModulePath(vmParameters)) {
            commandLine.addParameter("-p");
            commandLine.addParameter(modulePath.getPathsString());
        }
    }

    private static void appendEncoding(SimpleJavaParameters javaParameters, GeneralCommandLine commandLine, ParametersList parametersList) {
        String encoding = parametersList.getPropertyValue("file.encoding");
        if (encoding == null) {
            Charset charset = javaParameters.getCharset();
            if (charset == null) {
                charset = EncodingManager.getInstance().getDefaultCharset();
            }
            commandLine.addParameter("-Dfile.encoding=" + charset.name());
            commandLine.withCharset(charset);
        } else {
            try {
                Charset charset = Charset.forName(encoding);
                commandLine.withCharset(charset);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private static List<String> getMainClassParams(SimpleJavaParameters javaParameters) throws CantRunException {
        String mainClass = javaParameters.getMainClass();
        String moduleName = javaParameters.getModuleName();
        String jarPath = javaParameters.getJarPath();
        if (mainClass != null && moduleName != null) {
            return Arrays.asList("-m", moduleName + '/' + mainClass);
        }
        if (mainClass != null) {
            return Collections.singletonList(mainClass);
        }
        if (jarPath != null) {
            return Arrays.asList("-jar", jarPath);
        }
        throw new CantRunException(ExecutionBundle.message("main.class.is.not.specified.error.message", new Object[0]));
    }

    private static Set<File> getFilesToDeleteUserData(GeneralCommandLine commandLine) {
        THashSet filesToDelete = commandLine.getUserData(OSProcessHandler.DELETE_FILES_ON_TERMINATION);
        if (filesToDelete == null) {
            filesToDelete = new THashSet();
            commandLine.putUserData(OSProcessHandler.DELETE_FILES_ON_TERMINATION, filesToDelete);
        }
        return filesToDelete;
    }

    @Nullable
    private static Class getCommandLineWrapperClass() {
        try {
            return Class.forName(WRAPPER_CLASS);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static boolean useDynamicClasspath(@Nullable Project project) {
        boolean hasDynamicProperty = Boolean.parseBoolean(System.getProperty("idea.dynamic.classpath", "false"));
        return project != null ? PropertiesComponent.getInstance(project).getBoolean("dynamic.classpath", hasDynamicProperty) : hasDynamicProperty;
    }

    public static boolean useDynamicVMOptions() {
        return PropertiesComponent.getInstance().getBoolean("idea.dynamic.vmoptions", true);
    }

    public static boolean useDynamicParameters() {
        return PropertiesComponent.getInstance().getBoolean("idea.dynamic.parameters", true);
    }

    public static boolean useClasspathJar() {
        return PropertiesComponent.getInstance().getBoolean("idea.dynamic.classpath.jar", true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String getJarMainAttribute(@NotNull VirtualFile jarRoot, @NotNull Attributes.Name attribute) {
        if (jarRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarRoot", "com/intellij/openapi/projectRoots/JdkUtil", "getJarMainAttribute"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/openapi/projectRoots/JdkUtil", "getJarMainAttribute"));
        }
        VirtualFile manifestFile = jarRoot.findFileByRelativePath("META-INF/MANIFEST.MF");
        if (manifestFile == null) return null;
        try (InputStream stream = manifestFile.getInputStream();){
            String string = new Manifest(stream).getMainAttributes().getValue(attribute);
            return string;
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
        return null;
    }

    public static GeneralCommandLine setupJVMCommandLine(String exePath, SimpleJavaParameters javaParameters, boolean forceDynamicClasspath) {
        try {
            javaParameters.setUseDynamicClasspath(forceDynamicClasspath);
            GeneralCommandLine commandLine = new GeneralCommandLine(exePath);
            JdkUtil.setupCommandLine(commandLine, javaParameters);
            return commandLine;
        }
        catch (CantRunException e) {
            throw new RuntimeException(e);
        }
    }
}

