/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsFileListenerContextHelper;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsVFSListener
implements Disposable {
    protected static final Logger LOG = Logger.getInstance(VcsVFSListener.class);
    private final VcsDirtyScopeManager myDirtyScopeManager;
    private final ProjectLevelVcsManager myVcsManager;
    private final VcsFileListenerContextHelper myVcsFileListenerContextHelper;
    protected final Project myProject;
    protected final AbstractVcs myVcs;
    protected final ChangeListManager myChangeListManager;
    protected final VcsShowConfirmationOption myAddOption;
    protected final VcsShowConfirmationOption myRemoveOption;
    protected final List<VirtualFile> myAddedFiles;
    protected final Map<VirtualFile, VirtualFile> myCopyFromMap;
    protected final List<VcsException> myExceptions;
    protected final List<FilePath> myDeletedFiles;
    protected final List<FilePath> myDeletedWithoutConfirmFiles;
    protected final List<MovedFileInfo> myMovedFiles;
    protected final LinkedHashSet<VirtualFile> myDirtyFiles;

    protected VcsVFSListener(@NotNull Project project, @NotNull AbstractVcs vcs) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/VcsVFSListener", "<init>"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/VcsVFSListener", "<init>"));
        }
        this.myAddedFiles = new ArrayList<VirtualFile>();
        this.myCopyFromMap = new HashMap<VirtualFile, VirtualFile>();
        this.myExceptions = new SmartList();
        this.myDeletedFiles = new ArrayList<FilePath>();
        this.myDeletedWithoutConfirmFiles = new ArrayList<FilePath>();
        this.myMovedFiles = new ArrayList<MovedFileInfo>();
        this.myDirtyFiles = ContainerUtil.newLinkedHashSet();
        this.myProject = project;
        this.myVcs = vcs;
        this.myChangeListManager = ChangeListManager.getInstance(project);
        this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance(this.myProject);
        MyVirtualFileListener myVFSListener = new MyVirtualFileListener();
        MyCommandAdapter myCommandListener = new MyCommandAdapter();
        this.myVcsManager = ProjectLevelVcsManager.getInstance(project);
        this.myAddOption = this.myVcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, vcs);
        this.myRemoveOption = this.myVcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, vcs);
        VirtualFileManager.getInstance().addVirtualFileListener(myVFSListener, this);
        CommandProcessor.getInstance().addCommandListener(myCommandListener, this);
        this.myVcsFileListenerContextHelper = VcsFileListenerContextHelper.getInstance(this.myProject);
    }

    public void dispose() {
    }

    protected boolean isEventIgnored(VirtualFileEvent event, boolean putInDirty) {
        boolean vcsIgnored;
        if (event.isFromRefresh()) {
            return true;
        }
        boolean bl = vcsIgnored = !this.isUnderMyVcs(event.getFile());
        if (vcsIgnored) {
            this.myDirtyFiles.add(event.getFile());
        }
        return vcsIgnored;
    }

    private boolean isUnderMyVcs(VirtualFile file) {
        return this.myVcsManager.getVcsFor(file) == this.myVcs && this.myVcsManager.isFileInContent(file) && !this.myChangeListManager.isIgnoredFile(file);
    }

    protected void executeAdd() {
        List<VirtualFile> addedFiles = this.acquireAddedFiles();
        LOG.debug("executeAdd. addedFiles: " + addedFiles);
        Iterator<VirtualFile> iterator = addedFiles.iterator();
        while (iterator.hasNext()) {
            VirtualFile file = iterator.next();
            if (!this.myVcsFileListenerContextHelper.isAdditionIgnored(file)) continue;
            iterator.remove();
        }
        Map<VirtualFile, VirtualFile> copyFromMap = this.acquireCopiedFiles();
        if (!addedFiles.isEmpty()) {
            this.executeAdd(addedFiles, copyFromMap);
        }
    }

    protected Map<VirtualFile, VirtualFile> acquireCopiedFiles() {
        HashMap<VirtualFile, VirtualFile> copyFromMap = new HashMap<VirtualFile, VirtualFile>(this.myCopyFromMap);
        this.myCopyFromMap.clear();
        return copyFromMap;
    }

    protected List<VirtualFile> acquireAddedFiles() {
        ArrayList<VirtualFile> addedFiles = new ArrayList<VirtualFile>(this.myAddedFiles);
        this.myAddedFiles.clear();
        return addedFiles;
    }

    protected void executeAdd(List<VirtualFile> addedFiles, Map<VirtualFile, VirtualFile> copyFromMap) {
        LOG.debug("executeAdd. add-option: " + (Object)((Object)this.myAddOption.getValue()) + ", files to add: " + addedFiles);
        if (this.myAddOption.getValue() == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            return;
        }
        if (this.myAddOption.getValue() == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
            this.performAdding(addedFiles, copyFromMap);
        } else {
            AbstractVcsHelper helper = AbstractVcsHelper.getInstance(this.myProject);
            Collection<VirtualFile> filesToProcess = helper.selectFilesToProcess(addedFiles, this.getAddTitle(), null, this.getSingleFileAddTitle(), this.getSingleFileAddPromptTemplate(), this.myAddOption);
            if (filesToProcess != null) {
                this.performAdding(new ArrayList<VirtualFile>(filesToProcess), copyFromMap);
            }
        }
    }

    private void addFileToDelete(VirtualFile file) {
        if (file.isDirectory() && file instanceof NewVirtualFile && !this.isDirectoryVersioningSupported()) {
            for (VirtualFile child : ((NewVirtualFile)file).getCachedChildren()) {
                this.addFileToDelete(child);
            }
        } else {
            VcsDeleteType type = this.needConfirmDeletion(file);
            FilePath filePath2 = VcsContextFactory.SERVICE.getInstance().createFilePathOn(new File(file.getPath()), file.isDirectory());
            if (type == VcsDeleteType.CONFIRM) {
                this.myDeletedFiles.add(filePath2);
            } else if (type == VcsDeleteType.SILENT) {
                this.myDeletedWithoutConfirmFiles.add(filePath2);
            }
        }
    }

    protected void executeDelete() {
        FilePath file;
        ArrayList<FilePath> filesToDelete = new ArrayList<FilePath>(this.myDeletedWithoutConfirmFiles);
        ArrayList<FilePath> deletedFiles = new ArrayList<FilePath>(this.myDeletedFiles);
        this.myDeletedWithoutConfirmFiles.clear();
        this.myDeletedFiles.clear();
        Iterator iterator = filesToDelete.iterator();
        while (iterator.hasNext()) {
            file = (FilePath)iterator.next();
            if (!this.myVcsFileListenerContextHelper.isDeletionIgnored(file)) continue;
            iterator.remove();
        }
        iterator = deletedFiles.iterator();
        while (iterator.hasNext()) {
            file = (FilePath)iterator.next();
            if (!this.myVcsFileListenerContextHelper.isDeletionIgnored(file)) continue;
            iterator.remove();
        }
        if (deletedFiles.isEmpty() && filesToDelete.isEmpty()) {
            return;
        }
        if (this.myRemoveOption.getValue() != VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            if (this.myRemoveOption.getValue() == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY || deletedFiles.isEmpty()) {
                filesToDelete.addAll(deletedFiles);
            } else {
                Collection<FilePath> filePaths = this.selectFilePathsToDelete(deletedFiles);
                if (filePaths != null) {
                    filesToDelete.addAll(filePaths);
                }
            }
        }
        this.performDeletion(filesToDelete);
    }

    @Nullable
    protected Collection<FilePath> selectFilePathsToDelete(List<FilePath> deletedFiles) {
        AbstractVcsHelper helper = AbstractVcsHelper.getInstance(this.myProject);
        return helper.selectFilePathsToProcess(deletedFiles, this.getDeleteTitle(), null, this.getSingleFileDeleteTitle(), this.getSingleFileDeletePromptTemplate(), this.myRemoveOption);
    }

    protected void beforeContentsChange(VirtualFileEvent event, VirtualFile file) {
    }

    protected void fileAdded(VirtualFileEvent event, VirtualFile file) {
        if (!(this.isEventIgnored(event, true) || this.myChangeListManager.isIgnoredFile(file) || !this.isDirectoryVersioningSupported() && file.isDirectory())) {
            LOG.debug("Adding [" + file.getPresentableUrl() + "] to added files");
            this.myAddedFiles.add(event.getFile());
        }
    }

    private void addFileToMove(VirtualFile file, String newParentPath, String newName) {
        if (file.isDirectory() && !file.is(VFileProperty.SYMLINK) && !this.isDirectoryVersioningSupported()) {
            VirtualFile[] children = file.getChildren();
            if (children != null) {
                for (VirtualFile child : children) {
                    this.addFileToMove(child, newParentPath + "/" + newName, child.getName());
                }
            }
        } else {
            this.processMovedFile(file, newParentPath, newName);
        }
    }

    protected boolean filterOutUnknownFiles() {
        return true;
    }

    protected void processMovedFile(VirtualFile file, String newParentPath, String newName) {
        FileStatus status = FileStatusManager.getInstance(this.myProject).getStatus(file);
        LOG.debug("Checking moved file " + file + "; status=" + status);
        if (status == FileStatus.IGNORED && file.getParent() != null) {
            this.myDirtyFiles.add(file.getParent());
            this.myDirtyFiles.add(file);
        }
        String newPath = newParentPath + "/" + newName;
        MovedFileInfo existingMovedFile = (MovedFileInfo)ContainerUtil.find(this.myMovedFiles, info -> Comparing.equal((Object)((MovedFileInfo)info).myFile, (Object)file));
        if (existingMovedFile != null) {
            LOG.debug("Reusing existing moved file " + file);
            existingMovedFile.myNewPath = newPath;
        } else {
            LOG.debug("Registered moved file " + file);
            this.myMovedFiles.add(new MovedFileInfo(file, newPath));
        }
    }

    private void executeMoveRename() {
        ArrayList<MovedFileInfo> movedFiles = new ArrayList<MovedFileInfo>(this.myMovedFiles);
        LOG.debug("executeMoveRename " + movedFiles);
        this.myMovedFiles.clear();
        this.performMoveRename(ContainerUtil.filter(movedFiles, info -> {
            FileStatus status = FileStatusManager.getInstance(this.myProject).getStatus(((MovedFileInfo)info).myFile);
            return (status != FileStatus.UNKNOWN || !this.filterOutUnknownFiles()) && status != FileStatus.IGNORED;
        }));
    }

    protected VcsDeleteType needConfirmDeletion(VirtualFile file) {
        return VcsDeleteType.CONFIRM;
    }

    protected abstract String getAddTitle();

    protected abstract String getSingleFileAddTitle();

    protected abstract String getSingleFileAddPromptTemplate();

    protected abstract void performAdding(Collection<VirtualFile> var1, Map<VirtualFile, VirtualFile> var2);

    protected abstract String getDeleteTitle();

    protected abstract String getSingleFileDeleteTitle();

    protected abstract String getSingleFileDeletePromptTemplate();

    protected abstract void performDeletion(List<FilePath> var1);

    protected abstract void performMoveRename(List<MovedFileInfo> var1);

    protected abstract boolean isDirectoryVersioningSupported();

    private class MyCommandAdapter
    implements CommandListener {
        private int myCommandLevel;

        private MyCommandAdapter() {
        }

        @Override
        public void commandStarted(CommandEvent event) {
            if (VcsVFSListener.this.myProject != event.getProject()) {
                return;
            }
            ++this.myCommandLevel;
        }

        private void checkMovedAddedSourceBack() {
            if (VcsVFSListener.this.myAddedFiles.isEmpty() || VcsVFSListener.this.myMovedFiles.isEmpty()) {
                return;
            }
            HashMap<String, VirtualFile> addedPaths = new HashMap<String, VirtualFile>(VcsVFSListener.this.myAddedFiles.size());
            for (VirtualFile file : VcsVFSListener.this.myAddedFiles) {
                addedPaths.put(file.getPath(), file);
            }
            Iterator<MovedFileInfo> iterator = VcsVFSListener.this.myMovedFiles.iterator();
            while (iterator.hasNext()) {
                MovedFileInfo movedFile = iterator.next();
                if (!addedPaths.containsKey(movedFile.myOldPath)) continue;
                iterator.remove();
                VirtualFile oldAdded = (VirtualFile)addedPaths.get(movedFile.myOldPath);
                VcsVFSListener.this.myAddedFiles.remove(oldAdded);
                VcsVFSListener.this.myAddedFiles.add(movedFile.myFile);
                VcsVFSListener.this.myCopyFromMap.put(oldAdded, movedFile.myFile);
            }
        }

        private void doNotDeleteAddedCopiedOrMovedFiles() {
            ArrayList<String> copiedAddedMoved = new ArrayList<String>();
            for (VirtualFile file : VcsVFSListener.this.myCopyFromMap.keySet()) {
                copiedAddedMoved.add(file.getPath());
            }
            for (VirtualFile file : VcsVFSListener.this.myAddedFiles) {
                copiedAddedMoved.add(file.getPath());
            }
            for (MovedFileInfo movedFileInfo : VcsVFSListener.this.myMovedFiles) {
                copiedAddedMoved.add(movedFileInfo.myNewPath);
            }
            Iterator<FilePath> iterator = VcsVFSListener.this.myDeletedFiles.iterator();
            while (iterator.hasNext()) {
                if (!copiedAddedMoved.contains(FileUtil.toSystemIndependentName((String)iterator.next().getPath()))) continue;
                iterator.remove();
            }
            iterator = VcsVFSListener.this.myDeletedWithoutConfirmFiles.iterator();
            while (iterator.hasNext()) {
                if (!copiedAddedMoved.contains(FileUtil.toSystemIndependentName((String)iterator.next().getPath()))) continue;
                iterator.remove();
            }
        }

        @Override
        public void commandFinished(CommandEvent event) {
            if (VcsVFSListener.this.myProject != event.getProject()) {
                return;
            }
            --this.myCommandLevel;
            if (!(this.myCommandLevel != 0 || VcsVFSListener.this.myAddedFiles.isEmpty() && VcsVFSListener.this.myDeletedFiles.isEmpty() && VcsVFSListener.this.myDeletedWithoutConfirmFiles.isEmpty() && VcsVFSListener.this.myMovedFiles.isEmpty() && VcsVFSListener.this.myDirtyFiles.isEmpty())) {
                this.doNotDeleteAddedCopiedOrMovedFiles();
                this.checkMovedAddedSourceBack();
                if (!VcsVFSListener.this.myAddedFiles.isEmpty()) {
                    VcsVFSListener.this.executeAdd();
                    VcsVFSListener.this.myAddedFiles.clear();
                }
                if (!VcsVFSListener.this.myDeletedFiles.isEmpty() || !VcsVFSListener.this.myDeletedWithoutConfirmFiles.isEmpty()) {
                    VcsVFSListener.this.executeDelete();
                    VcsVFSListener.this.myDeletedFiles.clear();
                    VcsVFSListener.this.myDeletedWithoutConfirmFiles.clear();
                }
                if (!VcsVFSListener.this.myMovedFiles.isEmpty()) {
                    VcsVFSListener.this.executeMoveRename();
                    VcsVFSListener.this.myMovedFiles.clear();
                }
                if (!VcsVFSListener.this.myDirtyFiles.isEmpty()) {
                    ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
                    ArrayList<VirtualFile> dirs = new ArrayList<VirtualFile>();
                    for (VirtualFile dirtyFile : VcsVFSListener.this.myDirtyFiles) {
                        if (dirtyFile == null) continue;
                        if (dirtyFile.isDirectory()) {
                            dirs.add(dirtyFile);
                            continue;
                        }
                        files.add(dirtyFile);
                    }
                    VcsVFSListener.this.myDirtyScopeManager.filesDirty(files, dirs);
                    VcsVFSListener.this.myDirtyFiles.clear();
                }
                if (!VcsVFSListener.this.myExceptions.isEmpty()) {
                    AbstractVcsHelper.getInstance(VcsVFSListener.this.myProject).showErrors(VcsVFSListener.this.myExceptions, VcsVFSListener.this.myVcs.getDisplayName() + " operations errors");
                }
            }
        }
    }

    private class MyVirtualFileListener
    implements VirtualFileListener {
        private MyVirtualFileListener() {
        }

        @Override
        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/VcsVFSListener$MyVirtualFileListener", "fileCreated"));
            }
            VirtualFile file = event.getFile();
            LOG.debug("fileCreated: " + file.getPresentableUrl());
            if (VcsVFSListener.this.isUnderMyVcs(file)) {
                VcsVFSListener.this.fileAdded(event, file);
            }
        }

        @Override
        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/VcsVFSListener$MyVirtualFileListener", "fileCopied"));
            }
            if (VcsVFSListener.this.isEventIgnored(event, true) || VcsVFSListener.this.myChangeListManager.isIgnoredFile(event.getFile())) {
                return;
            }
            AbstractVcs oldVcs = ProjectLevelVcsManager.getInstance(VcsVFSListener.this.myProject).getVcsFor(event.getOriginalFile());
            if (oldVcs == VcsVFSListener.this.myVcs) {
                VirtualFile parent = event.getFile().getParent();
                if (parent != null) {
                    VcsVFSListener.this.myAddedFiles.add(event.getFile());
                    VcsVFSListener.this.myCopyFromMap.put(event.getFile(), event.getOriginalFile());
                }
            } else {
                VcsVFSListener.this.myAddedFiles.add(event.getFile());
            }
        }

        @Override
        public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/VcsVFSListener$MyVirtualFileListener", "beforeFileDeletion"));
            }
            VirtualFile file = event.getFile();
            if (VcsVFSListener.this.isEventIgnored(event, true)) {
                return;
            }
            if (!VcsVFSListener.this.myChangeListManager.isIgnoredFile(file)) {
                VcsVFSListener.this.addFileToDelete(file);
                return;
            }
            if (event.getFile().isDirectory()) {
                LinkedList<VirtualFile> list = new LinkedList<VirtualFile>();
                VcsUtil.collectFiles(file, list, true, VcsVFSListener.this.isDirectoryVersioningSupported());
                for (VirtualFile child : list) {
                    if (VcsVFSListener.this.myChangeListManager.isIgnoredFile(child)) continue;
                    VcsVFSListener.this.addFileToDelete(child);
                }
            }
        }

        @Override
        public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/VcsVFSListener$MyVirtualFileListener", "beforeFileMovement"));
            }
            if (VcsVFSListener.this.isEventIgnored(event, true)) {
                return;
            }
            VirtualFile file = event.getFile();
            AbstractVcs newVcs = ProjectLevelVcsManager.getInstance(VcsVFSListener.this.myProject).getVcsFor(event.getNewParent());
            LOG.debug("beforeFileMovement " + event + " into " + newVcs);
            if (newVcs == VcsVFSListener.this.myVcs) {
                VcsVFSListener.this.addFileToMove(file, event.getNewParent().getPath(), file.getName());
            } else {
                VcsVFSListener.this.addFileToDelete(event.getFile());
            }
        }

        @Override
        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/VcsVFSListener$MyVirtualFileListener", "fileMoved"));
            }
            if (VcsVFSListener.this.isEventIgnored(event, true)) {
                return;
            }
            AbstractVcs oldVcs = ProjectLevelVcsManager.getInstance(VcsVFSListener.this.myProject).getVcsFor(event.getOldParent());
            if (oldVcs != VcsVFSListener.this.myVcs) {
                VcsVFSListener.this.myAddedFiles.add(event.getFile());
            }
        }

        @Override
        public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/VcsVFSListener$MyVirtualFileListener", "beforePropertyChange"));
            }
            if (!VcsVFSListener.this.isEventIgnored(event, false) && event.getPropertyName().equalsIgnoreCase("name")) {
                VirtualFile file;
                VirtualFile parent;
                LOG.debug("before file rename " + event);
                String oldName = (String)event.getOldValue();
                String newName = (String)event.getNewValue();
                if (!Comparing.equal((String)oldName, (String)newName) && (parent = (file = event.getFile()).getParent()) != null) {
                    VcsVFSListener.this.addFileToMove(file, parent.getPath(), newName);
                }
            }
        }

        @Override
        public void beforeContentsChange(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/VcsVFSListener$MyVirtualFileListener", "beforeContentsChange"));
            }
            VirtualFile file = event.getFile();
            assert (!file.isDirectory());
            if (VcsVFSListener.this.isUnderMyVcs(file)) {
                VcsVFSListener.this.beforeContentsChange(event, file);
            }
        }
    }

    protected static enum VcsDeleteType {
        SILENT,
        CONFIRM,
        IGNORE;

    }

    protected static class MovedFileInfo {
        public final String myOldPath;
        public String myNewPath;
        private final VirtualFile myFile;

        protected MovedFileInfo(VirtualFile file, String newPath) {
            this.myOldPath = file.getPath();
            this.myNewPath = newPath;
            this.myFile = file;
        }

        public String toString() {
            return "MovedFileInfo{myNewPath=" + this.myNewPath + ", myFile=" + this.myFile + '}';
        }
    }
}

