/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.jrt;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import org.jetbrains.annotations.NotNull;

public abstract class JrtFileSystem
extends ArchiveFileSystem {
    public static final String PROTOCOL = "jrt";
    public static final String PROTOCOL_PREFIX = "jrt://";
    public static final String SEPARATOR = "!/";

    public static boolean isRoot(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/jrt/JrtFileSystem", "isRoot"));
        }
        return file.getParent() == null && file.getFileSystem() instanceof JrtFileSystem;
    }

    public static boolean isModuleRoot(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/jrt/JrtFileSystem", "isModuleRoot"));
        }
        VirtualFile parent = file.getParent();
        return parent != null && JrtFileSystem.isRoot(parent);
    }
}

