/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.ScrollSettings;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;

final class ScrollColorProducer
implements NotNullProducer<Color> {
    private final Component myComponent;
    private final Color myBrightColor;
    private final Color myDarkColor;
    private final boolean isBackground;
    private volatile Color myOriginal;
    private volatile Color myModified;

    private ScrollColorProducer(Component component, int bright, int dark, boolean background) {
        this.myComponent = component;
        this.myBrightColor = new Color(bright);
        this.myDarkColor = new Color(dark);
        this.isBackground = background;
    }

    @NotNull
    public Color produce() {
        Color background;
        Container parent = this.myComponent.getParent();
        if (this.isBackground && parent instanceof JScrollPane && ScrollSettings.isBackgroundFromView() && (background = JBScrollPane.getViewBackground((JScrollPane)parent)) != null) {
            if (!background.equals(this.myOriginal)) {
                this.myModified = ColorUtil.shift((Color)background, (double)(ColorUtil.isDark((Color)background) ? 1.05 : 0.96));
                this.myOriginal = background;
            }
            Color color = this.myModified;
            if (color == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/components/ScrollColorProducer", "produce"));
            }
            return color;
        }
        Color color = ScrollColorProducer.isDark(this.myComponent) ? this.myDarkColor : this.myBrightColor;
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/components/ScrollColorProducer", "produce"));
        }
        return color;
    }

    static void setForeground(Component component) {
        component.setForeground((Color)new JBColor((NotNullProducer)new ScrollColorProducer(component, 0xE6E6E6, 3948353, false)));
    }

    static void setBackground(Component component) {
        component.setBackground((Color)new JBColor((NotNullProducer)new ScrollColorProducer(component, 0xF5F5F5, 3948353, true)));
    }

    static boolean isDark(Component c) {
        Color color;
        JScrollPane pane;
        Object property;
        Container parent = c.getParent();
        if (parent instanceof JScrollPane && (property = (pane = (JScrollPane)parent).getClientProperty(JBScrollPane.BRIGHTNESS_FROM_VIEW)) instanceof Boolean && ((Boolean)property).booleanValue() && (color = JBScrollPane.getViewBackground(pane)) != null) {
            return ColorUtil.isDark((Color)color);
        }
        return UIUtil.isUnderDarcula();
    }
}

