/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.tree;

import com.intellij.util.ui.tree.TreePathState;
import com.intellij.util.ui.tree.TreeUtil;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class IndexTreePathState
implements TreePathState {
    private final TreePath mySelectionPath;
    private final int[] myIndicies;

    public IndexTreePathState(TreePath path2) {
        this.mySelectionPath = path2;
        this.myIndicies = IndexTreePathState.pathToChildIndecies(path2);
    }

    @Override
    public TreePath getRestoredPath() {
        int aliveIndex = IndexTreePathState.findLowestAliveNodeIndex(this.mySelectionPath);
        if (aliveIndex == this.mySelectionPath.getPathCount() - 1) {
            return this.mySelectionPath;
        }
        TreeNode aliveAncestor = (TreeNode)this.mySelectionPath.getPathComponent(aliveIndex);
        TreePath newSelection = TreeUtil.getPathFromRoot(aliveAncestor);
        int childrenLeft = aliveAncestor.getChildCount();
        if (childrenLeft != 0) {
            int newSelectedChildIndex = Math.min(this.myIndicies[aliveIndex + 1], childrenLeft - 1);
            newSelection = newSelection.pathByAddingChild(aliveAncestor.getChildAt(newSelectedChildIndex));
        }
        return newSelection;
    }

    public void restoreSelection(JTree tree) {
        TreeUtil.selectPath(tree, this.getRestoredPath());
    }

    private static int findLowestAliveNodeIndex(TreePath path2) {
        Object[] nodes = path2.getPath();
        for (int i2 = 1; i2 < nodes.length; ++i2) {
            TreeNode node = (TreeNode)nodes[i2];
            if (node.getParent() != null) continue;
            return i2 - 1;
        }
        return nodes.length - 1;
    }

    private static int[] pathToChildIndecies(TreePath path2) {
        int[] result = new int[path2.getPathCount()];
        for (int i2 = 0; i2 < path2.getPathCount(); ++i2) {
            TreeNode node = (TreeNode)path2.getPathComponent(i2);
            TreeNode parent = node.getParent();
            result[i2] = parent != null ? parent.getIndex(node) : 0;
        }
        return result;
    }
}

