/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.ComparisonExpr;
import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.expr.StaticIdentifierExpr;
import android.databinding.tool.processing.Scope;
import android.databinding.tool.reflection.Callable;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.solver.ExecutionPath;
import android.databinding.tool.store.SetterStore;
import android.databinding.tool.util.L;
import android.databinding.tool.writer.KCode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MethodCallExpr
extends Expr {
    final String mName;
    Callable mGetter;
    ModelMethod mMethod;
    private boolean mAllowProtected;

    static List<Expr> concat(Expr e, List<Expr> list) {
        ArrayList<Expr> merged = new ArrayList<Expr>();
        merged.add(e);
        merged.addAll(list);
        return merged;
    }

    MethodCallExpr(Expr target, String name, List<Expr> args) {
        super(MethodCallExpr.concat(target, args));
        this.mName = name;
    }

    @Override
    public void updateExpr(ModelAnalyzer modelAnalyzer) {
        try {
            Scope.enter(this);
            this.getResolvedType();
            super.updateExpr(modelAnalyzer);
        }
        finally {
            Scope.exit();
        }
    }

    @Override
    protected KCode generateCode() {
        KCode code = new KCode().app("", this.getTarget().toCode()).app(".").app(this.getGetter().name).app("(");
        this.appendArgs(code);
        code.app(")");
        return code;
    }

    @Override
    public Expr cloneToModel(ExprModel model) {
        return model.methodCall(this.getTarget().cloneToModel(model), this.mName, MethodCallExpr.cloneToModel(model, this.getArgs()));
    }

    private void appendArgs(KCode code) {
        boolean first = true;
        for (Expr arg : this.getArgs()) {
            if (first) {
                first = false;
            } else {
                code.app(", ");
            }
            code.app("", arg.toCode());
        }
    }

    @Override
    public List<ExecutionPath> toExecutionPath(List<ExecutionPath> paths) {
        List<ExecutionPath> targetPaths = this.getTarget().toExecutionPath(paths);
        ArrayList<ExecutionPath> result = new ArrayList<ExecutionPath>();
        if (this.getTarget() instanceof StaticIdentifierExpr) {
            result.addAll(this.toExecutionPathInOrder(paths, this.getArgs()));
        } else {
            for (ExecutionPath path : targetPaths) {
                ComparisonExpr cmp = this.getModel().comparison("!=", this.getTarget(), this.getModel().symbol("null", Object.class));
                cmp.setUnwrapObservableFields(false);
                path.addPath(cmp);
                ExecutionPath subPath = path.addBranch(cmp, true);
                if (subPath == null) continue;
                result.addAll(this.toExecutionPathInOrder(subPath, this.getArgs()));
            }
        }
        return result;
    }

    private List<ExecutionPath> toExecutionPathInOrder(ExecutionPath path, List<Expr> args) {
        return this.toExecutionPathInOrder(Arrays.asList(path), args);
    }

    @Override
    public void injectSafeUnboxing(ModelAnalyzer modelAnalyzer, ExprModel model) {
        ModelMethod method = this.mMethod;
        int limit = this.getArgs().size();
        for (int i = 0; i < limit; ++i) {
            Expr arg = this.getArgs().get(i);
            ModelClass expected = method.getParameterAt(i);
            if (!arg.getResolvedType().isNullable() || expected.isNullable()) continue;
            this.safeUnboxChild(model, arg);
        }
    }

    @Override
    protected void resetResolvedType() {
        super.resetResolvedType();
        this.mGetter = null;
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        if (this.mGetter == null) {
            ArrayList<ModelClass> args = new ArrayList<ModelClass>();
            for (Expr expr : this.getArgs()) {
                args.add(expr.getResolvedType());
            }
            Expr target = this.getTarget();
            boolean isStatic = target instanceof StaticIdentifierExpr;
            this.mMethod = target.getResolvedType().getMethod(this.mName, args, isStatic, this.mAllowProtected);
            if (this.mMethod == null) {
                StringBuilder argTypes = new StringBuilder();
                for (ModelClass arg : args) {
                    if (argTypes.length() != 0) {
                        argTypes.append(", ");
                    }
                    argTypes.append(arg.toJavaCode());
                }
                String message = "cannot find method '" + this.mName + "(" + argTypes + ")' in class " + target.getResolvedType().toJavaCode();
                IllegalArgumentException e = new IllegalArgumentException(message);
                L.e(e, "cannot find method %s(%s) in class %s", this.mName, argTypes, target.getResolvedType().toJavaCode());
                throw e;
            }
            if (!isStatic && this.mMethod.isStatic()) {
                target.getParents().remove(this);
                this.getChildren().remove(target);
                StaticIdentifierExpr staticId = this.getModel().staticIdentifierFor(target.getResolvedType());
                this.getChildren().add(staticId);
                staticId.getParents().add(this);
                target = this.getTarget();
            }
            int flags = 1;
            if (this.mMethod.isStatic()) {
                flags |= 4;
            }
            this.mGetter = new Callable(Callable.Type.METHOD, this.mMethod.getName(), null, this.mMethod.getReturnType(args), this.mMethod.getParameterTypes().length, flags, this.mMethod, null);
        }
        return this.mGetter.resolvedType;
    }

    @Override
    protected List<Dependency> constructDependencies() {
        List<Dependency> dependencies = this.constructDynamicChildrenDependencies();
        for (Dependency dependency : dependencies) {
            if (dependency.getOther() != this.getTarget()) continue;
            dependency.setMandatory(true);
        }
        return dependencies;
    }

    @Override
    protected String computeUniqueKey() {
        return MethodCallExpr.join(this.getTarget(), ".", this.mName, MethodCallExpr.join(this.getArgs()));
    }

    public Expr getTarget() {
        return this.getChildren().get(0);
    }

    public String getName() {
        return this.mName;
    }

    public List<Expr> getArgs() {
        return this.getChildren().subList(1, this.getChildren().size());
    }

    public Callable getGetter() {
        return this.mGetter;
    }

    public void setAllowProtected() {
        this.mAllowProtected = true;
    }

    @Override
    public String getInvertibleError() {
        SetterStore setterStore = SetterStore.get(ModelAnalyzer.getInstance());
        this.getResolvedType();
        if (this.mMethod == null) {
            return "Could not find the method " + this.mName + " to inverse for two-way binding";
        }
        if (this.mName.equals("get") && this.getTarget().getResolvedType().isObservableField() && this.getArgs().isEmpty()) {
            return null;
        }
        String inverse = setterStore.getInverseMethod(this.mMethod);
        if (inverse == null) {
            return "There is no inverse for method " + this.mName + ", you must add an @InverseMethod annotation to the method to indicate which method should be used when using it in two-way binding expressions";
        }
        return null;
    }

    @Override
    public Expr generateInverse(ExprModel model, Expr value, String bindingClassName) {
        this.getResolvedType();
        if (this.mName.equals("get") && this.getTarget().getResolvedType().isObservableField() && this.getArgs().isEmpty()) {
            Expr castExpr = model.castExpr(this.getResolvedType().toJavaCode(), value);
            Expr target = this.getTarget().cloneToModel(model);
            MethodCallExpr inverse = model.methodCall(target, "set", Lists.newArrayList((Object[])new Expr[]{castExpr}));
            inverse.setUnwrapObservableFields(false);
            return inverse;
        }
        SetterStore setterStore = SetterStore.get(ModelAnalyzer.getInstance());
        String methodName = setterStore.getInverseMethod(this.mMethod);
        List<Expr> theseArgs = this.getArgs();
        ArrayList<Expr> args = new ArrayList<Expr>();
        for (int i = 0; i < theseArgs.size() - 1; ++i) {
            args.add(theseArgs.get(i).cloneToModel(model));
        }
        args.add(value);
        Expr varExpr = theseArgs.get(theseArgs.size() - 1).cloneToModel(model);
        MethodCallExpr methodCall = model.methodCall(this.getTarget().cloneToModel(model), methodName, args);
        return varExpr.generateInverse(model, methodCall, bindingClassName);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getTarget()).append('.').append(this.mName).append('(');
        List<Expr> args = this.getArgs();
        for (int i = 0; i < args.size(); ++i) {
            Expr arg = args.get(i);
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(arg);
        }
        buf.append(')');
        return buf.toString();
    }
}

