/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.internal.attributes.AttributeMatchingRules;
import org.gradle.api.internal.attributes.DisambiguationRuleChainInternal;
import org.gradle.api.internal.attributes.SelectAllCompatibleRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDisambiguationRuleChain<T>
implements DisambiguationRuleChainInternal<T> {
    private final List<Action<? super MultipleCandidatesDetails<T>>> rules = Lists.newArrayList();

    @Override
    public void add(Action<? super MultipleCandidatesDetails<T>> rule) {
        this.rules.add(rule);
    }

    @Override
    public void pickFirst(Comparator<? super T> comparator) {
        Action<MultipleCandidatesDetails<? super T>> rule = AttributeMatchingRules.orderedDisambiguation(comparator, true);
        this.add(rule);
    }

    @Override
    public void pickLast(Comparator<? super T> comparator) {
        Action<MultipleCandidatesDetails<? super T>> rule = AttributeMatchingRules.orderedDisambiguation(comparator, false);
        this.add(rule);
    }

    public void execute(MultipleCandidatesDetails<T> details) {
        State state = new State(details);
        for (Action<? super MultipleCandidatesDetails<T>> action : this.rules) {
            action.execute(state);
            if (!state.determined) continue;
            return;
        }
        if (!state.determined) {
            SelectAllCompatibleRule.apply(details);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class State<T>
    implements MultipleCandidatesDetails<T> {
        private final MultipleCandidatesDetails<T> delegate;
        private boolean determined;

        private State(MultipleCandidatesDetails<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Set<T> getCandidateValues() {
            return this.delegate.getCandidateValues();
        }

        @Override
        public void closestMatch(T candidate) {
            this.determined = true;
            this.delegate.closestMatch(candidate);
        }
    }
}

